/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

#include "imspector.h"

ResponderPlugin::ResponderPlugin()
{
	handle = NULL;
}

ResponderPlugin::~ResponderPlugin()
{
}

bool ResponderPlugin::loadplugin(std::string filename)
{
	handle = dlopen(filename.c_str(), RTLD_LAZY);
	
	if (!handle)
	{
		syslog(LOG_ERR, "dlopen(): %s\n", dlerror());
		return false;
	}
	
	initresponderplugin = (initresponderplugintype) dlsym(handle, "initresponderplugin");
	closeresponderplugin = (closeresponderplugintype) dlsym(handle, "closeresponderplugin");
	generateresponses = (generateresponsestype) dlsym(handle, "generateresponses");
	
	if (!initresponderplugin || !closeresponderplugin || !generateresponses)
	{
		syslog(LOG_ERR, "%s: dlsym(): %s\n", filename.c_str(), dlerror());
		return false;
	}
	
	return true;
}

bool ResponderPlugin::unloadplugin(void)
{
	if (handle) dlclose(handle);
	
	return true;
}

bool ResponderPlugin::callinitresponderplugin(class Options &options, bool debugmode)
{
	return (*initresponderplugin)(responderplugininfo, options, debugmode);
}

void ResponderPlugin::callcloseresponderplugin(void)
{
	return (*closeresponderplugin)();
}

int ResponderPlugin::callgenerateresponses(std::vector<struct imevent> &imevents,
	std::vector<struct response> &responses)
{
	return (*generateresponses)(imevents, responses);
}
