/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICROSSSECTIONPIPELINE_H
#define ICROSSSECTIONPIPELINE_H


#include "iviewsubjectpipeline.h"


class iCrossSectionViewSubject;
class iOrthoPolygonPlaneFilter;
class iOrthoSlicer;
class iOrthoTexturePlaneFilter;

class vtkImageData;


class iCrossSectionPipeline : public iViewSubjectPipeline
{

	friend class iCrossSectionViewSubject;
	
public:
	
	enum
	{
		_Dir = iViewSubjectPipeline::__Last,
		_InterpolateData,
		_Method,
		_Pos,
		_SampleRate,
		_Var,
		__Last
	};

	vtkTypeMacro(iCrossSectionPipeline,iViewSubjectPipeline);

	virtual void UpdateContents(int n, int info = 0);

	virtual void SerialPostProcess(int index);

protected:
	
	iCrossSectionPipeline(iCrossSectionViewSubject *s);
	virtual ~iCrossSectionPipeline();

	virtual void ProduceOutput();
	virtual float GetContentsMemorySize() const;

	//
	//  Pipeline operation
	//
	virtual void UpdateDir();
	virtual void UpdateInterpolateData();
	virtual void UpdateMethod();
	virtual void UpdatePos();
	virtual void UpdateSampleRate();
	virtual void UpdateVar();

	void SetTextureOffset(vtkImageData *input);

	iCrossSectionViewSubject *mParent;

	//
	//  VTK stuff
	//
	iOrthoSlicer *mSlicer;
	iOrthoPolygonPlaneFilter *mPolygonConverter;
	iOrthoTexturePlaneFilter *mTextureConverter;
};

#endif // ICROSSSECTIONPIPELINE_H

