/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013, by the GROMACS development team, led by
 * David van der Spoel, Berk Hess, Erik Lindahl, and including many
 * others, as listed in the AUTHORS file in the top-level source
 * directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS sse4_1_single kernel generator.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

#include "../nb_kernel.h"
#include "types/simple.h"
#include "vec.h"
#include "nrnb.h"

#include "gmx_math_x86_sse4_1_single.h"
#include "kernelutil_x86_sse4_1_single.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecCSTab_VdwCSTab_GeomW3W3_VF_sse4_1_single
 * Electrostatics interaction: CubicSplineTable
 * VdW interaction:            CubicSplineTable
 * Geometry:                   Water3-Water3
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecCSTab_VdwCSTab_GeomW3W3_VF_sse4_1_single
                    (t_nblist * gmx_restrict                nlist,
                     rvec * gmx_restrict                    xx,
                     rvec * gmx_restrict                    ff,
                     t_forcerec * gmx_restrict              fr,
                     t_mdatoms * gmx_restrict               mdatoms,
                     nb_kernel_data_t * gmx_restrict        kernel_data,
                     t_nrnb * gmx_restrict                  nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or 
     * just 0 for non-waters.
     * Suffixes A,B,C,D refer to j loop unrolling done with SSE, e.g. for the four different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD;
    real             scratch[4*DIM];
    __m128           tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128           ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    __m128           ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128           ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B,vdwjidx0C,vdwjidx0D;
    __m128           jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B,vdwjidx1C,vdwjidx1D;
    __m128           jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B,vdwjidx2C,vdwjidx2D;
    __m128           jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    __m128           dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128           dx01,dy01,dz01,rsq01,rinv01,rinvsq01,r01,qq01,c6_01,c12_01;
    __m128           dx02,dy02,dz02,rsq02,rinv02,rinvsq02,r02,qq02,c6_02,c12_02;
    __m128           dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m128           dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128           dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128           dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m128           dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128           dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128           velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m128           rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m128           one_sixth   = _mm_set1_ps(1.0/6.0);
    __m128           one_twelfth = _mm_set1_ps(1.0/12.0);
    __m128i          vfitab;
    __m128i          ifour       = _mm_set1_epi32(4);
    __m128           rt,vfeps,vftabscale,Y,F,G,H,Heps,Fp,VV,FF;
    real             *vftab;
    __m128           dummy_mask,cutoff_mask;
    __m128           signbit = _mm_castsi128_ps( _mm_set1_epi32(0x80000000) );
    __m128           one     = _mm_set1_ps(1.0);
    __m128           two     = _mm_set1_ps(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_ps(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    vftab            = kernel_data->table_elec_vdw->data;
    vftabscale       = _mm_set1_ps(kernel_data->table_elec_vdw->scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+0]));
    iq1              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+1]));
    iq2              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+2]));
    vdwioffset0      = 2*nvdwtype*vdwtype[inr+0];

    jq0              = _mm_set1_ps(charge[inr+0]);
    jq1              = _mm_set1_ps(charge[inr+1]);
    jq2              = _mm_set1_ps(charge[inr+2]);
    vdwjidx0A        = 2*vdwtype[inr+0];
    qq00             = _mm_mul_ps(iq0,jq0);
    c6_00            = _mm_set1_ps(vdwparam[vdwioffset0+vdwjidx0A]);
    c12_00           = _mm_set1_ps(vdwparam[vdwioffset0+vdwjidx0A+1]);
    qq01             = _mm_mul_ps(iq0,jq1);
    qq02             = _mm_mul_ps(iq0,jq2);
    qq10             = _mm_mul_ps(iq1,jq0);
    qq11             = _mm_mul_ps(iq1,jq1);
    qq12             = _mm_mul_ps(iq1,jq2);
    qq20             = _mm_mul_ps(iq2,jq0);
    qq21             = _mm_mul_ps(iq2,jq1);
    qq22             = _mm_mul_ps(iq2,jq2);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_ps(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _mm_setzero_ps();
        fiy0             = _mm_setzero_ps();
        fiz0             = _mm_setzero_ps();
        fix1             = _mm_setzero_ps();
        fiy1             = _mm_setzero_ps();
        fiz1             = _mm_setzero_ps();
        fix2             = _mm_setzero_ps();
        fiy2             = _mm_setzero_ps();
        fiz2             = _mm_setzero_ps();

        /* Reset potential sums */
        velecsum         = _mm_setzero_ps();
        vvdwsum          = _mm_setzero_ps();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+3]>=0; jidx+=4)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_4ptr_swizzle_ps(x+j_coord_offsetA,x+j_coord_offsetB,
                                              x+j_coord_offsetC,x+j_coord_offsetD,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_ps(ix0,jx0);
            dy00             = _mm_sub_ps(iy0,jy0);
            dz00             = _mm_sub_ps(iz0,jz0);
            dx01             = _mm_sub_ps(ix0,jx1);
            dy01             = _mm_sub_ps(iy0,jy1);
            dz01             = _mm_sub_ps(iz0,jz1);
            dx02             = _mm_sub_ps(ix0,jx2);
            dy02             = _mm_sub_ps(iy0,jy2);
            dz02             = _mm_sub_ps(iz0,jz2);
            dx10             = _mm_sub_ps(ix1,jx0);
            dy10             = _mm_sub_ps(iy1,jy0);
            dz10             = _mm_sub_ps(iz1,jz0);
            dx11             = _mm_sub_ps(ix1,jx1);
            dy11             = _mm_sub_ps(iy1,jy1);
            dz11             = _mm_sub_ps(iz1,jz1);
            dx12             = _mm_sub_ps(ix1,jx2);
            dy12             = _mm_sub_ps(iy1,jy2);
            dz12             = _mm_sub_ps(iz1,jz2);
            dx20             = _mm_sub_ps(ix2,jx0);
            dy20             = _mm_sub_ps(iy2,jy0);
            dz20             = _mm_sub_ps(iz2,jz0);
            dx21             = _mm_sub_ps(ix2,jx1);
            dy21             = _mm_sub_ps(iy2,jy1);
            dz21             = _mm_sub_ps(iz2,jz1);
            dx22             = _mm_sub_ps(ix2,jx2);
            dy22             = _mm_sub_ps(iy2,jy2);
            dz22             = _mm_sub_ps(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_ps(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_ps(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_ps(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_ps(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_ps(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_ps(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_ps(dx22,dy22,dz22);

            rinv00           = gmx_mm_invsqrt_ps(rsq00);
            rinv01           = gmx_mm_invsqrt_ps(rsq01);
            rinv02           = gmx_mm_invsqrt_ps(rsq02);
            rinv10           = gmx_mm_invsqrt_ps(rsq10);
            rinv11           = gmx_mm_invsqrt_ps(rsq11);
            rinv12           = gmx_mm_invsqrt_ps(rsq12);
            rinv20           = gmx_mm_invsqrt_ps(rsq20);
            rinv21           = gmx_mm_invsqrt_ps(rsq21);
            rinv22           = gmx_mm_invsqrt_ps(rsq22);

            fjx0             = _mm_setzero_ps();
            fjy0             = _mm_setzero_ps();
            fjz0             = _mm_setzero_ps();
            fjx1             = _mm_setzero_ps();
            fjy1             = _mm_setzero_ps();
            fjz1             = _mm_setzero_ps();
            fjx2             = _mm_setzero_ps();
            fjy2             = _mm_setzero_ps();
            fjz2             = _mm_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_ps(rsq00,rinv00);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r00,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq00,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq00,FF),_mm_mul_ps(vftabscale,rinv00)));

            /* CUBIC SPLINE TABLE DISPERSION */
            vfitab           = _mm_add_epi32(vfitab,ifour);
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            vvdw6            = _mm_mul_ps(c6_00,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            fvdw6            = _mm_mul_ps(c6_00,FF);

            /* CUBIC SPLINE TABLE REPULSION */
            vfitab           = _mm_add_epi32(vfitab,ifour);
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            vvdw12           = _mm_mul_ps(c12_00,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            fvdw12           = _mm_mul_ps(c12_00,FF);
            vvdw             = _mm_add_ps(vvdw12,vvdw6);
            fvdw             = _mm_xor_ps(signbit,_mm_mul_ps(_mm_add_ps(fvdw6,fvdw12),_mm_mul_ps(vftabscale,rinv00)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);
            vvdwsum          = _mm_add_ps(vvdwsum,vvdw);

            fscal            = _mm_add_ps(felec,fvdw);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx00);
            ty               = _mm_mul_ps(fscal,dy00);
            tz               = _mm_mul_ps(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r01              = _mm_mul_ps(rsq01,rinv01);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r01,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq01,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq01,FF),_mm_mul_ps(vftabscale,rinv01)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx01);
            ty               = _mm_mul_ps(fscal,dy01);
            tz               = _mm_mul_ps(fscal,dz01);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r02              = _mm_mul_ps(rsq02,rinv02);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r02,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq02,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq02,FF),_mm_mul_ps(vftabscale,rinv02)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx02);
            ty               = _mm_mul_ps(fscal,dy02);
            tz               = _mm_mul_ps(fscal,dz02);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r10              = _mm_mul_ps(rsq10,rinv10);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r10,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq10,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq10,FF),_mm_mul_ps(vftabscale,rinv10)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx10);
            ty               = _mm_mul_ps(fscal,dy10);
            tz               = _mm_mul_ps(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _mm_mul_ps(rsq11,rinv11);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r11,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq11,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq11,FF),_mm_mul_ps(vftabscale,rinv11)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx11);
            ty               = _mm_mul_ps(fscal,dy11);
            tz               = _mm_mul_ps(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _mm_mul_ps(rsq12,rinv12);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r12,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq12,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq12,FF),_mm_mul_ps(vftabscale,rinv12)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx12);
            ty               = _mm_mul_ps(fscal,dy12);
            tz               = _mm_mul_ps(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r20              = _mm_mul_ps(rsq20,rinv20);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r20,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq20,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq20,FF),_mm_mul_ps(vftabscale,rinv20)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx20);
            ty               = _mm_mul_ps(fscal,dy20);
            tz               = _mm_mul_ps(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _mm_mul_ps(rsq21,rinv21);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r21,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq21,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq21,FF),_mm_mul_ps(vftabscale,rinv21)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx21);
            ty               = _mm_mul_ps(fscal,dy21);
            tz               = _mm_mul_ps(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _mm_mul_ps(rsq22,rinv22);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r22,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq22,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq22,FF),_mm_mul_ps(vftabscale,rinv22)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx22);
            ty               = _mm_mul_ps(fscal,dy22);
            tz               = _mm_mul_ps(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;

            gmx_mm_decrement_3rvec_4ptr_swizzle_ps(fjptrA,fjptrB,fjptrC,fjptrD,
                                                   fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 417 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_ps(mask,val) to clear dummy entries.
             */
            dummy_mask = gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128()));
            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_4ptr_swizzle_ps(x+j_coord_offsetA,x+j_coord_offsetB,
                                              x+j_coord_offsetC,x+j_coord_offsetD,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_ps(ix0,jx0);
            dy00             = _mm_sub_ps(iy0,jy0);
            dz00             = _mm_sub_ps(iz0,jz0);
            dx01             = _mm_sub_ps(ix0,jx1);
            dy01             = _mm_sub_ps(iy0,jy1);
            dz01             = _mm_sub_ps(iz0,jz1);
            dx02             = _mm_sub_ps(ix0,jx2);
            dy02             = _mm_sub_ps(iy0,jy2);
            dz02             = _mm_sub_ps(iz0,jz2);
            dx10             = _mm_sub_ps(ix1,jx0);
            dy10             = _mm_sub_ps(iy1,jy0);
            dz10             = _mm_sub_ps(iz1,jz0);
            dx11             = _mm_sub_ps(ix1,jx1);
            dy11             = _mm_sub_ps(iy1,jy1);
            dz11             = _mm_sub_ps(iz1,jz1);
            dx12             = _mm_sub_ps(ix1,jx2);
            dy12             = _mm_sub_ps(iy1,jy2);
            dz12             = _mm_sub_ps(iz1,jz2);
            dx20             = _mm_sub_ps(ix2,jx0);
            dy20             = _mm_sub_ps(iy2,jy0);
            dz20             = _mm_sub_ps(iz2,jz0);
            dx21             = _mm_sub_ps(ix2,jx1);
            dy21             = _mm_sub_ps(iy2,jy1);
            dz21             = _mm_sub_ps(iz2,jz1);
            dx22             = _mm_sub_ps(ix2,jx2);
            dy22             = _mm_sub_ps(iy2,jy2);
            dz22             = _mm_sub_ps(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_ps(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_ps(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_ps(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_ps(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_ps(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_ps(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_ps(dx22,dy22,dz22);

            rinv00           = gmx_mm_invsqrt_ps(rsq00);
            rinv01           = gmx_mm_invsqrt_ps(rsq01);
            rinv02           = gmx_mm_invsqrt_ps(rsq02);
            rinv10           = gmx_mm_invsqrt_ps(rsq10);
            rinv11           = gmx_mm_invsqrt_ps(rsq11);
            rinv12           = gmx_mm_invsqrt_ps(rsq12);
            rinv20           = gmx_mm_invsqrt_ps(rsq20);
            rinv21           = gmx_mm_invsqrt_ps(rsq21);
            rinv22           = gmx_mm_invsqrt_ps(rsq22);

            fjx0             = _mm_setzero_ps();
            fjy0             = _mm_setzero_ps();
            fjz0             = _mm_setzero_ps();
            fjx1             = _mm_setzero_ps();
            fjy1             = _mm_setzero_ps();
            fjz1             = _mm_setzero_ps();
            fjx2             = _mm_setzero_ps();
            fjy2             = _mm_setzero_ps();
            fjz2             = _mm_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_ps(rsq00,rinv00);
            r00              = _mm_andnot_ps(dummy_mask,r00);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r00,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq00,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq00,FF),_mm_mul_ps(vftabscale,rinv00)));

            /* CUBIC SPLINE TABLE DISPERSION */
            vfitab           = _mm_add_epi32(vfitab,ifour);
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            vvdw6            = _mm_mul_ps(c6_00,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            fvdw6            = _mm_mul_ps(c6_00,FF);

            /* CUBIC SPLINE TABLE REPULSION */
            vfitab           = _mm_add_epi32(vfitab,ifour);
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            vvdw12           = _mm_mul_ps(c12_00,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            fvdw12           = _mm_mul_ps(c12_00,FF);
            vvdw             = _mm_add_ps(vvdw12,vvdw6);
            fvdw             = _mm_xor_ps(signbit,_mm_mul_ps(_mm_add_ps(fvdw6,fvdw12),_mm_mul_ps(vftabscale,rinv00)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);
            vvdw             = _mm_andnot_ps(dummy_mask,vvdw);
            vvdwsum          = _mm_add_ps(vvdwsum,vvdw);

            fscal            = _mm_add_ps(felec,fvdw);

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx00);
            ty               = _mm_mul_ps(fscal,dy00);
            tz               = _mm_mul_ps(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r01              = _mm_mul_ps(rsq01,rinv01);
            r01              = _mm_andnot_ps(dummy_mask,r01);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r01,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq01,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq01,FF),_mm_mul_ps(vftabscale,rinv01)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx01);
            ty               = _mm_mul_ps(fscal,dy01);
            tz               = _mm_mul_ps(fscal,dz01);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r02              = _mm_mul_ps(rsq02,rinv02);
            r02              = _mm_andnot_ps(dummy_mask,r02);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r02,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq02,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq02,FF),_mm_mul_ps(vftabscale,rinv02)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx02);
            ty               = _mm_mul_ps(fscal,dy02);
            tz               = _mm_mul_ps(fscal,dz02);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r10              = _mm_mul_ps(rsq10,rinv10);
            r10              = _mm_andnot_ps(dummy_mask,r10);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r10,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq10,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq10,FF),_mm_mul_ps(vftabscale,rinv10)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx10);
            ty               = _mm_mul_ps(fscal,dy10);
            tz               = _mm_mul_ps(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _mm_mul_ps(rsq11,rinv11);
            r11              = _mm_andnot_ps(dummy_mask,r11);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r11,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq11,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq11,FF),_mm_mul_ps(vftabscale,rinv11)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx11);
            ty               = _mm_mul_ps(fscal,dy11);
            tz               = _mm_mul_ps(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _mm_mul_ps(rsq12,rinv12);
            r12              = _mm_andnot_ps(dummy_mask,r12);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r12,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq12,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq12,FF),_mm_mul_ps(vftabscale,rinv12)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx12);
            ty               = _mm_mul_ps(fscal,dy12);
            tz               = _mm_mul_ps(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r20              = _mm_mul_ps(rsq20,rinv20);
            r20              = _mm_andnot_ps(dummy_mask,r20);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r20,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq20,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq20,FF),_mm_mul_ps(vftabscale,rinv20)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx20);
            ty               = _mm_mul_ps(fscal,dy20);
            tz               = _mm_mul_ps(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _mm_mul_ps(rsq21,rinv21);
            r21              = _mm_andnot_ps(dummy_mask,r21);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r21,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq21,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq21,FF),_mm_mul_ps(vftabscale,rinv21)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx21);
            ty               = _mm_mul_ps(fscal,dy21);
            tz               = _mm_mul_ps(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _mm_mul_ps(rsq22,rinv22);
            r22              = _mm_andnot_ps(dummy_mask,r22);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r22,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            VV               = _mm_add_ps(Y,_mm_mul_ps(vfeps,Fp));
            velec            = _mm_mul_ps(qq22,VV);
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq22,FF),_mm_mul_ps(vftabscale,rinv22)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx22);
            ty               = _mm_mul_ps(fscal,dy22);
            tz               = _mm_mul_ps(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;

            gmx_mm_decrement_3rvec_4ptr_swizzle_ps(fjptrA,fjptrB,fjptrC,fjptrD,
                                                   fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 426 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_ps(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                              f+i_coord_offset,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm_update_1pot_ps(velecsum,kernel_data->energygrp_elec+ggid);
        gmx_mm_update_1pot_ps(vvdwsum,kernel_data->energygrp_vdw+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 20 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W3W3_VF,outeriter*20 + inneriter*426);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecCSTab_VdwCSTab_GeomW3W3_F_sse4_1_single
 * Electrostatics interaction: CubicSplineTable
 * VdW interaction:            CubicSplineTable
 * Geometry:                   Water3-Water3
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecCSTab_VdwCSTab_GeomW3W3_F_sse4_1_single
                    (t_nblist * gmx_restrict                nlist,
                     rvec * gmx_restrict                    xx,
                     rvec * gmx_restrict                    ff,
                     t_forcerec * gmx_restrict              fr,
                     t_mdatoms * gmx_restrict               mdatoms,
                     nb_kernel_data_t * gmx_restrict        kernel_data,
                     t_nrnb * gmx_restrict                  nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or 
     * just 0 for non-waters.
     * Suffixes A,B,C,D refer to j loop unrolling done with SSE, e.g. for the four different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD;
    real             scratch[4*DIM];
    __m128           tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128           ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    __m128           ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128           ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B,vdwjidx0C,vdwjidx0D;
    __m128           jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B,vdwjidx1C,vdwjidx1D;
    __m128           jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B,vdwjidx2C,vdwjidx2D;
    __m128           jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    __m128           dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128           dx01,dy01,dz01,rsq01,rinv01,rinvsq01,r01,qq01,c6_01,c12_01;
    __m128           dx02,dy02,dz02,rsq02,rinv02,rinvsq02,r02,qq02,c6_02,c12_02;
    __m128           dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m128           dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128           dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128           dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m128           dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128           dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128           velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m128           rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m128           one_sixth   = _mm_set1_ps(1.0/6.0);
    __m128           one_twelfth = _mm_set1_ps(1.0/12.0);
    __m128i          vfitab;
    __m128i          ifour       = _mm_set1_epi32(4);
    __m128           rt,vfeps,vftabscale,Y,F,G,H,Heps,Fp,VV,FF;
    real             *vftab;
    __m128           dummy_mask,cutoff_mask;
    __m128           signbit = _mm_castsi128_ps( _mm_set1_epi32(0x80000000) );
    __m128           one     = _mm_set1_ps(1.0);
    __m128           two     = _mm_set1_ps(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_ps(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    vftab            = kernel_data->table_elec_vdw->data;
    vftabscale       = _mm_set1_ps(kernel_data->table_elec_vdw->scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+0]));
    iq1              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+1]));
    iq2              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+2]));
    vdwioffset0      = 2*nvdwtype*vdwtype[inr+0];

    jq0              = _mm_set1_ps(charge[inr+0]);
    jq1              = _mm_set1_ps(charge[inr+1]);
    jq2              = _mm_set1_ps(charge[inr+2]);
    vdwjidx0A        = 2*vdwtype[inr+0];
    qq00             = _mm_mul_ps(iq0,jq0);
    c6_00            = _mm_set1_ps(vdwparam[vdwioffset0+vdwjidx0A]);
    c12_00           = _mm_set1_ps(vdwparam[vdwioffset0+vdwjidx0A+1]);
    qq01             = _mm_mul_ps(iq0,jq1);
    qq02             = _mm_mul_ps(iq0,jq2);
    qq10             = _mm_mul_ps(iq1,jq0);
    qq11             = _mm_mul_ps(iq1,jq1);
    qq12             = _mm_mul_ps(iq1,jq2);
    qq20             = _mm_mul_ps(iq2,jq0);
    qq21             = _mm_mul_ps(iq2,jq1);
    qq22             = _mm_mul_ps(iq2,jq2);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_ps(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _mm_setzero_ps();
        fiy0             = _mm_setzero_ps();
        fiz0             = _mm_setzero_ps();
        fix1             = _mm_setzero_ps();
        fiy1             = _mm_setzero_ps();
        fiz1             = _mm_setzero_ps();
        fix2             = _mm_setzero_ps();
        fiy2             = _mm_setzero_ps();
        fiz2             = _mm_setzero_ps();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+3]>=0; jidx+=4)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_4ptr_swizzle_ps(x+j_coord_offsetA,x+j_coord_offsetB,
                                              x+j_coord_offsetC,x+j_coord_offsetD,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_ps(ix0,jx0);
            dy00             = _mm_sub_ps(iy0,jy0);
            dz00             = _mm_sub_ps(iz0,jz0);
            dx01             = _mm_sub_ps(ix0,jx1);
            dy01             = _mm_sub_ps(iy0,jy1);
            dz01             = _mm_sub_ps(iz0,jz1);
            dx02             = _mm_sub_ps(ix0,jx2);
            dy02             = _mm_sub_ps(iy0,jy2);
            dz02             = _mm_sub_ps(iz0,jz2);
            dx10             = _mm_sub_ps(ix1,jx0);
            dy10             = _mm_sub_ps(iy1,jy0);
            dz10             = _mm_sub_ps(iz1,jz0);
            dx11             = _mm_sub_ps(ix1,jx1);
            dy11             = _mm_sub_ps(iy1,jy1);
            dz11             = _mm_sub_ps(iz1,jz1);
            dx12             = _mm_sub_ps(ix1,jx2);
            dy12             = _mm_sub_ps(iy1,jy2);
            dz12             = _mm_sub_ps(iz1,jz2);
            dx20             = _mm_sub_ps(ix2,jx0);
            dy20             = _mm_sub_ps(iy2,jy0);
            dz20             = _mm_sub_ps(iz2,jz0);
            dx21             = _mm_sub_ps(ix2,jx1);
            dy21             = _mm_sub_ps(iy2,jy1);
            dz21             = _mm_sub_ps(iz2,jz1);
            dx22             = _mm_sub_ps(ix2,jx2);
            dy22             = _mm_sub_ps(iy2,jy2);
            dz22             = _mm_sub_ps(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_ps(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_ps(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_ps(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_ps(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_ps(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_ps(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_ps(dx22,dy22,dz22);

            rinv00           = gmx_mm_invsqrt_ps(rsq00);
            rinv01           = gmx_mm_invsqrt_ps(rsq01);
            rinv02           = gmx_mm_invsqrt_ps(rsq02);
            rinv10           = gmx_mm_invsqrt_ps(rsq10);
            rinv11           = gmx_mm_invsqrt_ps(rsq11);
            rinv12           = gmx_mm_invsqrt_ps(rsq12);
            rinv20           = gmx_mm_invsqrt_ps(rsq20);
            rinv21           = gmx_mm_invsqrt_ps(rsq21);
            rinv22           = gmx_mm_invsqrt_ps(rsq22);

            fjx0             = _mm_setzero_ps();
            fjy0             = _mm_setzero_ps();
            fjz0             = _mm_setzero_ps();
            fjx1             = _mm_setzero_ps();
            fjy1             = _mm_setzero_ps();
            fjz1             = _mm_setzero_ps();
            fjx2             = _mm_setzero_ps();
            fjy2             = _mm_setzero_ps();
            fjz2             = _mm_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_ps(rsq00,rinv00);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r00,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq00,FF),_mm_mul_ps(vftabscale,rinv00)));

            /* CUBIC SPLINE TABLE DISPERSION */
            vfitab           = _mm_add_epi32(vfitab,ifour);
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            fvdw6            = _mm_mul_ps(c6_00,FF);

            /* CUBIC SPLINE TABLE REPULSION */
            vfitab           = _mm_add_epi32(vfitab,ifour);
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            fvdw12           = _mm_mul_ps(c12_00,FF);
            fvdw             = _mm_xor_ps(signbit,_mm_mul_ps(_mm_add_ps(fvdw6,fvdw12),_mm_mul_ps(vftabscale,rinv00)));

            fscal            = _mm_add_ps(felec,fvdw);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx00);
            ty               = _mm_mul_ps(fscal,dy00);
            tz               = _mm_mul_ps(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r01              = _mm_mul_ps(rsq01,rinv01);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r01,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq01,FF),_mm_mul_ps(vftabscale,rinv01)));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx01);
            ty               = _mm_mul_ps(fscal,dy01);
            tz               = _mm_mul_ps(fscal,dz01);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r02              = _mm_mul_ps(rsq02,rinv02);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r02,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq02,FF),_mm_mul_ps(vftabscale,rinv02)));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx02);
            ty               = _mm_mul_ps(fscal,dy02);
            tz               = _mm_mul_ps(fscal,dz02);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r10              = _mm_mul_ps(rsq10,rinv10);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r10,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq10,FF),_mm_mul_ps(vftabscale,rinv10)));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx10);
            ty               = _mm_mul_ps(fscal,dy10);
            tz               = _mm_mul_ps(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _mm_mul_ps(rsq11,rinv11);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r11,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq11,FF),_mm_mul_ps(vftabscale,rinv11)));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx11);
            ty               = _mm_mul_ps(fscal,dy11);
            tz               = _mm_mul_ps(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _mm_mul_ps(rsq12,rinv12);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r12,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq12,FF),_mm_mul_ps(vftabscale,rinv12)));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx12);
            ty               = _mm_mul_ps(fscal,dy12);
            tz               = _mm_mul_ps(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r20              = _mm_mul_ps(rsq20,rinv20);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r20,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq20,FF),_mm_mul_ps(vftabscale,rinv20)));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx20);
            ty               = _mm_mul_ps(fscal,dy20);
            tz               = _mm_mul_ps(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _mm_mul_ps(rsq21,rinv21);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r21,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq21,FF),_mm_mul_ps(vftabscale,rinv21)));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx21);
            ty               = _mm_mul_ps(fscal,dy21);
            tz               = _mm_mul_ps(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _mm_mul_ps(rsq22,rinv22);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r22,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq22,FF),_mm_mul_ps(vftabscale,rinv22)));

            fscal            = felec;

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx22);
            ty               = _mm_mul_ps(fscal,dy22);
            tz               = _mm_mul_ps(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;

            gmx_mm_decrement_3rvec_4ptr_swizzle_ps(fjptrA,fjptrB,fjptrC,fjptrD,
                                                   fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 373 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_ps(mask,val) to clear dummy entries.
             */
            dummy_mask = gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128()));
            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_4ptr_swizzle_ps(x+j_coord_offsetA,x+j_coord_offsetB,
                                              x+j_coord_offsetC,x+j_coord_offsetD,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _mm_sub_ps(ix0,jx0);
            dy00             = _mm_sub_ps(iy0,jy0);
            dz00             = _mm_sub_ps(iz0,jz0);
            dx01             = _mm_sub_ps(ix0,jx1);
            dy01             = _mm_sub_ps(iy0,jy1);
            dz01             = _mm_sub_ps(iz0,jz1);
            dx02             = _mm_sub_ps(ix0,jx2);
            dy02             = _mm_sub_ps(iy0,jy2);
            dz02             = _mm_sub_ps(iz0,jz2);
            dx10             = _mm_sub_ps(ix1,jx0);
            dy10             = _mm_sub_ps(iy1,jy0);
            dz10             = _mm_sub_ps(iz1,jz0);
            dx11             = _mm_sub_ps(ix1,jx1);
            dy11             = _mm_sub_ps(iy1,jy1);
            dz11             = _mm_sub_ps(iz1,jz1);
            dx12             = _mm_sub_ps(ix1,jx2);
            dy12             = _mm_sub_ps(iy1,jy2);
            dz12             = _mm_sub_ps(iz1,jz2);
            dx20             = _mm_sub_ps(ix2,jx0);
            dy20             = _mm_sub_ps(iy2,jy0);
            dz20             = _mm_sub_ps(iz2,jz0);
            dx21             = _mm_sub_ps(ix2,jx1);
            dy21             = _mm_sub_ps(iy2,jy1);
            dz21             = _mm_sub_ps(iz2,jz1);
            dx22             = _mm_sub_ps(ix2,jx2);
            dy22             = _mm_sub_ps(iy2,jy2);
            dz22             = _mm_sub_ps(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_ps(dx00,dy00,dz00);
            rsq01            = gmx_mm_calc_rsq_ps(dx01,dy01,dz01);
            rsq02            = gmx_mm_calc_rsq_ps(dx02,dy02,dz02);
            rsq10            = gmx_mm_calc_rsq_ps(dx10,dy10,dz10);
            rsq11            = gmx_mm_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_ps(dx12,dy12,dz12);
            rsq20            = gmx_mm_calc_rsq_ps(dx20,dy20,dz20);
            rsq21            = gmx_mm_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_ps(dx22,dy22,dz22);

            rinv00           = gmx_mm_invsqrt_ps(rsq00);
            rinv01           = gmx_mm_invsqrt_ps(rsq01);
            rinv02           = gmx_mm_invsqrt_ps(rsq02);
            rinv10           = gmx_mm_invsqrt_ps(rsq10);
            rinv11           = gmx_mm_invsqrt_ps(rsq11);
            rinv12           = gmx_mm_invsqrt_ps(rsq12);
            rinv20           = gmx_mm_invsqrt_ps(rsq20);
            rinv21           = gmx_mm_invsqrt_ps(rsq21);
            rinv22           = gmx_mm_invsqrt_ps(rsq22);

            fjx0             = _mm_setzero_ps();
            fjy0             = _mm_setzero_ps();
            fjz0             = _mm_setzero_ps();
            fjx1             = _mm_setzero_ps();
            fjy1             = _mm_setzero_ps();
            fjz1             = _mm_setzero_ps();
            fjx2             = _mm_setzero_ps();
            fjy2             = _mm_setzero_ps();
            fjz2             = _mm_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r00              = _mm_mul_ps(rsq00,rinv00);
            r00              = _mm_andnot_ps(dummy_mask,r00);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r00,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq00,FF),_mm_mul_ps(vftabscale,rinv00)));

            /* CUBIC SPLINE TABLE DISPERSION */
            vfitab           = _mm_add_epi32(vfitab,ifour);
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            fvdw6            = _mm_mul_ps(c6_00,FF);

            /* CUBIC SPLINE TABLE REPULSION */
            vfitab           = _mm_add_epi32(vfitab,ifour);
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            fvdw12           = _mm_mul_ps(c12_00,FF);
            fvdw             = _mm_xor_ps(signbit,_mm_mul_ps(_mm_add_ps(fvdw6,fvdw12),_mm_mul_ps(vftabscale,rinv00)));

            fscal            = _mm_add_ps(felec,fvdw);

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx00);
            ty               = _mm_mul_ps(fscal,dy00);
            tz               = _mm_mul_ps(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r01              = _mm_mul_ps(rsq01,rinv01);
            r01              = _mm_andnot_ps(dummy_mask,r01);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r01,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq01,FF),_mm_mul_ps(vftabscale,rinv01)));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx01);
            ty               = _mm_mul_ps(fscal,dy01);
            tz               = _mm_mul_ps(fscal,dz01);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r02              = _mm_mul_ps(rsq02,rinv02);
            r02              = _mm_andnot_ps(dummy_mask,r02);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r02,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq02,FF),_mm_mul_ps(vftabscale,rinv02)));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx02);
            ty               = _mm_mul_ps(fscal,dy02);
            tz               = _mm_mul_ps(fscal,dz02);

            /* Update vectorial force */
            fix0             = _mm_add_ps(fix0,tx);
            fiy0             = _mm_add_ps(fiy0,ty);
            fiz0             = _mm_add_ps(fiz0,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r10              = _mm_mul_ps(rsq10,rinv10);
            r10              = _mm_andnot_ps(dummy_mask,r10);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r10,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq10,FF),_mm_mul_ps(vftabscale,rinv10)));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx10);
            ty               = _mm_mul_ps(fscal,dy10);
            tz               = _mm_mul_ps(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _mm_mul_ps(rsq11,rinv11);
            r11              = _mm_andnot_ps(dummy_mask,r11);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r11,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq11,FF),_mm_mul_ps(vftabscale,rinv11)));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx11);
            ty               = _mm_mul_ps(fscal,dy11);
            tz               = _mm_mul_ps(fscal,dz11);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _mm_mul_ps(rsq12,rinv12);
            r12              = _mm_andnot_ps(dummy_mask,r12);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r12,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq12,FF),_mm_mul_ps(vftabscale,rinv12)));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx12);
            ty               = _mm_mul_ps(fscal,dy12);
            tz               = _mm_mul_ps(fscal,dz12);

            /* Update vectorial force */
            fix1             = _mm_add_ps(fix1,tx);
            fiy1             = _mm_add_ps(fiy1,ty);
            fiz1             = _mm_add_ps(fiz1,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r20              = _mm_mul_ps(rsq20,rinv20);
            r20              = _mm_andnot_ps(dummy_mask,r20);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r20,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq20,FF),_mm_mul_ps(vftabscale,rinv20)));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx20);
            ty               = _mm_mul_ps(fscal,dy20);
            tz               = _mm_mul_ps(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx0             = _mm_add_ps(fjx0,tx);
            fjy0             = _mm_add_ps(fjy0,ty);
            fjz0             = _mm_add_ps(fjz0,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _mm_mul_ps(rsq21,rinv21);
            r21              = _mm_andnot_ps(dummy_mask,r21);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r21,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq21,FF),_mm_mul_ps(vftabscale,rinv21)));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx21);
            ty               = _mm_mul_ps(fscal,dy21);
            tz               = _mm_mul_ps(fscal,dz21);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx1             = _mm_add_ps(fjx1,tx);
            fjy1             = _mm_add_ps(fjy1,ty);
            fjz1             = _mm_add_ps(fjz1,tz);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _mm_mul_ps(rsq22,rinv22);
            r22              = _mm_andnot_ps(dummy_mask,r22);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _mm_mul_ps(r22,vftabscale);
            vfitab           = _mm_cvttps_epi32(rt);
            vfeps            = _mm_sub_ps(rt,_mm_round_ps(rt, _MM_FROUND_FLOOR));
            vfitab           = _mm_slli_epi32(_mm_add_epi32(vfitab,_mm_slli_epi32(vfitab,1)),2);

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,0) );
            F                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,1) );
            G                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,2) );
            H                = _mm_load_ps( vftab + gmx_mm_extract_epi32(vfitab,3) );
            _MM_TRANSPOSE4_PS(Y,F,G,H);
            Heps             = _mm_mul_ps(vfeps,H);
            Fp               = _mm_add_ps(F,_mm_mul_ps(vfeps,_mm_add_ps(G,Heps)));
            FF               = _mm_add_ps(Fp,_mm_mul_ps(vfeps,_mm_add_ps(G,_mm_add_ps(Heps,Heps))));
            felec            = _mm_xor_ps(signbit,_mm_mul_ps(_mm_mul_ps(qq22,FF),_mm_mul_ps(vftabscale,rinv22)));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_ps(fscal,dx22);
            ty               = _mm_mul_ps(fscal,dy22);
            tz               = _mm_mul_ps(fscal,dz22);

            /* Update vectorial force */
            fix2             = _mm_add_ps(fix2,tx);
            fiy2             = _mm_add_ps(fiy2,ty);
            fiz2             = _mm_add_ps(fiz2,tz);

            fjx2             = _mm_add_ps(fjx2,tx);
            fjy2             = _mm_add_ps(fjy2,ty);
            fjz2             = _mm_add_ps(fjz2,tz);

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;

            gmx_mm_decrement_3rvec_4ptr_swizzle_ps(fjptrA,fjptrB,fjptrC,fjptrD,
                                                   fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 382 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_ps(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                              f+i_coord_offset,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 18 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W3W3_F,outeriter*18 + inneriter*382);
}
