/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.BpStatus;
import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.HrType;
import com.garmin.fit.Mesg;

public class BloodPressureMesg
extends Mesg {
    protected static final Mesg bloodPressureMesg = new Mesg("blood_pressure", 51);

    public BloodPressureMesg() {
        super(Factory.createMesg(51));
    }

    public BloodPressureMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public Integer getSystolicPressure() {
        return this.getFieldIntegerValue(0, 0, 65535);
    }

    public void setSystolicPressure(Integer n) {
        this.setFieldValue(0, 0, (Object)n, 65535);
    }

    public Integer getDiastolicPressure() {
        return this.getFieldIntegerValue(1, 0, 65535);
    }

    public void setDiastolicPressure(Integer n) {
        this.setFieldValue(1, 0, (Object)n, 65535);
    }

    public Integer getMeanArterialPressure() {
        return this.getFieldIntegerValue(2, 0, 65535);
    }

    public void setMeanArterialPressure(Integer n) {
        this.setFieldValue(2, 0, (Object)n, 65535);
    }

    public Integer getMap3SampleMean() {
        return this.getFieldIntegerValue(3, 0, 65535);
    }

    public void setMap3SampleMean(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 65535);
    }

    public Integer getMapMorningValues() {
        return this.getFieldIntegerValue(4, 0, 65535);
    }

    public void setMapMorningValues(Integer n) {
        this.setFieldValue(4, 0, (Object)n, 65535);
    }

    public Integer getMapEveningValues() {
        return this.getFieldIntegerValue(5, 0, 65535);
    }

    public void setMapEveningValues(Integer n) {
        this.setFieldValue(5, 0, (Object)n, 65535);
    }

    public Short getHeartRate() {
        return this.getFieldShortValue(6, 0, 65535);
    }

    public void setHeartRate(Short s) {
        this.setFieldValue(6, 0, (Object)s, 65535);
    }

    public HrType getHeartRateType() {
        Short s = this.getFieldShortValue(7, 0, 65535);
        if (s == null) {
            return null;
        }
        return HrType.getByValue(s);
    }

    public void setHeartRateType(HrType hrType) {
        this.setFieldValue(7, 0, (Object)hrType.value, 65535);
    }

    public BpStatus getStatus() {
        Short s = this.getFieldShortValue(8, 0, 65535);
        if (s == null) {
            return null;
        }
        return BpStatus.getByValue(s);
    }

    public void setStatus(BpStatus bpStatus) {
        this.setFieldValue(8, 0, (Object)bpStatus.value, 65535);
    }

    public Integer getUserProfileIndex() {
        return this.getFieldIntegerValue(9, 0, 65535);
    }

    public void setUserProfileIndex(Integer n) {
        this.setFieldValue(9, 0, (Object)n, 65535);
    }

    static {
        bloodPressureMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false));
        bloodPressureMesg.addField(new Field("systolic_pressure", 0, 132, 1.0, 0.0, "mmHg", false));
        bloodPressureMesg.addField(new Field("diastolic_pressure", 1, 132, 1.0, 0.0, "mmHg", false));
        bloodPressureMesg.addField(new Field("mean_arterial_pressure", 2, 132, 1.0, 0.0, "mmHg", false));
        bloodPressureMesg.addField(new Field("map_3_sample_mean", 3, 132, 1.0, 0.0, "mmHg", false));
        bloodPressureMesg.addField(new Field("map_morning_values", 4, 132, 1.0, 0.0, "mmHg", false));
        bloodPressureMesg.addField(new Field("map_evening_values", 5, 132, 1.0, 0.0, "mmHg", false));
        bloodPressureMesg.addField(new Field("heart_rate", 6, 2, 1.0, 0.0, "bpm", false));
        bloodPressureMesg.addField(new Field("heart_rate_type", 7, 0, 1.0, 0.0, "", false));
        bloodPressureMesg.addField(new Field("status", 8, 0, 1.0, 0.0, "", false));
        bloodPressureMesg.addField(new Field("user_profile_index", 9, 132, 1.0, 0.0, "", false));
    }
}

