// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/account_budget_proposal.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An account-level budget proposal.
//
// All fields prefixed with 'proposed' may not necessarily be applied directly.
// For example, proposed spending limits may be adjusted before their
// application.  This is true if the 'proposed' field has an 'approved'
// counterpart, e.g. spending limits.
//
// Please note that the proposal type (proposal_type) changes which fields are
// required and which must remain empty.
type AccountBudgetProposal struct {
	// Immutable. The resource name of the proposal.
	// AccountBudgetProposal resource names have the form:
	//
	// `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the proposal.
	Id *wrappers.Int64Value `protobuf:"bytes,14,opt,name=id,proto3" json:"id,omitempty"`
	// Immutable. The resource name of the billing setup associated with this proposal.
	BillingSetup *wrappers.StringValue `protobuf:"bytes,2,opt,name=billing_setup,json=billingSetup,proto3" json:"billing_setup,omitempty"`
	// Immutable. The resource name of the account-level budget associated with this
	// proposal.
	AccountBudget *wrappers.StringValue `protobuf:"bytes,3,opt,name=account_budget,json=accountBudget,proto3" json:"account_budget,omitempty"`
	// Immutable. The type of this proposal, e.g. END to end the budget associated with this
	// proposal.
	ProposalType enums.AccountBudgetProposalTypeEnum_AccountBudgetProposalType `protobuf:"varint,4,opt,name=proposal_type,json=proposalType,proto3,enum=google.ads.googleads.v3.enums.AccountBudgetProposalTypeEnum_AccountBudgetProposalType" json:"proposal_type,omitempty"`
	// Output only. The status of this proposal.
	// When a new proposal is created, the status defaults to PENDING.
	Status enums.AccountBudgetProposalStatusEnum_AccountBudgetProposalStatus `protobuf:"varint,15,opt,name=status,proto3,enum=google.ads.googleads.v3.enums.AccountBudgetProposalStatusEnum_AccountBudgetProposalStatus" json:"status,omitempty"`
	// Immutable. The name to assign to the account-level budget.
	ProposedName *wrappers.StringValue `protobuf:"bytes,5,opt,name=proposed_name,json=proposedName,proto3" json:"proposed_name,omitempty"`
	// Output only. The approved start date time in yyyy-mm-dd hh:mm:ss format.
	ApprovedStartDateTime *wrappers.StringValue `protobuf:"bytes,20,opt,name=approved_start_date_time,json=approvedStartDateTime,proto3" json:"approved_start_date_time,omitempty"`
	// Immutable. A purchase order number is a value that enables the user to help them
	// reference this budget in their monthly invoices.
	ProposedPurchaseOrderNumber *wrappers.StringValue `protobuf:"bytes,12,opt,name=proposed_purchase_order_number,json=proposedPurchaseOrderNumber,proto3" json:"proposed_purchase_order_number,omitempty"`
	// Immutable. Notes associated with this budget.
	ProposedNotes *wrappers.StringValue `protobuf:"bytes,13,opt,name=proposed_notes,json=proposedNotes,proto3" json:"proposed_notes,omitempty"`
	// Output only. The date time when this account-level budget proposal was created, which is
	// not the same as its approval date time, if applicable.
	CreationDateTime *wrappers.StringValue `protobuf:"bytes,16,opt,name=creation_date_time,json=creationDateTime,proto3" json:"creation_date_time,omitempty"`
	// Output only. The date time when this account-level budget was approved, if applicable.
	ApprovalDateTime *wrappers.StringValue `protobuf:"bytes,17,opt,name=approval_date_time,json=approvalDateTime,proto3" json:"approval_date_time,omitempty"`
	// The proposed start date time of the account-level budget, which cannot be
	// in the past.
	//
	// Types that are valid to be assigned to ProposedStartTime:
	//	*AccountBudgetProposal_ProposedStartDateTime
	//	*AccountBudgetProposal_ProposedStartTimeType
	ProposedStartTime isAccountBudgetProposal_ProposedStartTime `protobuf_oneof:"proposed_start_time"`
	// The proposed end date time of the account-level budget, which cannot be in
	// the past.
	//
	// Types that are valid to be assigned to ProposedEndTime:
	//	*AccountBudgetProposal_ProposedEndDateTime
	//	*AccountBudgetProposal_ProposedEndTimeType
	ProposedEndTime isAccountBudgetProposal_ProposedEndTime `protobuf_oneof:"proposed_end_time"`
	// The approved end date time of the account-level budget.
	//
	// Types that are valid to be assigned to ApprovedEndTime:
	//	*AccountBudgetProposal_ApprovedEndDateTime
	//	*AccountBudgetProposal_ApprovedEndTimeType
	ApprovedEndTime isAccountBudgetProposal_ApprovedEndTime `protobuf_oneof:"approved_end_time"`
	// The proposed spending limit.
	//
	// Types that are valid to be assigned to ProposedSpendingLimit:
	//	*AccountBudgetProposal_ProposedSpendingLimitMicros
	//	*AccountBudgetProposal_ProposedSpendingLimitType
	ProposedSpendingLimit isAccountBudgetProposal_ProposedSpendingLimit `protobuf_oneof:"proposed_spending_limit"`
	// The approved spending limit.
	//
	// Types that are valid to be assigned to ApprovedSpendingLimit:
	//	*AccountBudgetProposal_ApprovedSpendingLimitMicros
	//	*AccountBudgetProposal_ApprovedSpendingLimitType
	ApprovedSpendingLimit isAccountBudgetProposal_ApprovedSpendingLimit `protobuf_oneof:"approved_spending_limit"`
	XXX_NoUnkeyedLiteral  struct{}                                      `json:"-"`
	XXX_unrecognized      []byte                                        `json:"-"`
	XXX_sizecache         int32                                         `json:"-"`
}

func (m *AccountBudgetProposal) Reset()         { *m = AccountBudgetProposal{} }
func (m *AccountBudgetProposal) String() string { return proto.CompactTextString(m) }
func (*AccountBudgetProposal) ProtoMessage()    {}
func (*AccountBudgetProposal) Descriptor() ([]byte, []int) {
	return fileDescriptor_97474d5a9610a949, []int{0}
}

func (m *AccountBudgetProposal) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccountBudgetProposal.Unmarshal(m, b)
}
func (m *AccountBudgetProposal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccountBudgetProposal.Marshal(b, m, deterministic)
}
func (m *AccountBudgetProposal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountBudgetProposal.Merge(m, src)
}
func (m *AccountBudgetProposal) XXX_Size() int {
	return xxx_messageInfo_AccountBudgetProposal.Size(m)
}
func (m *AccountBudgetProposal) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountBudgetProposal.DiscardUnknown(m)
}

var xxx_messageInfo_AccountBudgetProposal proto.InternalMessageInfo

func (m *AccountBudgetProposal) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AccountBudgetProposal) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *AccountBudgetProposal) GetBillingSetup() *wrappers.StringValue {
	if m != nil {
		return m.BillingSetup
	}
	return nil
}

func (m *AccountBudgetProposal) GetAccountBudget() *wrappers.StringValue {
	if m != nil {
		return m.AccountBudget
	}
	return nil
}

func (m *AccountBudgetProposal) GetProposalType() enums.AccountBudgetProposalTypeEnum_AccountBudgetProposalType {
	if m != nil {
		return m.ProposalType
	}
	return enums.AccountBudgetProposalTypeEnum_UNSPECIFIED
}

func (m *AccountBudgetProposal) GetStatus() enums.AccountBudgetProposalStatusEnum_AccountBudgetProposalStatus {
	if m != nil {
		return m.Status
	}
	return enums.AccountBudgetProposalStatusEnum_UNSPECIFIED
}

func (m *AccountBudgetProposal) GetProposedName() *wrappers.StringValue {
	if m != nil {
		return m.ProposedName
	}
	return nil
}

func (m *AccountBudgetProposal) GetApprovedStartDateTime() *wrappers.StringValue {
	if m != nil {
		return m.ApprovedStartDateTime
	}
	return nil
}

func (m *AccountBudgetProposal) GetProposedPurchaseOrderNumber() *wrappers.StringValue {
	if m != nil {
		return m.ProposedPurchaseOrderNumber
	}
	return nil
}

func (m *AccountBudgetProposal) GetProposedNotes() *wrappers.StringValue {
	if m != nil {
		return m.ProposedNotes
	}
	return nil
}

func (m *AccountBudgetProposal) GetCreationDateTime() *wrappers.StringValue {
	if m != nil {
		return m.CreationDateTime
	}
	return nil
}

func (m *AccountBudgetProposal) GetApprovalDateTime() *wrappers.StringValue {
	if m != nil {
		return m.ApprovalDateTime
	}
	return nil
}

type isAccountBudgetProposal_ProposedStartTime interface {
	isAccountBudgetProposal_ProposedStartTime()
}

type AccountBudgetProposal_ProposedStartDateTime struct {
	ProposedStartDateTime *wrappers.StringValue `protobuf:"bytes,18,opt,name=proposed_start_date_time,json=proposedStartDateTime,proto3,oneof"`
}

type AccountBudgetProposal_ProposedStartTimeType struct {
	ProposedStartTimeType enums.TimeTypeEnum_TimeType `protobuf:"varint,7,opt,name=proposed_start_time_type,json=proposedStartTimeType,proto3,enum=google.ads.googleads.v3.enums.TimeTypeEnum_TimeType,oneof"`
}

func (*AccountBudgetProposal_ProposedStartDateTime) isAccountBudgetProposal_ProposedStartTime() {}

func (*AccountBudgetProposal_ProposedStartTimeType) isAccountBudgetProposal_ProposedStartTime() {}

func (m *AccountBudgetProposal) GetProposedStartTime() isAccountBudgetProposal_ProposedStartTime {
	if m != nil {
		return m.ProposedStartTime
	}
	return nil
}

func (m *AccountBudgetProposal) GetProposedStartDateTime() *wrappers.StringValue {
	if x, ok := m.GetProposedStartTime().(*AccountBudgetProposal_ProposedStartDateTime); ok {
		return x.ProposedStartDateTime
	}
	return nil
}

func (m *AccountBudgetProposal) GetProposedStartTimeType() enums.TimeTypeEnum_TimeType {
	if x, ok := m.GetProposedStartTime().(*AccountBudgetProposal_ProposedStartTimeType); ok {
		return x.ProposedStartTimeType
	}
	return enums.TimeTypeEnum_UNSPECIFIED
}

type isAccountBudgetProposal_ProposedEndTime interface {
	isAccountBudgetProposal_ProposedEndTime()
}

type AccountBudgetProposal_ProposedEndDateTime struct {
	ProposedEndDateTime *wrappers.StringValue `protobuf:"bytes,19,opt,name=proposed_end_date_time,json=proposedEndDateTime,proto3,oneof"`
}

type AccountBudgetProposal_ProposedEndTimeType struct {
	ProposedEndTimeType enums.TimeTypeEnum_TimeType `protobuf:"varint,9,opt,name=proposed_end_time_type,json=proposedEndTimeType,proto3,enum=google.ads.googleads.v3.enums.TimeTypeEnum_TimeType,oneof"`
}

func (*AccountBudgetProposal_ProposedEndDateTime) isAccountBudgetProposal_ProposedEndTime() {}

func (*AccountBudgetProposal_ProposedEndTimeType) isAccountBudgetProposal_ProposedEndTime() {}

func (m *AccountBudgetProposal) GetProposedEndTime() isAccountBudgetProposal_ProposedEndTime {
	if m != nil {
		return m.ProposedEndTime
	}
	return nil
}

func (m *AccountBudgetProposal) GetProposedEndDateTime() *wrappers.StringValue {
	if x, ok := m.GetProposedEndTime().(*AccountBudgetProposal_ProposedEndDateTime); ok {
		return x.ProposedEndDateTime
	}
	return nil
}

func (m *AccountBudgetProposal) GetProposedEndTimeType() enums.TimeTypeEnum_TimeType {
	if x, ok := m.GetProposedEndTime().(*AccountBudgetProposal_ProposedEndTimeType); ok {
		return x.ProposedEndTimeType
	}
	return enums.TimeTypeEnum_UNSPECIFIED
}

type isAccountBudgetProposal_ApprovedEndTime interface {
	isAccountBudgetProposal_ApprovedEndTime()
}

type AccountBudgetProposal_ApprovedEndDateTime struct {
	ApprovedEndDateTime *wrappers.StringValue `protobuf:"bytes,21,opt,name=approved_end_date_time,json=approvedEndDateTime,proto3,oneof"`
}

type AccountBudgetProposal_ApprovedEndTimeType struct {
	ApprovedEndTimeType enums.TimeTypeEnum_TimeType `protobuf:"varint,22,opt,name=approved_end_time_type,json=approvedEndTimeType,proto3,enum=google.ads.googleads.v3.enums.TimeTypeEnum_TimeType,oneof"`
}

func (*AccountBudgetProposal_ApprovedEndDateTime) isAccountBudgetProposal_ApprovedEndTime() {}

func (*AccountBudgetProposal_ApprovedEndTimeType) isAccountBudgetProposal_ApprovedEndTime() {}

func (m *AccountBudgetProposal) GetApprovedEndTime() isAccountBudgetProposal_ApprovedEndTime {
	if m != nil {
		return m.ApprovedEndTime
	}
	return nil
}

func (m *AccountBudgetProposal) GetApprovedEndDateTime() *wrappers.StringValue {
	if x, ok := m.GetApprovedEndTime().(*AccountBudgetProposal_ApprovedEndDateTime); ok {
		return x.ApprovedEndDateTime
	}
	return nil
}

func (m *AccountBudgetProposal) GetApprovedEndTimeType() enums.TimeTypeEnum_TimeType {
	if x, ok := m.GetApprovedEndTime().(*AccountBudgetProposal_ApprovedEndTimeType); ok {
		return x.ApprovedEndTimeType
	}
	return enums.TimeTypeEnum_UNSPECIFIED
}

type isAccountBudgetProposal_ProposedSpendingLimit interface {
	isAccountBudgetProposal_ProposedSpendingLimit()
}

type AccountBudgetProposal_ProposedSpendingLimitMicros struct {
	ProposedSpendingLimitMicros *wrappers.Int64Value `protobuf:"bytes,10,opt,name=proposed_spending_limit_micros,json=proposedSpendingLimitMicros,proto3,oneof"`
}

type AccountBudgetProposal_ProposedSpendingLimitType struct {
	ProposedSpendingLimitType enums.SpendingLimitTypeEnum_SpendingLimitType `protobuf:"varint,11,opt,name=proposed_spending_limit_type,json=proposedSpendingLimitType,proto3,enum=google.ads.googleads.v3.enums.SpendingLimitTypeEnum_SpendingLimitType,oneof"`
}

func (*AccountBudgetProposal_ProposedSpendingLimitMicros) isAccountBudgetProposal_ProposedSpendingLimit() {
}

func (*AccountBudgetProposal_ProposedSpendingLimitType) isAccountBudgetProposal_ProposedSpendingLimit() {
}

func (m *AccountBudgetProposal) GetProposedSpendingLimit() isAccountBudgetProposal_ProposedSpendingLimit {
	if m != nil {
		return m.ProposedSpendingLimit
	}
	return nil
}

func (m *AccountBudgetProposal) GetProposedSpendingLimitMicros() *wrappers.Int64Value {
	if x, ok := m.GetProposedSpendingLimit().(*AccountBudgetProposal_ProposedSpendingLimitMicros); ok {
		return x.ProposedSpendingLimitMicros
	}
	return nil
}

func (m *AccountBudgetProposal) GetProposedSpendingLimitType() enums.SpendingLimitTypeEnum_SpendingLimitType {
	if x, ok := m.GetProposedSpendingLimit().(*AccountBudgetProposal_ProposedSpendingLimitType); ok {
		return x.ProposedSpendingLimitType
	}
	return enums.SpendingLimitTypeEnum_UNSPECIFIED
}

type isAccountBudgetProposal_ApprovedSpendingLimit interface {
	isAccountBudgetProposal_ApprovedSpendingLimit()
}

type AccountBudgetProposal_ApprovedSpendingLimitMicros struct {
	ApprovedSpendingLimitMicros *wrappers.Int64Value `protobuf:"bytes,23,opt,name=approved_spending_limit_micros,json=approvedSpendingLimitMicros,proto3,oneof"`
}

type AccountBudgetProposal_ApprovedSpendingLimitType struct {
	ApprovedSpendingLimitType enums.SpendingLimitTypeEnum_SpendingLimitType `protobuf:"varint,24,opt,name=approved_spending_limit_type,json=approvedSpendingLimitType,proto3,enum=google.ads.googleads.v3.enums.SpendingLimitTypeEnum_SpendingLimitType,oneof"`
}

func (*AccountBudgetProposal_ApprovedSpendingLimitMicros) isAccountBudgetProposal_ApprovedSpendingLimit() {
}

func (*AccountBudgetProposal_ApprovedSpendingLimitType) isAccountBudgetProposal_ApprovedSpendingLimit() {
}

func (m *AccountBudgetProposal) GetApprovedSpendingLimit() isAccountBudgetProposal_ApprovedSpendingLimit {
	if m != nil {
		return m.ApprovedSpendingLimit
	}
	return nil
}

func (m *AccountBudgetProposal) GetApprovedSpendingLimitMicros() *wrappers.Int64Value {
	if x, ok := m.GetApprovedSpendingLimit().(*AccountBudgetProposal_ApprovedSpendingLimitMicros); ok {
		return x.ApprovedSpendingLimitMicros
	}
	return nil
}

func (m *AccountBudgetProposal) GetApprovedSpendingLimitType() enums.SpendingLimitTypeEnum_SpendingLimitType {
	if x, ok := m.GetApprovedSpendingLimit().(*AccountBudgetProposal_ApprovedSpendingLimitType); ok {
		return x.ApprovedSpendingLimitType
	}
	return enums.SpendingLimitTypeEnum_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AccountBudgetProposal) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AccountBudgetProposal_ProposedStartDateTime)(nil),
		(*AccountBudgetProposal_ProposedStartTimeType)(nil),
		(*AccountBudgetProposal_ProposedEndDateTime)(nil),
		(*AccountBudgetProposal_ProposedEndTimeType)(nil),
		(*AccountBudgetProposal_ApprovedEndDateTime)(nil),
		(*AccountBudgetProposal_ApprovedEndTimeType)(nil),
		(*AccountBudgetProposal_ProposedSpendingLimitMicros)(nil),
		(*AccountBudgetProposal_ProposedSpendingLimitType)(nil),
		(*AccountBudgetProposal_ApprovedSpendingLimitMicros)(nil),
		(*AccountBudgetProposal_ApprovedSpendingLimitType)(nil),
	}
}

func init() {
	proto.RegisterType((*AccountBudgetProposal)(nil), "google.ads.googleads.v3.resources.AccountBudgetProposal")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/account_budget_proposal.proto", fileDescriptor_97474d5a9610a949)
}

var fileDescriptor_97474d5a9610a949 = []byte{
	// 961 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x97, 0x4f, 0x6f, 0xdb, 0x36,
	0x18, 0xc6, 0x67, 0xbb, 0xe9, 0x50, 0x36, 0xc9, 0x5a, 0x79, 0x6e, 0x95, 0x3f, 0xe8, 0xd2, 0x01,
	0xd9, 0x72, 0xa9, 0x54, 0xd4, 0x45, 0x07, 0x68, 0x87, 0x4d, 0xc2, 0xd2, 0x7a, 0xc3, 0x96, 0x04,
	0x72, 0x61, 0x0c, 0x99, 0x01, 0x81, 0x96, 0x18, 0x55, 0x80, 0x24, 0x0a, 0x24, 0x95, 0xa0, 0x2b,
	0x0a, 0xec, 0xb6, 0xdb, 0x3e, 0xc4, 0x8e, 0xfb, 0x28, 0x3b, 0xef, 0x03, 0xf4, 0xdc, 0x8f, 0xb0,
	0xd3, 0x40, 0x4a, 0xa4, 0x65, 0x5b, 0x4a, 0xb4, 0xb6, 0x37, 0xca, 0x7c, 0xdf, 0xdf, 0xcb, 0xe7,
	0x21, 0x5f, 0x4a, 0x06, 0xdf, 0x84, 0x18, 0x87, 0x31, 0x32, 0x61, 0x40, 0xcd, 0x62, 0xc8, 0x47,
	0xe7, 0x43, 0x93, 0x20, 0x8a, 0x73, 0xe2, 0x23, 0x6a, 0x42, 0xdf, 0xc7, 0x79, 0xca, 0xbc, 0x59,
	0x1e, 0x84, 0x88, 0x79, 0x19, 0xc1, 0x19, 0xa6, 0x30, 0x36, 0x32, 0x82, 0x19, 0xd6, 0xee, 0x17,
	0x59, 0x06, 0x0c, 0xa8, 0xa1, 0x00, 0xc6, 0xf9, 0xd0, 0x50, 0x80, 0x6d, 0xa7, 0xa9, 0x06, 0x4a,
	0xf3, 0xa4, 0x91, 0xef, 0x51, 0x06, 0x59, 0x4e, 0x8b, 0x32, 0xdb, 0xdf, 0xbe, 0x1b, 0x83, 0xbd,
	0xcc, 0x50, 0x49, 0xf8, 0xea, 0x72, 0x02, 0xcd, 0x50, 0x1a, 0x44, 0x69, 0xe8, 0xc5, 0x51, 0x12,
	0xb1, 0x6a, 0xe2, 0x83, 0xcb, 0x13, 0x59, 0x94, 0xa0, 0x6a, 0xf8, 0x67, 0x32, 0x3c, 0x8b, 0xcc,
	0xb3, 0x08, 0xc5, 0x81, 0x37, 0x43, 0x2f, 0xe0, 0x79, 0x84, 0x49, 0x19, 0xb0, 0x55, 0x09, 0x90,
	0x26, 0x95, 0x53, 0xf7, 0xca, 0x29, 0xf1, 0x34, 0xcb, 0xcf, 0xcc, 0x0b, 0x02, 0xb3, 0x0c, 0x11,
	0xe9, 0xc2, 0x6e, 0x25, 0x15, 0xa6, 0x29, 0x66, 0x90, 0x45, 0x38, 0x2d, 0x67, 0x3f, 0xff, 0xa7,
	0x0f, 0x06, 0x76, 0x61, 0x84, 0x23, 0x7c, 0x38, 0x29, 0x6d, 0xd0, 0x7e, 0x01, 0x1b, 0xb2, 0x92,
	0x97, 0xc2, 0x04, 0xe9, 0x9d, 0xbd, 0xce, 0xc1, 0x0d, 0xe7, 0xc9, 0x1b, 0x7b, 0xed, 0x5f, 0xfb,
	0x21, 0xa8, 0x6c, 0x5c, 0x39, 0xca, 0x22, 0x6a, 0xf8, 0x38, 0x31, 0x6b, 0x71, 0xee, 0xba, 0x84,
	0x1d, 0xc1, 0x04, 0x69, 0x0f, 0x41, 0x37, 0x0a, 0xf4, 0xcd, 0xbd, 0xce, 0xc1, 0xcd, 0x47, 0x3b,
	0x25, 0xc0, 0x90, 0x0a, 0x8c, 0xef, 0x53, 0xf6, 0xe4, 0xf1, 0x04, 0xc6, 0x39, 0x72, 0x7a, 0x6f,
	0xec, 0x9e, 0xdb, 0x8d, 0x02, 0x2d, 0x03, 0x1b, 0xb3, 0x28, 0x8e, 0xb9, 0xdb, 0x14, 0xb1, 0x3c,
	0xd3, 0xbb, 0x22, 0x79, 0x77, 0x25, 0x79, 0xcc, 0x48, 0x94, 0x86, 0x45, 0xf6, 0x03, 0xb1, 0xd8,
	0x2f, 0xc1, 0x7e, 0xe3, 0x62, 0x9d, 0x82, 0x39, 0xe6, 0x48, 0x77, 0x7d, 0x56, 0x79, 0xd2, 0x28,
	0xd8, 0x5c, 0x3c, 0x22, 0x7a, 0xaf, 0x45, 0x49, 0x43, 0x94, 0x3c, 0x00, 0x5f, 0xb4, 0xf3, 0xc7,
	0xdd, 0x80, 0xd5, 0x47, 0xed, 0xb7, 0x0e, 0xd8, 0x58, 0x38, 0x89, 0xfa, 0xb5, 0xbd, 0xce, 0xc1,
	0xe6, 0xa3, 0x89, 0xd1, 0xd4, 0x33, 0xe2, 0x44, 0x19, 0xb5, 0xa6, 0x3f, 0x7f, 0x99, 0xa1, 0xc3,
	0x34, 0x4f, 0x9a, 0x67, 0xb9, 0xbf, 0x6b, 0xee, 0x7a, 0x56, 0xf9, 0x49, 0xbb, 0x00, 0xd7, 0x8b,
	0x36, 0xd2, 0x3f, 0x11, 0xa5, 0x4f, 0xdf, 0xa5, 0xf4, 0x58, 0x10, 0x9a, 0x8b, 0x17, 0xf3, 0xc5,
	0xf6, 0x96, 0xe5, 0xb4, 0xa7, 0x52, 0x3a, 0x0a, 0x8a, 0x13, 0xb7, 0xd6, 0xc2, 0xef, 0xaa, 0x00,
	0x14, 0x88, 0xc3, 0x75, 0x0a, 0x74, 0x98, 0x65, 0x04, 0x9f, 0xa3, 0x80, 0x5f, 0x08, 0x84, 0x79,
	0x01, 0x64, 0xc8, 0xe3, 0x4d, 0xa7, 0x7f, 0xda, 0x0e, 0xd9, 0x73, 0x07, 0x12, 0x31, 0xe6, 0x84,
	0xef, 0x20, 0x43, 0xcf, 0xa3, 0x04, 0x69, 0x67, 0xe0, 0x9e, 0x5a, 0x63, 0x96, 0x13, 0xff, 0x05,
	0xa4, 0xc8, 0xc3, 0x24, 0x40, 0xc4, 0x4b, 0xf3, 0x64, 0x86, 0x88, 0xbe, 0xde, 0x76, 0xd1, 0x3b,
	0x12, 0x74, 0x52, 0x72, 0x8e, 0x39, 0xe6, 0x48, 0x50, 0xb4, 0x11, 0xd8, 0x9c, 0x7b, 0x81, 0x19,
	0xa2, 0xfa, 0x46, 0x5b, 0xae, 0x32, 0xf1, 0x88, 0xe7, 0x69, 0xc7, 0x40, 0xf3, 0x09, 0x12, 0x4d,
	0x5f, 0xf1, 0xe1, 0x56, 0x5b, 0x1f, 0x6e, 0xc9, 0x64, 0x65, 0xc1, 0x31, 0xd0, 0x0a, 0x6f, 0x60,
	0x5c, 0x01, 0xde, 0x6e, 0x0d, 0x94, 0xc9, 0x0a, 0x38, 0x05, 0xba, 0xd2, 0xba, 0xbc, 0x5f, 0x5a,
	0x4b, 0xd5, 0xa3, 0x8f, 0xdc, 0x81, 0x84, 0x2c, 0xee, 0x18, 0x5b, 0xa1, 0xab, 0xdb, 0x57, 0xff,
	0x58, 0x1c, 0xf0, 0xc7, 0x57, 0x1c, 0x70, 0x8e, 0x51, 0xad, 0x24, 0x1f, 0xea, 0xab, 0xca, 0x59,
	0xed, 0x67, 0x70, 0x47, 0x55, 0x45, 0x69, 0x50, 0x51, 0xd4, 0x6f, 0xab, 0xa8, 0xe3, 0xf6, 0x25,
	0xe2, 0x30, 0x0d, 0x94, 0x9e, 0x6c, 0x89, 0x3c, 0x57, 0x73, 0xe3, 0x7d, 0xd5, 0x2c, 0x56, 0xac,
	0x6a, 0x51, 0xfd, 0xb4, 0xa8, 0x65, 0xd0, 0x72, 0xd3, 0x47, 0x5d, 0xb7, 0x2f, 0x11, 0x4b, 0x5a,
	0x16, 0xc8, 0x73, 0x2d, 0x77, 0xde, 0x4f, 0xcb, 0x72, 0x45, 0xa5, 0x25, 0xac, 0xf4, 0xef, 0xd2,
	0xeb, 0x3b, 0x89, 0x7c, 0x82, 0xa9, 0x0e, 0x5a, 0xbd, 0x94, 0xd6, 0x46, 0xbd, 0x79, 0x03, 0x8f,
	0x4b, 0xd0, 0x8f, 0x9c, 0xf3, 0x93, 0xc0, 0x68, 0x7f, 0x74, 0xc0, 0x6e, 0x53, 0x25, 0xa1, 0xf0,
	0xa6, 0x50, 0xf8, 0xf4, 0x0a, 0x85, 0x0b, 0x68, 0x25, 0x75, 0xe5, 0x57, 0xb9, 0xa4, 0xad, 0xda,
	0x25, 0x49, 0xe5, 0xf3, 0x5b, 0xb1, 0x56, 0xf9, 0xdd, 0x76, 0xaf, 0xe3, 0xd1, 0x35, 0x77, 0x47,
	0x5d, 0x8e, 0x0d, 0xca, 0x9b, 0x2a, 0x09, 0xe5, 0xfa, 0x87, 0x56, 0xce, 0x97, 0xb4, 0x55, 0xbb,
	0x24, 0x1e, 0x61, 0xfd, 0xfa, 0xd6, 0xbe, 0xf8, 0xbf, 0xdf, 0x2b, 0xda, 0xa1, 0x9f, 0x53, 0x86,
	0x13, 0x44, 0xa8, 0xf9, 0x4a, 0x0e, 0x5f, 0x9b, 0xb0, 0x2e, 0x96, 0x9a, 0xaf, 0x1a, 0xbe, 0x25,
	0x5f, 0x3b, 0x03, 0xd0, 0xaf, 0xb9, 0x7d, 0x9c, 0x3e, 0xb8, 0xbd, 0xd2, 0xc4, 0xfc, 0xc7, 0x95,
	0x6e, 0x70, 0xb6, 0xc0, 0xdd, 0x86, 0x63, 0xc4, 0xa7, 0x1a, 0x7c, 0x76, 0x7e, 0xef, 0x82, 0x7d,
	0x1f, 0x27, 0xc6, 0x95, 0x1f, 0xda, 0xce, 0x76, 0xad, 0xfc, 0x13, 0xbe, 0xf7, 0x27, 0x9d, 0xd3,
	0x1f, 0x4a, 0x40, 0x88, 0x63, 0x98, 0x86, 0x06, 0x26, 0xa1, 0x19, 0xa2, 0x54, 0x9c, 0x0c, 0x73,
	0x6e, 0xe3, 0x25, 0xff, 0x04, 0xbe, 0x56, 0xa3, 0x3f, 0xbb, 0xbd, 0x67, 0xb6, 0xfd, 0x57, 0xf7,
	0xfe, 0xb3, 0x02, 0x69, 0x07, 0xd4, 0x28, 0x86, 0x7c, 0x34, 0x19, 0x1a, 0xae, 0x8c, 0xfc, 0x5b,
	0xc6, 0x4c, 0xed, 0x80, 0x4e, 0x55, 0xcc, 0x74, 0x32, 0x9c, 0xaa, 0x98, 0xb7, 0xdd, 0xfd, 0x62,
	0xc2, 0xb2, 0xec, 0x80, 0x5a, 0x96, 0x8a, 0xb2, 0xac, 0xc9, 0xd0, 0xb2, 0x54, 0xdc, 0xec, 0xba,
	0x58, 0xec, 0xf0, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x21, 0x7a, 0xc4, 0x46, 0xb5, 0x0c, 0x00,
	0x00,
}
