// Copyright 2013 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package kcp

import (
	"bytes"
	"testing"
)

func TestXORBytes(t *testing.T) {
	for alignP := 0; alignP < 2; alignP++ {
		for alignQ := 0; alignQ < 2; alignQ++ {
			for alignD := 0; alignD < 2; alignD++ {
				p := make([]byte, 1024)[alignP:]
				q := make([]byte, 1024)[alignQ:]
				d1 := make([]byte, 1024+alignD)[alignD:]
				d2 := make([]byte, 1024+alignD)[alignD:]
				xorBytes(d1, p, q)
				safeXORBytes(d2, p, q)
				if !bytes.Equal(d1, d2) {
					t.Error("not equal")
				}
			}
		}
	}
}

func BenchmarkZeroByXOR(b *testing.B) {
	d := make([]byte, 1024)
	b.ResetTimer()
	b.SetBytes(1024)
	for i := 0; i < b.N; i++ {
		xorBytes(d, d, d)
	}
}

func BenchmarkZeroByCopy(b *testing.B) {
	d := make([]byte, 1024)
	zero := make([]byte, 1024)
	b.ResetTimer()
	b.SetBytes(1024)
	for i := 0; i < b.N; i++ {
		copy(d, zero)
	}
}
