// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package cloudformation

import (
	"github.com/aws/aws-sdk-go/private/waiter"
)

// WaitUntilStackCreateComplete uses the AWS CloudFormation API operation
// DescribeStacks to wait for a condition to be met before returning.
// If the condition is not meet within the max attempt window an error will
// be returned.
func (c *CloudFormation) WaitUntilStackCreateComplete(input *DescribeStacksInput) error {
	waiterCfg := waiter.Config{
		Operation:   "DescribeStacks",
		Delay:       30,
		MaxAttempts: 120,
		Acceptors: []waiter.WaitAcceptor{
			{
				State:    "success",
				Matcher:  "pathAll",
				Argument: "Stacks[].StackStatus",
				Expected: "CREATE_COMPLETE",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "CREATE_FAILED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "DELETE_COMPLETE",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "DELETE_IN_PROGRESS",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "DELETE_FAILED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "ROLLBACK_COMPLETE",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "ROLLBACK_FAILED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "ROLLBACK_IN_PROGRESS",
			},
			{
				State:    "failure",
				Matcher:  "error",
				Argument: "",
				Expected: "ValidationError",
			},
		},
	}

	w := waiter.Waiter{
		Client: c,
		Input:  input,
		Config: waiterCfg,
	}
	return w.Wait()
}

// WaitUntilStackDeleteComplete uses the AWS CloudFormation API operation
// DescribeStacks to wait for a condition to be met before returning.
// If the condition is not meet within the max attempt window an error will
// be returned.
func (c *CloudFormation) WaitUntilStackDeleteComplete(input *DescribeStacksInput) error {
	waiterCfg := waiter.Config{
		Operation:   "DescribeStacks",
		Delay:       30,
		MaxAttempts: 120,
		Acceptors: []waiter.WaitAcceptor{
			{
				State:    "success",
				Matcher:  "pathAll",
				Argument: "Stacks[].StackStatus",
				Expected: "DELETE_COMPLETE",
			},
			{
				State:    "success",
				Matcher:  "error",
				Argument: "",
				Expected: "ValidationError",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "DELETE_FAILED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "CREATE_COMPLETE",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "CREATE_FAILED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "CREATE_IN_PROGRESS",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "ROLLBACK_COMPLETE",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "ROLLBACK_FAILED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "ROLLBACK_IN_PROGRESS",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_COMPLETE",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_IN_PROGRESS",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_ROLLBACK_COMPLETE",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_ROLLBACK_FAILED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_ROLLBACK_IN_PROGRESS",
			},
		},
	}

	w := waiter.Waiter{
		Client: c,
		Input:  input,
		Config: waiterCfg,
	}
	return w.Wait()
}

// WaitUntilStackExists uses the AWS CloudFormation API operation
// DescribeStacks to wait for a condition to be met before returning.
// If the condition is not meet within the max attempt window an error will
// be returned.
func (c *CloudFormation) WaitUntilStackExists(input *DescribeStacksInput) error {
	waiterCfg := waiter.Config{
		Operation:   "DescribeStacks",
		Delay:       5,
		MaxAttempts: 20,
		Acceptors: []waiter.WaitAcceptor{
			{
				State:    "success",
				Matcher:  "status",
				Argument: "",
				Expected: 200,
			},
			{
				State:    "retry",
				Matcher:  "error",
				Argument: "",
				Expected: "ValidationError",
			},
		},
	}

	w := waiter.Waiter{
		Client: c,
		Input:  input,
		Config: waiterCfg,
	}
	return w.Wait()
}

// WaitUntilStackUpdateComplete uses the AWS CloudFormation API operation
// DescribeStacks to wait for a condition to be met before returning.
// If the condition is not meet within the max attempt window an error will
// be returned.
func (c *CloudFormation) WaitUntilStackUpdateComplete(input *DescribeStacksInput) error {
	waiterCfg := waiter.Config{
		Operation:   "DescribeStacks",
		Delay:       30,
		MaxAttempts: 120,
		Acceptors: []waiter.WaitAcceptor{
			{
				State:    "success",
				Matcher:  "pathAll",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_COMPLETE",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_FAILED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_ROLLBACK_COMPLETE",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_ROLLBACK_FAILED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Stacks[].StackStatus",
				Expected: "UPDATE_ROLLBACK_IN_PROGRESS",
			},
			{
				State:    "failure",
				Matcher:  "error",
				Argument: "",
				Expected: "ValidationError",
			},
		},
	}

	w := waiter.Waiter{
		Client: c,
		Input:  input,
		Config: waiterCfg,
	}
	return w.Wait()
}
