// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package serverlessapplicationrepository

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplication
func (c *ServerlessApplicationRepository) CreateApplicationRequest(input *CreateApplicationRequest) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications",
	}

	if input == nil {
		input = &CreateApplicationRequest{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWSServerlessApplicationRepository.
//
// Creates an application, optionally including an AWS SAM file to create the
// first application version in the same call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation CreateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeConflictException "ConflictException"
//   The resource already exists.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplication
func (c *ServerlessApplicationRepository) CreateApplication(input *CreateApplicationRequest) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationRequest, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplicationVersion = "CreateApplicationVersion"

// CreateApplicationVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplicationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplicationVersion for more information on using the CreateApplicationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationVersionRequest method.
//    req, resp := client.CreateApplicationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplicationVersion
func (c *ServerlessApplicationRepository) CreateApplicationVersionRequest(input *CreateApplicationVersionRequest) (req *request.Request, output *CreateApplicationVersionOutput) {
	op := &request.Operation{
		Name:       opCreateApplicationVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/versions/{semanticVersion}",
	}

	if input == nil {
		input = &CreateApplicationVersionRequest{}
	}

	output = &CreateApplicationVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplicationVersion API operation for AWSServerlessApplicationRepository.
//
// Creates an application version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation CreateApplicationVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeConflictException "ConflictException"
//   The resource already exists.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplicationVersion
func (c *ServerlessApplicationRepository) CreateApplicationVersion(input *CreateApplicationVersionRequest) (*CreateApplicationVersionOutput, error) {
	req, out := c.CreateApplicationVersionRequest(input)
	return out, req.Send()
}

// CreateApplicationVersionWithContext is the same as CreateApplicationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplicationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) CreateApplicationVersionWithContext(ctx aws.Context, input *CreateApplicationVersionRequest, opts ...request.Option) (*CreateApplicationVersionOutput, error) {
	req, out := c.CreateApplicationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCloudFormationChangeSet = "CreateCloudFormationChangeSet"

// CreateCloudFormationChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateCloudFormationChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCloudFormationChangeSet for more information on using the CreateCloudFormationChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCloudFormationChangeSetRequest method.
//    req, resp := client.CreateCloudFormationChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationChangeSet
func (c *ServerlessApplicationRepository) CreateCloudFormationChangeSetRequest(input *CreateCloudFormationChangeSetRequest) (req *request.Request, output *CreateCloudFormationChangeSetOutput) {
	op := &request.Operation{
		Name:       opCreateCloudFormationChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/changesets",
	}

	if input == nil {
		input = &CreateCloudFormationChangeSetRequest{}
	}

	output = &CreateCloudFormationChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCloudFormationChangeSet API operation for AWSServerlessApplicationRepository.
//
// Creates an AWS CloudFormation change set for the given application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation CreateCloudFormationChangeSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationChangeSet
func (c *ServerlessApplicationRepository) CreateCloudFormationChangeSet(input *CreateCloudFormationChangeSetRequest) (*CreateCloudFormationChangeSetOutput, error) {
	req, out := c.CreateCloudFormationChangeSetRequest(input)
	return out, req.Send()
}

// CreateCloudFormationChangeSetWithContext is the same as CreateCloudFormationChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCloudFormationChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) CreateCloudFormationChangeSetWithContext(ctx aws.Context, input *CreateCloudFormationChangeSetRequest, opts ...request.Option) (*CreateCloudFormationChangeSetOutput, error) {
	req, out := c.CreateCloudFormationChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCloudFormationTemplate = "CreateCloudFormationTemplate"

// CreateCloudFormationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateCloudFormationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCloudFormationTemplate for more information on using the CreateCloudFormationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCloudFormationTemplateRequest method.
//    req, resp := client.CreateCloudFormationTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationTemplate
func (c *ServerlessApplicationRepository) CreateCloudFormationTemplateRequest(input *CreateCloudFormationTemplateInput) (req *request.Request, output *CreateCloudFormationTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateCloudFormationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/templates",
	}

	if input == nil {
		input = &CreateCloudFormationTemplateInput{}
	}

	output = &CreateCloudFormationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCloudFormationTemplate API operation for AWSServerlessApplicationRepository.
//
// Creates an AWS CloudFormation template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation CreateCloudFormationTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationTemplate
func (c *ServerlessApplicationRepository) CreateCloudFormationTemplate(input *CreateCloudFormationTemplateInput) (*CreateCloudFormationTemplateOutput, error) {
	req, out := c.CreateCloudFormationTemplateRequest(input)
	return out, req.Send()
}

// CreateCloudFormationTemplateWithContext is the same as CreateCloudFormationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCloudFormationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) CreateCloudFormationTemplateWithContext(ctx aws.Context, input *CreateCloudFormationTemplateInput, opts ...request.Option) (*CreateCloudFormationTemplateOutput, error) {
	req, out := c.CreateCloudFormationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/DeleteApplication
func (c *ServerlessApplicationRepository) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for AWSServerlessApplicationRepository.
//
// Deletes the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeConflictException "ConflictException"
//   The resource already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/DeleteApplication
func (c *ServerlessApplicationRepository) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationRequest method.
//    req, resp := client.GetApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplication
func (c *ServerlessApplicationRepository) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for AWSServerlessApplicationRepository.
//
// Gets the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation GetApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplication
func (c *ServerlessApplicationRepository) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationPolicy = "GetApplicationPolicy"

// GetApplicationPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationPolicy for more information on using the GetApplicationPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationPolicyRequest method.
//    req, resp := client.GetApplicationPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplicationPolicy
func (c *ServerlessApplicationRepository) GetApplicationPolicyRequest(input *GetApplicationPolicyInput) (req *request.Request, output *GetApplicationPolicyOutput) {
	op := &request.Operation{
		Name:       opGetApplicationPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/policy",
	}

	if input == nil {
		input = &GetApplicationPolicyInput{}
	}

	output = &GetApplicationPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationPolicy API operation for AWSServerlessApplicationRepository.
//
// Retrieves the policy for the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation GetApplicationPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplicationPolicy
func (c *ServerlessApplicationRepository) GetApplicationPolicy(input *GetApplicationPolicyInput) (*GetApplicationPolicyOutput, error) {
	req, out := c.GetApplicationPolicyRequest(input)
	return out, req.Send()
}

// GetApplicationPolicyWithContext is the same as GetApplicationPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) GetApplicationPolicyWithContext(ctx aws.Context, input *GetApplicationPolicyInput, opts ...request.Option) (*GetApplicationPolicyOutput, error) {
	req, out := c.GetApplicationPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCloudFormationTemplate = "GetCloudFormationTemplate"

// GetCloudFormationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetCloudFormationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCloudFormationTemplate for more information on using the GetCloudFormationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCloudFormationTemplateRequest method.
//    req, resp := client.GetCloudFormationTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetCloudFormationTemplate
func (c *ServerlessApplicationRepository) GetCloudFormationTemplateRequest(input *GetCloudFormationTemplateInput) (req *request.Request, output *GetCloudFormationTemplateOutput) {
	op := &request.Operation{
		Name:       opGetCloudFormationTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/templates/{templateId}",
	}

	if input == nil {
		input = &GetCloudFormationTemplateInput{}
	}

	output = &GetCloudFormationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCloudFormationTemplate API operation for AWSServerlessApplicationRepository.
//
// Gets the specified AWS CloudFormation template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation GetCloudFormationTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetCloudFormationTemplate
func (c *ServerlessApplicationRepository) GetCloudFormationTemplate(input *GetCloudFormationTemplateInput) (*GetCloudFormationTemplateOutput, error) {
	req, out := c.GetCloudFormationTemplateRequest(input)
	return out, req.Send()
}

// GetCloudFormationTemplateWithContext is the same as GetCloudFormationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCloudFormationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) GetCloudFormationTemplateWithContext(ctx aws.Context, input *GetCloudFormationTemplateInput, opts ...request.Option) (*GetCloudFormationTemplateOutput, error) {
	req, out := c.GetCloudFormationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplicationDependencies = "ListApplicationDependencies"

// ListApplicationDependenciesRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationDependencies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationDependencies for more information on using the ListApplicationDependencies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationDependenciesRequest method.
//    req, resp := client.ListApplicationDependenciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies
func (c *ServerlessApplicationRepository) ListApplicationDependenciesRequest(input *ListApplicationDependenciesInput) (req *request.Request, output *ListApplicationDependenciesOutput) {
	op := &request.Operation{
		Name:       opListApplicationDependencies,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/dependencies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationDependenciesInput{}
	}

	output = &ListApplicationDependenciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationDependencies API operation for AWSServerlessApplicationRepository.
//
// Retrieves the list of applications nested in the containing application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation ListApplicationDependencies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies
func (c *ServerlessApplicationRepository) ListApplicationDependencies(input *ListApplicationDependenciesInput) (*ListApplicationDependenciesOutput, error) {
	req, out := c.ListApplicationDependenciesRequest(input)
	return out, req.Send()
}

// ListApplicationDependenciesWithContext is the same as ListApplicationDependencies with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationDependencies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) ListApplicationDependenciesWithContext(ctx aws.Context, input *ListApplicationDependenciesInput, opts ...request.Option) (*ListApplicationDependenciesOutput, error) {
	req, out := c.ListApplicationDependenciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationDependenciesPages iterates over the pages of a ListApplicationDependencies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationDependencies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplicationDependencies operation.
//    pageNum := 0
//    err := client.ListApplicationDependenciesPages(params,
//        func(page *serverlessapplicationrepository.ListApplicationDependenciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServerlessApplicationRepository) ListApplicationDependenciesPages(input *ListApplicationDependenciesInput, fn func(*ListApplicationDependenciesOutput, bool) bool) error {
	return c.ListApplicationDependenciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationDependenciesPagesWithContext same as ListApplicationDependenciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) ListApplicationDependenciesPagesWithContext(ctx aws.Context, input *ListApplicationDependenciesInput, fn func(*ListApplicationDependenciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationDependenciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationDependenciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationDependenciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplicationVersions = "ListApplicationVersions"

// ListApplicationVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationVersions for more information on using the ListApplicationVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationVersionsRequest method.
//    req, resp := client.ListApplicationVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions
func (c *ServerlessApplicationRepository) ListApplicationVersionsRequest(input *ListApplicationVersionsInput) (req *request.Request, output *ListApplicationVersionsOutput) {
	op := &request.Operation{
		Name:       opListApplicationVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationVersionsInput{}
	}

	output = &ListApplicationVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationVersions API operation for AWSServerlessApplicationRepository.
//
// Lists versions for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation ListApplicationVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions
func (c *ServerlessApplicationRepository) ListApplicationVersions(input *ListApplicationVersionsInput) (*ListApplicationVersionsOutput, error) {
	req, out := c.ListApplicationVersionsRequest(input)
	return out, req.Send()
}

// ListApplicationVersionsWithContext is the same as ListApplicationVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) ListApplicationVersionsWithContext(ctx aws.Context, input *ListApplicationVersionsInput, opts ...request.Option) (*ListApplicationVersionsOutput, error) {
	req, out := c.ListApplicationVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationVersionsPages iterates over the pages of a ListApplicationVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplicationVersions operation.
//    pageNum := 0
//    err := client.ListApplicationVersionsPages(params,
//        func(page *serverlessapplicationrepository.ListApplicationVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServerlessApplicationRepository) ListApplicationVersionsPages(input *ListApplicationVersionsInput, fn func(*ListApplicationVersionsOutput, bool) bool) error {
	return c.ListApplicationVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationVersionsPagesWithContext same as ListApplicationVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) ListApplicationVersionsPagesWithContext(ctx aws.Context, input *ListApplicationVersionsInput, fn func(*ListApplicationVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications
func (c *ServerlessApplicationRepository) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for AWSServerlessApplicationRepository.
//
// Lists applications owned by the requester.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation ListApplications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications
func (c *ServerlessApplicationRepository) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplications operation.
//    pageNum := 0
//    err := client.ListApplicationsPages(params,
//        func(page *serverlessapplicationrepository.ListApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServerlessApplicationRepository) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutApplicationPolicy = "PutApplicationPolicy"

// PutApplicationPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutApplicationPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutApplicationPolicy for more information on using the PutApplicationPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutApplicationPolicyRequest method.
//    req, resp := client.PutApplicationPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicy
func (c *ServerlessApplicationRepository) PutApplicationPolicyRequest(input *PutApplicationPolicyInput) (req *request.Request, output *PutApplicationPolicyOutput) {
	op := &request.Operation{
		Name:       opPutApplicationPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/policy",
	}

	if input == nil {
		input = &PutApplicationPolicyInput{}
	}

	output = &PutApplicationPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutApplicationPolicy API operation for AWSServerlessApplicationRepository.
//
// Sets the permission policy for an application. For the list of actions supported
// for this operation, see Application Permissions (https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions) .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation PutApplicationPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicy
func (c *ServerlessApplicationRepository) PutApplicationPolicy(input *PutApplicationPolicyInput) (*PutApplicationPolicyOutput, error) {
	req, out := c.PutApplicationPolicyRequest(input)
	return out, req.Send()
}

// PutApplicationPolicyWithContext is the same as PutApplicationPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutApplicationPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) PutApplicationPolicyWithContext(ctx aws.Context, input *PutApplicationPolicyInput, opts ...request.Option) (*PutApplicationPolicyOutput, error) {
	req, out := c.PutApplicationPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UpdateApplication
func (c *ServerlessApplicationRepository) UpdateApplicationRequest(input *UpdateApplicationRequest) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &UpdateApplicationRequest{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplication API operation for AWSServerlessApplicationRepository.
//
// Updates the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSServerlessApplicationRepository's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   One of the parameters in the request is invalid.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The AWS Serverless Application Repository service encountered an internal
//   error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is not authenticated.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource (for example, an access policy statement) specified in the request
//   doesn't exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The client is sending more than the allowed number of requests per unit of
//   time.
//
//   * ErrCodeConflictException "ConflictException"
//   The resource already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UpdateApplication
func (c *ServerlessApplicationRepository) UpdateApplication(input *UpdateApplicationRequest) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServerlessApplicationRepository) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationRequest, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A nested application summary.
type ApplicationDependencySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the nested application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The semantic version of the nested application.
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`
}

// String returns the string representation
func (s ApplicationDependencySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationDependencySummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationDependencySummary) SetApplicationId(v string) *ApplicationDependencySummary {
	s.ApplicationId = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *ApplicationDependencySummary) SetSemanticVersion(v string) *ApplicationDependencySummary {
	s.SemanticVersion = &v
	return s
}

// Policy statement applied to the application.
type ApplicationPolicyStatement struct {
	_ struct{} `type:"structure"`

	// For the list of actions supported for this operation, see Application Permissions
	// (https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions).
	//
	// Actions is a required field
	Actions []*string `locationName:"actions" type:"list" required:"true"`

	// An array of AWS account IDs, or * to make the application public.
	//
	// Principals is a required field
	Principals []*string `locationName:"principals" type:"list" required:"true"`

	// A unique ID for the statement.
	StatementId *string `locationName:"statementId" type:"string"`
}

// String returns the string representation
func (s ApplicationPolicyStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationPolicyStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationPolicyStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationPolicyStatement"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Principals == nil {
		invalidParams.Add(request.NewErrParamRequired("Principals"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *ApplicationPolicyStatement) SetActions(v []*string) *ApplicationPolicyStatement {
	s.Actions = v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ApplicationPolicyStatement) SetPrincipals(v []*string) *ApplicationPolicyStatement {
	s.Principals = v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *ApplicationPolicyStatement) SetStatementId(v string) *ApplicationPolicyStatement {
	s.StatementId = &v
	return s
}

// Summary of details about the application.
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The name of the author publishing the app.
	//
	// Minimum length=1. Maximum length=127.
	//
	// Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
	//
	// Author is a required field
	Author *string `locationName:"author" type:"string" required:"true"`

	// The date and time this resource was created.
	CreationTime *string `locationName:"creationTime" type:"string"`

	// The description of the application.
	//
	// Minimum length=1. Maximum length=256
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// A URL with more information about the application, for example the location
	// of your GitHub repository for the application.
	HomePageUrl *string `locationName:"homePageUrl" type:"string"`

	// Labels to improve discovery of apps in search results.
	//
	// Minimum length=1. Maximum length=127. Maximum number of labels: 10
	//
	// Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
	Labels []*string `locationName:"labels" type:"list"`

	// The name of the application.
	//
	// Minimum length=1. Maximum length=140
	//
	// Pattern: "[a-zA-Z0-9\\-]+";
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A valid identifier from https://spdx.org/licenses/ (https://spdx.org/licenses/).
	SpdxLicenseId *string `locationName:"spdxLicenseId" type:"string"`
}

// String returns the string representation
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationSummary) SetApplicationId(v string) *ApplicationSummary {
	s.ApplicationId = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *ApplicationSummary) SetAuthor(v string) *ApplicationSummary {
	s.Author = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ApplicationSummary) SetCreationTime(v string) *ApplicationSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ApplicationSummary) SetDescription(v string) *ApplicationSummary {
	s.Description = &v
	return s
}

// SetHomePageUrl sets the HomePageUrl field's value.
func (s *ApplicationSummary) SetHomePageUrl(v string) *ApplicationSummary {
	s.HomePageUrl = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *ApplicationSummary) SetLabels(v []*string) *ApplicationSummary {
	s.Labels = v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationSummary) SetName(v string) *ApplicationSummary {
	s.Name = &v
	return s
}

// SetSpdxLicenseId sets the SpdxLicenseId field's value.
func (s *ApplicationSummary) SetSpdxLicenseId(v string) *ApplicationSummary {
	s.SpdxLicenseId = &v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `locationName:"applicationId" type:"string"`

	Author *string `locationName:"author" type:"string"`

	CreationTime *string `locationName:"creationTime" type:"string"`

	Description *string `locationName:"description" type:"string"`

	HomePageUrl *string `locationName:"homePageUrl" type:"string"`

	IsVerifiedAuthor *bool `locationName:"isVerifiedAuthor" type:"boolean"`

	Labels []*string `locationName:"labels" type:"list"`

	LicenseUrl *string `locationName:"licenseUrl" type:"string"`

	Name *string `locationName:"name" type:"string"`

	ReadmeUrl *string `locationName:"readmeUrl" type:"string"`

	SpdxLicenseId *string `locationName:"spdxLicenseId" type:"string"`

	VerifiedAuthorUrl *string `locationName:"verifiedAuthorUrl" type:"string"`

	// Application version details.
	Version *Version `locationName:"version" type:"structure"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateApplicationOutput) SetApplicationId(v string) *CreateApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *CreateApplicationOutput) SetAuthor(v string) *CreateApplicationOutput {
	s.Author = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateApplicationOutput) SetCreationTime(v string) *CreateApplicationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationOutput) SetDescription(v string) *CreateApplicationOutput {
	s.Description = &v
	return s
}

// SetHomePageUrl sets the HomePageUrl field's value.
func (s *CreateApplicationOutput) SetHomePageUrl(v string) *CreateApplicationOutput {
	s.HomePageUrl = &v
	return s
}

// SetIsVerifiedAuthor sets the IsVerifiedAuthor field's value.
func (s *CreateApplicationOutput) SetIsVerifiedAuthor(v bool) *CreateApplicationOutput {
	s.IsVerifiedAuthor = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *CreateApplicationOutput) SetLabels(v []*string) *CreateApplicationOutput {
	s.Labels = v
	return s
}

// SetLicenseUrl sets the LicenseUrl field's value.
func (s *CreateApplicationOutput) SetLicenseUrl(v string) *CreateApplicationOutput {
	s.LicenseUrl = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationOutput) SetName(v string) *CreateApplicationOutput {
	s.Name = &v
	return s
}

// SetReadmeUrl sets the ReadmeUrl field's value.
func (s *CreateApplicationOutput) SetReadmeUrl(v string) *CreateApplicationOutput {
	s.ReadmeUrl = &v
	return s
}

// SetSpdxLicenseId sets the SpdxLicenseId field's value.
func (s *CreateApplicationOutput) SetSpdxLicenseId(v string) *CreateApplicationOutput {
	s.SpdxLicenseId = &v
	return s
}

// SetVerifiedAuthorUrl sets the VerifiedAuthorUrl field's value.
func (s *CreateApplicationOutput) SetVerifiedAuthorUrl(v string) *CreateApplicationOutput {
	s.VerifiedAuthorUrl = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateApplicationOutput) SetVersion(v *Version) *CreateApplicationOutput {
	s.Version = v
	return s
}

type CreateApplicationRequest struct {
	_ struct{} `type:"structure"`

	// Author is a required field
	Author *string `locationName:"author" type:"string" required:"true"`

	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	HomePageUrl *string `locationName:"homePageUrl" type:"string"`

	Labels []*string `locationName:"labels" type:"list"`

	LicenseBody *string `locationName:"licenseBody" type:"string"`

	LicenseUrl *string `locationName:"licenseUrl" type:"string"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	ReadmeBody *string `locationName:"readmeBody" type:"string"`

	ReadmeUrl *string `locationName:"readmeUrl" type:"string"`

	SemanticVersion *string `locationName:"semanticVersion" type:"string"`

	SourceCodeArchiveUrl *string `locationName:"sourceCodeArchiveUrl" type:"string"`

	SourceCodeUrl *string `locationName:"sourceCodeUrl" type:"string"`

	SpdxLicenseId *string `locationName:"spdxLicenseId" type:"string"`

	TemplateBody *string `locationName:"templateBody" type:"string"`

	TemplateUrl *string `locationName:"templateUrl" type:"string"`
}

// String returns the string representation
func (s CreateApplicationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationRequest"}
	if s.Author == nil {
		invalidParams.Add(request.NewErrParamRequired("Author"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthor sets the Author field's value.
func (s *CreateApplicationRequest) SetAuthor(v string) *CreateApplicationRequest {
	s.Author = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationRequest) SetDescription(v string) *CreateApplicationRequest {
	s.Description = &v
	return s
}

// SetHomePageUrl sets the HomePageUrl field's value.
func (s *CreateApplicationRequest) SetHomePageUrl(v string) *CreateApplicationRequest {
	s.HomePageUrl = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *CreateApplicationRequest) SetLabels(v []*string) *CreateApplicationRequest {
	s.Labels = v
	return s
}

// SetLicenseBody sets the LicenseBody field's value.
func (s *CreateApplicationRequest) SetLicenseBody(v string) *CreateApplicationRequest {
	s.LicenseBody = &v
	return s
}

// SetLicenseUrl sets the LicenseUrl field's value.
func (s *CreateApplicationRequest) SetLicenseUrl(v string) *CreateApplicationRequest {
	s.LicenseUrl = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationRequest) SetName(v string) *CreateApplicationRequest {
	s.Name = &v
	return s
}

// SetReadmeBody sets the ReadmeBody field's value.
func (s *CreateApplicationRequest) SetReadmeBody(v string) *CreateApplicationRequest {
	s.ReadmeBody = &v
	return s
}

// SetReadmeUrl sets the ReadmeUrl field's value.
func (s *CreateApplicationRequest) SetReadmeUrl(v string) *CreateApplicationRequest {
	s.ReadmeUrl = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateApplicationRequest) SetSemanticVersion(v string) *CreateApplicationRequest {
	s.SemanticVersion = &v
	return s
}

// SetSourceCodeArchiveUrl sets the SourceCodeArchiveUrl field's value.
func (s *CreateApplicationRequest) SetSourceCodeArchiveUrl(v string) *CreateApplicationRequest {
	s.SourceCodeArchiveUrl = &v
	return s
}

// SetSourceCodeUrl sets the SourceCodeUrl field's value.
func (s *CreateApplicationRequest) SetSourceCodeUrl(v string) *CreateApplicationRequest {
	s.SourceCodeUrl = &v
	return s
}

// SetSpdxLicenseId sets the SpdxLicenseId field's value.
func (s *CreateApplicationRequest) SetSpdxLicenseId(v string) *CreateApplicationRequest {
	s.SpdxLicenseId = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateApplicationRequest) SetTemplateBody(v string) *CreateApplicationRequest {
	s.TemplateBody = &v
	return s
}

// SetTemplateUrl sets the TemplateUrl field's value.
func (s *CreateApplicationRequest) SetTemplateUrl(v string) *CreateApplicationRequest {
	s.TemplateUrl = &v
	return s
}

type CreateApplicationVersionOutput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `locationName:"applicationId" type:"string"`

	CreationTime *string `locationName:"creationTime" type:"string"`

	ParameterDefinitions []*ParameterDefinition `locationName:"parameterDefinitions" type:"list"`

	RequiredCapabilities []*string `locationName:"requiredCapabilities" type:"list"`

	ResourcesSupported *bool `locationName:"resourcesSupported" type:"boolean"`

	SemanticVersion *string `locationName:"semanticVersion" type:"string"`

	SourceCodeArchiveUrl *string `locationName:"sourceCodeArchiveUrl" type:"string"`

	SourceCodeUrl *string `locationName:"sourceCodeUrl" type:"string"`

	TemplateUrl *string `locationName:"templateUrl" type:"string"`
}

// String returns the string representation
func (s CreateApplicationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationVersionOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateApplicationVersionOutput) SetApplicationId(v string) *CreateApplicationVersionOutput {
	s.ApplicationId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateApplicationVersionOutput) SetCreationTime(v string) *CreateApplicationVersionOutput {
	s.CreationTime = &v
	return s
}

// SetParameterDefinitions sets the ParameterDefinitions field's value.
func (s *CreateApplicationVersionOutput) SetParameterDefinitions(v []*ParameterDefinition) *CreateApplicationVersionOutput {
	s.ParameterDefinitions = v
	return s
}

// SetRequiredCapabilities sets the RequiredCapabilities field's value.
func (s *CreateApplicationVersionOutput) SetRequiredCapabilities(v []*string) *CreateApplicationVersionOutput {
	s.RequiredCapabilities = v
	return s
}

// SetResourcesSupported sets the ResourcesSupported field's value.
func (s *CreateApplicationVersionOutput) SetResourcesSupported(v bool) *CreateApplicationVersionOutput {
	s.ResourcesSupported = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateApplicationVersionOutput) SetSemanticVersion(v string) *CreateApplicationVersionOutput {
	s.SemanticVersion = &v
	return s
}

// SetSourceCodeArchiveUrl sets the SourceCodeArchiveUrl field's value.
func (s *CreateApplicationVersionOutput) SetSourceCodeArchiveUrl(v string) *CreateApplicationVersionOutput {
	s.SourceCodeArchiveUrl = &v
	return s
}

// SetSourceCodeUrl sets the SourceCodeUrl field's value.
func (s *CreateApplicationVersionOutput) SetSourceCodeUrl(v string) *CreateApplicationVersionOutput {
	s.SourceCodeUrl = &v
	return s
}

// SetTemplateUrl sets the TemplateUrl field's value.
func (s *CreateApplicationVersionOutput) SetTemplateUrl(v string) *CreateApplicationVersionOutput {
	s.TemplateUrl = &v
	return s
}

type CreateApplicationVersionRequest struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// SemanticVersion is a required field
	SemanticVersion *string `location:"uri" locationName:"semanticVersion" type:"string" required:"true"`

	SourceCodeArchiveUrl *string `locationName:"sourceCodeArchiveUrl" type:"string"`

	SourceCodeUrl *string `locationName:"sourceCodeUrl" type:"string"`

	TemplateBody *string `locationName:"templateBody" type:"string"`

	TemplateUrl *string `locationName:"templateUrl" type:"string"`
}

// String returns the string representation
func (s CreateApplicationVersionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationVersionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationVersionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationVersionRequest"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SemanticVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SemanticVersion"))
	}
	if s.SemanticVersion != nil && len(*s.SemanticVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SemanticVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateApplicationVersionRequest) SetApplicationId(v string) *CreateApplicationVersionRequest {
	s.ApplicationId = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateApplicationVersionRequest) SetSemanticVersion(v string) *CreateApplicationVersionRequest {
	s.SemanticVersion = &v
	return s
}

// SetSourceCodeArchiveUrl sets the SourceCodeArchiveUrl field's value.
func (s *CreateApplicationVersionRequest) SetSourceCodeArchiveUrl(v string) *CreateApplicationVersionRequest {
	s.SourceCodeArchiveUrl = &v
	return s
}

// SetSourceCodeUrl sets the SourceCodeUrl field's value.
func (s *CreateApplicationVersionRequest) SetSourceCodeUrl(v string) *CreateApplicationVersionRequest {
	s.SourceCodeUrl = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateApplicationVersionRequest) SetTemplateBody(v string) *CreateApplicationVersionRequest {
	s.TemplateBody = &v
	return s
}

// SetTemplateUrl sets the TemplateUrl field's value.
func (s *CreateApplicationVersionRequest) SetTemplateUrl(v string) *CreateApplicationVersionRequest {
	s.TemplateUrl = &v
	return s
}

type CreateCloudFormationChangeSetOutput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `locationName:"applicationId" type:"string"`

	ChangeSetId *string `locationName:"changeSetId" type:"string"`

	SemanticVersion *string `locationName:"semanticVersion" type:"string"`

	StackId *string `locationName:"stackId" type:"string"`
}

// String returns the string representation
func (s CreateCloudFormationChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFormationChangeSetOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateCloudFormationChangeSetOutput) SetApplicationId(v string) *CreateCloudFormationChangeSetOutput {
	s.ApplicationId = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *CreateCloudFormationChangeSetOutput) SetChangeSetId(v string) *CreateCloudFormationChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateCloudFormationChangeSetOutput) SetSemanticVersion(v string) *CreateCloudFormationChangeSetOutput {
	s.SemanticVersion = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateCloudFormationChangeSetOutput) SetStackId(v string) *CreateCloudFormationChangeSetOutput {
	s.StackId = &v
	return s
}

type CreateCloudFormationChangeSetRequest struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	Capabilities []*string `locationName:"capabilities" type:"list"`

	ChangeSetName *string `locationName:"changeSetName" type:"string"`

	ClientToken *string `locationName:"clientToken" type:"string"`

	Description *string `locationName:"description" type:"string"`

	NotificationArns []*string `locationName:"notificationArns" type:"list"`

	ParameterOverrides []*ParameterValue `locationName:"parameterOverrides" type:"list"`

	ResourceTypes []*string `locationName:"resourceTypes" type:"list"`

	// This property corresponds to the AWS CloudFormation RollbackConfiguration
	// (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration)
	// Data Type.
	RollbackConfiguration *RollbackConfiguration `locationName:"rollbackConfiguration" type:"structure"`

	SemanticVersion *string `locationName:"semanticVersion" type:"string"`

	// StackName is a required field
	StackName *string `locationName:"stackName" type:"string" required:"true"`

	Tags []*Tag `locationName:"tags" type:"list"`

	TemplateId *string `locationName:"templateId" type:"string"`
}

// String returns the string representation
func (s CreateCloudFormationChangeSetRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFormationChangeSetRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCloudFormationChangeSetRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCloudFormationChangeSetRequest"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.ParameterOverrides != nil {
		for i, v := range s.ParameterOverrides {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterOverrides", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RollbackConfiguration != nil {
		if err := s.RollbackConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RollbackConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateCloudFormationChangeSetRequest) SetApplicationId(v string) *CreateCloudFormationChangeSetRequest {
	s.ApplicationId = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateCloudFormationChangeSetRequest) SetCapabilities(v []*string) *CreateCloudFormationChangeSetRequest {
	s.Capabilities = v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *CreateCloudFormationChangeSetRequest) SetChangeSetName(v string) *CreateCloudFormationChangeSetRequest {
	s.ChangeSetName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateCloudFormationChangeSetRequest) SetClientToken(v string) *CreateCloudFormationChangeSetRequest {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCloudFormationChangeSetRequest) SetDescription(v string) *CreateCloudFormationChangeSetRequest {
	s.Description = &v
	return s
}

// SetNotificationArns sets the NotificationArns field's value.
func (s *CreateCloudFormationChangeSetRequest) SetNotificationArns(v []*string) *CreateCloudFormationChangeSetRequest {
	s.NotificationArns = v
	return s
}

// SetParameterOverrides sets the ParameterOverrides field's value.
func (s *CreateCloudFormationChangeSetRequest) SetParameterOverrides(v []*ParameterValue) *CreateCloudFormationChangeSetRequest {
	s.ParameterOverrides = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *CreateCloudFormationChangeSetRequest) SetResourceTypes(v []*string) *CreateCloudFormationChangeSetRequest {
	s.ResourceTypes = v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *CreateCloudFormationChangeSetRequest) SetRollbackConfiguration(v *RollbackConfiguration) *CreateCloudFormationChangeSetRequest {
	s.RollbackConfiguration = v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateCloudFormationChangeSetRequest) SetSemanticVersion(v string) *CreateCloudFormationChangeSetRequest {
	s.SemanticVersion = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateCloudFormationChangeSetRequest) SetStackName(v string) *CreateCloudFormationChangeSetRequest {
	s.StackName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCloudFormationChangeSetRequest) SetTags(v []*Tag) *CreateCloudFormationChangeSetRequest {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateCloudFormationChangeSetRequest) SetTemplateId(v string) *CreateCloudFormationChangeSetRequest {
	s.TemplateId = &v
	return s
}

type CreateCloudFormationTemplateInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	SemanticVersion *string `locationName:"semanticVersion" type:"string"`
}

// String returns the string representation
func (s CreateCloudFormationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFormationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCloudFormationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCloudFormationTemplateInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateCloudFormationTemplateInput) SetApplicationId(v string) *CreateCloudFormationTemplateInput {
	s.ApplicationId = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateCloudFormationTemplateInput) SetSemanticVersion(v string) *CreateCloudFormationTemplateInput {
	s.SemanticVersion = &v
	return s
}

type CreateCloudFormationTemplateOutput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `locationName:"applicationId" type:"string"`

	CreationTime *string `locationName:"creationTime" type:"string"`

	ExpirationTime *string `locationName:"expirationTime" type:"string"`

	SemanticVersion *string `locationName:"semanticVersion" type:"string"`

	Status *string `locationName:"status" type:"string" enum:"Status"`

	TemplateId *string `locationName:"templateId" type:"string"`

	TemplateUrl *string `locationName:"templateUrl" type:"string"`
}

// String returns the string representation
func (s CreateCloudFormationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFormationTemplateOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateCloudFormationTemplateOutput) SetApplicationId(v string) *CreateCloudFormationTemplateOutput {
	s.ApplicationId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateCloudFormationTemplateOutput) SetCreationTime(v string) *CreateCloudFormationTemplateOutput {
	s.CreationTime = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *CreateCloudFormationTemplateOutput) SetExpirationTime(v string) *CreateCloudFormationTemplateOutput {
	s.ExpirationTime = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateCloudFormationTemplateOutput) SetSemanticVersion(v string) *CreateCloudFormationTemplateOutput {
	s.SemanticVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateCloudFormationTemplateOutput) SetStatus(v string) *CreateCloudFormationTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateCloudFormationTemplateOutput) SetTemplateId(v string) *CreateCloudFormationTemplateOutput {
	s.TemplateId = &v
	return s
}

// SetTemplateUrl sets the TemplateUrl field's value.
func (s *CreateCloudFormationTemplateOutput) SetTemplateUrl(v string) *CreateCloudFormationTemplateOutput {
	s.TemplateUrl = &v
	return s
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApplicationInput) SetApplicationId(v string) *DeleteApplicationInput {
	s.ApplicationId = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type GetApplicationInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	SemanticVersion *string `location:"querystring" locationName:"semanticVersion" type:"string"`
}

// String returns the string representation
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationInput) SetApplicationId(v string) *GetApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *GetApplicationInput) SetSemanticVersion(v string) *GetApplicationInput {
	s.SemanticVersion = &v
	return s
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `locationName:"applicationId" type:"string"`

	Author *string `locationName:"author" type:"string"`

	CreationTime *string `locationName:"creationTime" type:"string"`

	Description *string `locationName:"description" type:"string"`

	HomePageUrl *string `locationName:"homePageUrl" type:"string"`

	IsVerifiedAuthor *bool `locationName:"isVerifiedAuthor" type:"boolean"`

	Labels []*string `locationName:"labels" type:"list"`

	LicenseUrl *string `locationName:"licenseUrl" type:"string"`

	Name *string `locationName:"name" type:"string"`

	ReadmeUrl *string `locationName:"readmeUrl" type:"string"`

	SpdxLicenseId *string `locationName:"spdxLicenseId" type:"string"`

	VerifiedAuthorUrl *string `locationName:"verifiedAuthorUrl" type:"string"`

	// Application version details.
	Version *Version `locationName:"version" type:"structure"`
}

// String returns the string representation
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationOutput) SetApplicationId(v string) *GetApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *GetApplicationOutput) SetAuthor(v string) *GetApplicationOutput {
	s.Author = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetApplicationOutput) SetCreationTime(v string) *GetApplicationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetApplicationOutput) SetDescription(v string) *GetApplicationOutput {
	s.Description = &v
	return s
}

// SetHomePageUrl sets the HomePageUrl field's value.
func (s *GetApplicationOutput) SetHomePageUrl(v string) *GetApplicationOutput {
	s.HomePageUrl = &v
	return s
}

// SetIsVerifiedAuthor sets the IsVerifiedAuthor field's value.
func (s *GetApplicationOutput) SetIsVerifiedAuthor(v bool) *GetApplicationOutput {
	s.IsVerifiedAuthor = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *GetApplicationOutput) SetLabels(v []*string) *GetApplicationOutput {
	s.Labels = v
	return s
}

// SetLicenseUrl sets the LicenseUrl field's value.
func (s *GetApplicationOutput) SetLicenseUrl(v string) *GetApplicationOutput {
	s.LicenseUrl = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetApplicationOutput) SetName(v string) *GetApplicationOutput {
	s.Name = &v
	return s
}

// SetReadmeUrl sets the ReadmeUrl field's value.
func (s *GetApplicationOutput) SetReadmeUrl(v string) *GetApplicationOutput {
	s.ReadmeUrl = &v
	return s
}

// SetSpdxLicenseId sets the SpdxLicenseId field's value.
func (s *GetApplicationOutput) SetSpdxLicenseId(v string) *GetApplicationOutput {
	s.SpdxLicenseId = &v
	return s
}

// SetVerifiedAuthorUrl sets the VerifiedAuthorUrl field's value.
func (s *GetApplicationOutput) SetVerifiedAuthorUrl(v string) *GetApplicationOutput {
	s.VerifiedAuthorUrl = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetApplicationOutput) SetVersion(v *Version) *GetApplicationOutput {
	s.Version = v
	return s
}

type GetApplicationPolicyInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApplicationPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationPolicyInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationPolicyInput) SetApplicationId(v string) *GetApplicationPolicyInput {
	s.ApplicationId = &v
	return s
}

type GetApplicationPolicyOutput struct {
	_ struct{} `type:"structure"`

	Statements []*ApplicationPolicyStatement `locationName:"statements" type:"list"`
}

// String returns the string representation
func (s GetApplicationPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationPolicyOutput) GoString() string {
	return s.String()
}

// SetStatements sets the Statements field's value.
func (s *GetApplicationPolicyOutput) SetStatements(v []*ApplicationPolicyStatement) *GetApplicationPolicyOutput {
	s.Statements = v
	return s
}

type GetCloudFormationTemplateInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"templateId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCloudFormationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFormationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCloudFormationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCloudFormationTemplateInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCloudFormationTemplateInput) SetApplicationId(v string) *GetCloudFormationTemplateInput {
	s.ApplicationId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetCloudFormationTemplateInput) SetTemplateId(v string) *GetCloudFormationTemplateInput {
	s.TemplateId = &v
	return s
}

type GetCloudFormationTemplateOutput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `locationName:"applicationId" type:"string"`

	CreationTime *string `locationName:"creationTime" type:"string"`

	ExpirationTime *string `locationName:"expirationTime" type:"string"`

	SemanticVersion *string `locationName:"semanticVersion" type:"string"`

	Status *string `locationName:"status" type:"string" enum:"Status"`

	TemplateId *string `locationName:"templateId" type:"string"`

	TemplateUrl *string `locationName:"templateUrl" type:"string"`
}

// String returns the string representation
func (s GetCloudFormationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFormationTemplateOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCloudFormationTemplateOutput) SetApplicationId(v string) *GetCloudFormationTemplateOutput {
	s.ApplicationId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetCloudFormationTemplateOutput) SetCreationTime(v string) *GetCloudFormationTemplateOutput {
	s.CreationTime = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *GetCloudFormationTemplateOutput) SetExpirationTime(v string) *GetCloudFormationTemplateOutput {
	s.ExpirationTime = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *GetCloudFormationTemplateOutput) SetSemanticVersion(v string) *GetCloudFormationTemplateOutput {
	s.SemanticVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetCloudFormationTemplateOutput) SetStatus(v string) *GetCloudFormationTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetCloudFormationTemplateOutput) SetTemplateId(v string) *GetCloudFormationTemplateOutput {
	s.TemplateId = &v
	return s
}

// SetTemplateUrl sets the TemplateUrl field's value.
func (s *GetCloudFormationTemplateOutput) SetTemplateUrl(v string) *GetCloudFormationTemplateOutput {
	s.TemplateUrl = &v
	return s
}

type ListApplicationDependenciesInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	MaxItems *int64 `location:"querystring" locationName:"maxItems" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	SemanticVersion *string `location:"querystring" locationName:"semanticVersion" type:"string"`
}

// String returns the string representation
func (s ListApplicationDependenciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationDependenciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationDependenciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationDependenciesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListApplicationDependenciesInput) SetApplicationId(v string) *ListApplicationDependenciesInput {
	s.ApplicationId = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListApplicationDependenciesInput) SetMaxItems(v int64) *ListApplicationDependenciesInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationDependenciesInput) SetNextToken(v string) *ListApplicationDependenciesInput {
	s.NextToken = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *ListApplicationDependenciesInput) SetSemanticVersion(v string) *ListApplicationDependenciesInput {
	s.SemanticVersion = &v
	return s
}

type ListApplicationDependenciesOutput struct {
	_ struct{} `type:"structure"`

	Dependencies []*ApplicationDependencySummary `locationName:"dependencies" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApplicationDependenciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationDependenciesOutput) GoString() string {
	return s.String()
}

// SetDependencies sets the Dependencies field's value.
func (s *ListApplicationDependenciesOutput) SetDependencies(v []*ApplicationDependencySummary) *ListApplicationDependenciesOutput {
	s.Dependencies = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationDependenciesOutput) SetNextToken(v string) *ListApplicationDependenciesOutput {
	s.NextToken = &v
	return s
}

type ListApplicationVersionsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	MaxItems *int64 `location:"querystring" locationName:"maxItems" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApplicationVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListApplicationVersionsInput) SetApplicationId(v string) *ListApplicationVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListApplicationVersionsInput) SetMaxItems(v int64) *ListApplicationVersionsInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationVersionsInput) SetNextToken(v string) *ListApplicationVersionsInput {
	s.NextToken = &v
	return s
}

type ListApplicationVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Versions []*VersionSummary `locationName:"versions" type:"list"`
}

// String returns the string representation
func (s ListApplicationVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationVersionsOutput) SetNextToken(v string) *ListApplicationVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListApplicationVersionsOutput) SetVersions(v []*VersionSummary) *ListApplicationVersionsOutput {
	s.Versions = v
	return s
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	MaxItems *int64 `location:"querystring" locationName:"maxItems" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListApplicationsInput) SetMaxItems(v int64) *ListApplicationsInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	Applications []*ApplicationSummary `locationName:"applications" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *ListApplicationsOutput) SetApplications(v []*ApplicationSummary) *ListApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

// Parameters supported by the application.
type ParameterDefinition struct {
	_ struct{} `type:"structure"`

	// A regular expression that represents the patterns to allow for String types.
	AllowedPattern *string `locationName:"allowedPattern" type:"string"`

	// An array containing the list of values allowed for the parameter.
	AllowedValues []*string `locationName:"allowedValues" type:"list"`

	// A string that explains a constraint when the constraint is violated. For
	// example, without a constraint description, a parameter that has an allowed
	// pattern of [A-Za-z0-9]+ displays the following error message when the user
	// specifies an invalid value:
	//
	// Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+
	//
	// By adding a constraint description, such as "must contain only uppercase
	// and lowercase letters and numbers," you can display the following customized
	// error message:
	//
	// Malformed input-Parameter MyParameter must contain only uppercase and lowercase
	// letters and numbers.
	ConstraintDescription *string `locationName:"constraintDescription" type:"string"`

	// A value of the appropriate type for the template to use if no value is specified
	// when a stack is created. If you define constraints for the parameter, you
	// must specify a value that adheres to those constraints.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// A string of up to 4,000 characters that describes the parameter.
	Description *string `locationName:"description" type:"string"`

	// An integer value that determines the largest number of characters that you
	// want to allow for String types.
	MaxLength *int64 `locationName:"maxLength" type:"integer"`

	// A numeric value that determines the largest numeric value that you want to
	// allow for Number types.
	MaxValue *int64 `locationName:"maxValue" type:"integer"`

	// An integer value that determines the smallest number of characters that you
	// want to allow for String types.
	MinLength *int64 `locationName:"minLength" type:"integer"`

	// A numeric value that determines the smallest numeric value that you want
	// to allow for Number types.
	MinValue *int64 `locationName:"minValue" type:"integer"`

	// The name of the parameter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Whether to mask the parameter value whenever anyone makes a call that describes
	// the stack. If you set the value to true, the parameter value is masked with
	// asterisks (*****).
	NoEcho *bool `locationName:"noEcho" type:"boolean"`

	// A list of AWS SAM resources that use this parameter.
	//
	// ReferencedByResources is a required field
	ReferencedByResources []*string `locationName:"referencedByResources" type:"list" required:"true"`

	// The type of the parameter.
	//
	// Valid values: String | Number | List<Number> | CommaDelimitedList
	//
	// String: A literal string.
	//
	// For example, users can specify "MyUserName".
	//
	// Number: An integer or float. AWS CloudFormation validates the parameter value
	// as a number. However, when you use the parameter elsewhere in your template
	// (for example, by using the Ref intrinsic function), the parameter value becomes
	// a string.
	//
	// For example, users might specify "8888".
	//
	// List<Number>: An array of integers or floats that are separated by commas.
	// AWS CloudFormation validates the parameter value as numbers. However, when
	// you use the parameter elsewhere in your template (for example, by using the
	// Ref intrinsic function), the parameter value becomes a list of strings.
	//
	// For example, users might specify "80,20", and then Ref results in ["80","20"].
	//
	// CommaDelimitedList: An array of literal strings that are separated by commas.
	// The total number of strings should be one more than the total number of commas.
	// Also, each member string is space-trimmed.
	//
	// For example, users might specify "test,dev,prod", and then Ref results in
	// ["test","dev","prod"].
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s ParameterDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterDefinition) GoString() string {
	return s.String()
}

// SetAllowedPattern sets the AllowedPattern field's value.
func (s *ParameterDefinition) SetAllowedPattern(v string) *ParameterDefinition {
	s.AllowedPattern = &v
	return s
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *ParameterDefinition) SetAllowedValues(v []*string) *ParameterDefinition {
	s.AllowedValues = v
	return s
}

// SetConstraintDescription sets the ConstraintDescription field's value.
func (s *ParameterDefinition) SetConstraintDescription(v string) *ParameterDefinition {
	s.ConstraintDescription = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ParameterDefinition) SetDefaultValue(v string) *ParameterDefinition {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ParameterDefinition) SetDescription(v string) *ParameterDefinition {
	s.Description = &v
	return s
}

// SetMaxLength sets the MaxLength field's value.
func (s *ParameterDefinition) SetMaxLength(v int64) *ParameterDefinition {
	s.MaxLength = &v
	return s
}

// SetMaxValue sets the MaxValue field's value.
func (s *ParameterDefinition) SetMaxValue(v int64) *ParameterDefinition {
	s.MaxValue = &v
	return s
}

// SetMinLength sets the MinLength field's value.
func (s *ParameterDefinition) SetMinLength(v int64) *ParameterDefinition {
	s.MinLength = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *ParameterDefinition) SetMinValue(v int64) *ParameterDefinition {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *ParameterDefinition) SetName(v string) *ParameterDefinition {
	s.Name = &v
	return s
}

// SetNoEcho sets the NoEcho field's value.
func (s *ParameterDefinition) SetNoEcho(v bool) *ParameterDefinition {
	s.NoEcho = &v
	return s
}

// SetReferencedByResources sets the ReferencedByResources field's value.
func (s *ParameterDefinition) SetReferencedByResources(v []*string) *ParameterDefinition {
	s.ReferencedByResources = v
	return s
}

// SetType sets the Type field's value.
func (s *ParameterDefinition) SetType(v string) *ParameterDefinition {
	s.Type = &v
	return s
}

// Parameter value of the application.
type ParameterValue struct {
	_ struct{} `type:"structure"`

	// The key associated with the parameter. If you don't specify a key and value
	// for a particular parameter, AWS CloudFormation uses the default value that
	// is specified in your template.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The input value associated with the parameter.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s ParameterValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParameterValue"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ParameterValue) SetName(v string) *ParameterValue {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ParameterValue) SetValue(v string) *ParameterValue {
	s.Value = &v
	return s
}

type PutApplicationPolicyInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// Statements is a required field
	Statements []*ApplicationPolicyStatement `locationName:"statements" type:"list" required:"true"`
}

// String returns the string representation
func (s PutApplicationPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutApplicationPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutApplicationPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutApplicationPolicyInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.Statements == nil {
		invalidParams.Add(request.NewErrParamRequired("Statements"))
	}
	if s.Statements != nil {
		for i, v := range s.Statements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Statements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *PutApplicationPolicyInput) SetApplicationId(v string) *PutApplicationPolicyInput {
	s.ApplicationId = &v
	return s
}

// SetStatements sets the Statements field's value.
func (s *PutApplicationPolicyInput) SetStatements(v []*ApplicationPolicyStatement) *PutApplicationPolicyInput {
	s.Statements = v
	return s
}

type PutApplicationPolicyOutput struct {
	_ struct{} `type:"structure"`

	Statements []*ApplicationPolicyStatement `locationName:"statements" type:"list"`
}

// String returns the string representation
func (s PutApplicationPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutApplicationPolicyOutput) GoString() string {
	return s.String()
}

// SetStatements sets the Statements field's value.
func (s *PutApplicationPolicyOutput) SetStatements(v []*ApplicationPolicyStatement) *PutApplicationPolicyOutput {
	s.Statements = v
	return s
}

// This property corresponds to the AWS CloudFormation RollbackConfiguration
// (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration)
// Data Type.
type RollbackConfiguration struct {
	_ struct{} `type:"structure"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// RollbackConfiguration (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration)
	// Data Type.
	MonitoringTimeInMinutes *int64 `locationName:"monitoringTimeInMinutes" type:"integer"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// RollbackConfiguration (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration)
	// Data Type.
	RollbackTriggers []*RollbackTrigger `locationName:"rollbackTriggers" type:"list"`
}

// String returns the string representation
func (s RollbackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackConfiguration"}
	if s.RollbackTriggers != nil {
		for i, v := range s.RollbackTriggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RollbackTriggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitoringTimeInMinutes sets the MonitoringTimeInMinutes field's value.
func (s *RollbackConfiguration) SetMonitoringTimeInMinutes(v int64) *RollbackConfiguration {
	s.MonitoringTimeInMinutes = &v
	return s
}

// SetRollbackTriggers sets the RollbackTriggers field's value.
func (s *RollbackConfiguration) SetRollbackTriggers(v []*RollbackTrigger) *RollbackConfiguration {
	s.RollbackTriggers = v
	return s
}

// This property corresponds to the AWS CloudFormation RollbackTrigger (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger)
// Data Type.
type RollbackTrigger struct {
	_ struct{} `type:"structure"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// RollbackTrigger (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger)
	// Data Type.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// RollbackTrigger (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger)
	// Data Type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation
func (s RollbackTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackTrigger) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackTrigger) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackTrigger"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *RollbackTrigger) SetArn(v string) *RollbackTrigger {
	s.Arn = &v
	return s
}

// SetType sets the Type field's value.
func (s *RollbackTrigger) SetType(v string) *RollbackTrigger {
	s.Type = &v
	return s
}

// This property corresponds to the AWS CloudFormation Tag (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag)
// Data Type.
type Tag struct {
	_ struct{} `type:"structure"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// Tag (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag)
	// Data Type.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// This property corresponds to the content of the same name for the AWS CloudFormation
	// Tag (https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag)
	// Data Type.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `locationName:"applicationId" type:"string"`

	Author *string `locationName:"author" type:"string"`

	CreationTime *string `locationName:"creationTime" type:"string"`

	Description *string `locationName:"description" type:"string"`

	HomePageUrl *string `locationName:"homePageUrl" type:"string"`

	IsVerifiedAuthor *bool `locationName:"isVerifiedAuthor" type:"boolean"`

	Labels []*string `locationName:"labels" type:"list"`

	LicenseUrl *string `locationName:"licenseUrl" type:"string"`

	Name *string `locationName:"name" type:"string"`

	ReadmeUrl *string `locationName:"readmeUrl" type:"string"`

	SpdxLicenseId *string `locationName:"spdxLicenseId" type:"string"`

	VerifiedAuthorUrl *string `locationName:"verifiedAuthorUrl" type:"string"`

	// Application version details.
	Version *Version `locationName:"version" type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationOutput) SetApplicationId(v string) *UpdateApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *UpdateApplicationOutput) SetAuthor(v string) *UpdateApplicationOutput {
	s.Author = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateApplicationOutput) SetCreationTime(v string) *UpdateApplicationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationOutput) SetDescription(v string) *UpdateApplicationOutput {
	s.Description = &v
	return s
}

// SetHomePageUrl sets the HomePageUrl field's value.
func (s *UpdateApplicationOutput) SetHomePageUrl(v string) *UpdateApplicationOutput {
	s.HomePageUrl = &v
	return s
}

// SetIsVerifiedAuthor sets the IsVerifiedAuthor field's value.
func (s *UpdateApplicationOutput) SetIsVerifiedAuthor(v bool) *UpdateApplicationOutput {
	s.IsVerifiedAuthor = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *UpdateApplicationOutput) SetLabels(v []*string) *UpdateApplicationOutput {
	s.Labels = v
	return s
}

// SetLicenseUrl sets the LicenseUrl field's value.
func (s *UpdateApplicationOutput) SetLicenseUrl(v string) *UpdateApplicationOutput {
	s.LicenseUrl = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApplicationOutput) SetName(v string) *UpdateApplicationOutput {
	s.Name = &v
	return s
}

// SetReadmeUrl sets the ReadmeUrl field's value.
func (s *UpdateApplicationOutput) SetReadmeUrl(v string) *UpdateApplicationOutput {
	s.ReadmeUrl = &v
	return s
}

// SetSpdxLicenseId sets the SpdxLicenseId field's value.
func (s *UpdateApplicationOutput) SetSpdxLicenseId(v string) *UpdateApplicationOutput {
	s.SpdxLicenseId = &v
	return s
}

// SetVerifiedAuthorUrl sets the VerifiedAuthorUrl field's value.
func (s *UpdateApplicationOutput) SetVerifiedAuthorUrl(v string) *UpdateApplicationOutput {
	s.VerifiedAuthorUrl = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateApplicationOutput) SetVersion(v *Version) *UpdateApplicationOutput {
	s.Version = v
	return s
}

type UpdateApplicationRequest struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	Author *string `locationName:"author" type:"string"`

	Description *string `locationName:"description" type:"string"`

	HomePageUrl *string `locationName:"homePageUrl" type:"string"`

	Labels []*string `locationName:"labels" type:"list"`

	ReadmeBody *string `locationName:"readmeBody" type:"string"`

	ReadmeUrl *string `locationName:"readmeUrl" type:"string"`
}

// String returns the string representation
func (s UpdateApplicationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationRequest"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationRequest) SetApplicationId(v string) *UpdateApplicationRequest {
	s.ApplicationId = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *UpdateApplicationRequest) SetAuthor(v string) *UpdateApplicationRequest {
	s.Author = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationRequest) SetDescription(v string) *UpdateApplicationRequest {
	s.Description = &v
	return s
}

// SetHomePageUrl sets the HomePageUrl field's value.
func (s *UpdateApplicationRequest) SetHomePageUrl(v string) *UpdateApplicationRequest {
	s.HomePageUrl = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *UpdateApplicationRequest) SetLabels(v []*string) *UpdateApplicationRequest {
	s.Labels = v
	return s
}

// SetReadmeBody sets the ReadmeBody field's value.
func (s *UpdateApplicationRequest) SetReadmeBody(v string) *UpdateApplicationRequest {
	s.ReadmeBody = &v
	return s
}

// SetReadmeUrl sets the ReadmeUrl field's value.
func (s *UpdateApplicationRequest) SetReadmeUrl(v string) *UpdateApplicationRequest {
	s.ReadmeUrl = &v
	return s
}

// Application version details.
type Version struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The date and time this resource was created.
	//
	// CreationTime is a required field
	CreationTime *string `locationName:"creationTime" type:"string" required:"true"`

	// An array of parameter types supported by the application.
	//
	// ParameterDefinitions is a required field
	ParameterDefinitions []*ParameterDefinition `locationName:"parameterDefinitions" type:"list" required:"true"`

	// A list of values that you must specify before you can deploy certain applications.
	// Some applications might include resources that can affect permissions in
	// your AWS account, for example, by creating new AWS Identity and Access Management
	// (IAM) users. For those applications, you must explicitly acknowledge their
	// capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY,
	// and CAPABILITY_AUTO_EXPAND.
	//
	// The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM:
	// AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	// AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	// AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html),
	// and AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html).
	// If the application contains IAM resources, you can specify either CAPABILITY_IAM
	// or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom
	// names, you must specify CAPABILITY_NAMED_IAM.
	//
	// The following resources require you to specify CAPABILITY_RESOURCE_POLICY:
	// AWS::Lambda::Permission (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html),
	// AWS::IAM:Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html),
	// AWS::ApplicationAutoScaling::ScalingPolicy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html),
	// AWS::S3::BucketPolicy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html),
	// AWS::SQS::QueuePolicy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html),
	// and AWS::SNS::TopicPolicy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html).
	//
	// Applications that contain one or more nested applications require you to
	// specify CAPABILITY_AUTO_EXPAND.
	//
	// If your application template contains any of the above resources, we recommend
	// that you review all permissions associated with the application before deploying.
	// If you don't specify this parameter for an application that requires capabilities,
	// the call will fail.
	//
	// RequiredCapabilities is a required field
	RequiredCapabilities []*string `locationName:"requiredCapabilities" type:"list" required:"true"`

	// Whether all of the AWS resources contained in this application are supported
	// in the region in which it is being retrieved.
	//
	// ResourcesSupported is a required field
	ResourcesSupported *bool `locationName:"resourcesSupported" type:"boolean" required:"true"`

	// The semantic version of the application:
	//
	// https://semver.org/ (https://semver.org/)
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// A link to the S3 object that contains the ZIP archive of the source code
	// for this version of your application.
	//
	// Maximum size 50 MB
	SourceCodeArchiveUrl *string `locationName:"sourceCodeArchiveUrl" type:"string"`

	// A link to a public repository for the source code of your application, for
	// example the URL of a specific GitHub commit.
	SourceCodeUrl *string `locationName:"sourceCodeUrl" type:"string"`

	// A link to the packaged AWS SAM template of your application.
	//
	// TemplateUrl is a required field
	TemplateUrl *string `locationName:"templateUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s Version) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Version) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *Version) SetApplicationId(v string) *Version {
	s.ApplicationId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Version) SetCreationTime(v string) *Version {
	s.CreationTime = &v
	return s
}

// SetParameterDefinitions sets the ParameterDefinitions field's value.
func (s *Version) SetParameterDefinitions(v []*ParameterDefinition) *Version {
	s.ParameterDefinitions = v
	return s
}

// SetRequiredCapabilities sets the RequiredCapabilities field's value.
func (s *Version) SetRequiredCapabilities(v []*string) *Version {
	s.RequiredCapabilities = v
	return s
}

// SetResourcesSupported sets the ResourcesSupported field's value.
func (s *Version) SetResourcesSupported(v bool) *Version {
	s.ResourcesSupported = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *Version) SetSemanticVersion(v string) *Version {
	s.SemanticVersion = &v
	return s
}

// SetSourceCodeArchiveUrl sets the SourceCodeArchiveUrl field's value.
func (s *Version) SetSourceCodeArchiveUrl(v string) *Version {
	s.SourceCodeArchiveUrl = &v
	return s
}

// SetSourceCodeUrl sets the SourceCodeUrl field's value.
func (s *Version) SetSourceCodeUrl(v string) *Version {
	s.SourceCodeUrl = &v
	return s
}

// SetTemplateUrl sets the TemplateUrl field's value.
func (s *Version) SetTemplateUrl(v string) *Version {
	s.TemplateUrl = &v
	return s
}

// An application version summary.
type VersionSummary struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The date and time this resource was created.
	//
	// CreationTime is a required field
	CreationTime *string `locationName:"creationTime" type:"string" required:"true"`

	// The semantic version of the application:
	//
	// https://semver.org/ (https://semver.org/)
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// A link to a public repository for the source code of your application, for
	// example the URL of a specific GitHub commit.
	SourceCodeUrl *string `locationName:"sourceCodeUrl" type:"string"`
}

// String returns the string representation
func (s VersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VersionSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *VersionSummary) SetApplicationId(v string) *VersionSummary {
	s.ApplicationId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *VersionSummary) SetCreationTime(v string) *VersionSummary {
	s.CreationTime = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *VersionSummary) SetSemanticVersion(v string) *VersionSummary {
	s.SemanticVersion = &v
	return s
}

// SetSourceCodeUrl sets the SourceCodeUrl field's value.
func (s *VersionSummary) SetSourceCodeUrl(v string) *VersionSummary {
	s.SourceCodeUrl = &v
	return s
}

// Values that must be specified in order to deploy some applications.
const (
	// CapabilityCapabilityIam is a Capability enum value
	CapabilityCapabilityIam = "CAPABILITY_IAM"

	// CapabilityCapabilityNamedIam is a Capability enum value
	CapabilityCapabilityNamedIam = "CAPABILITY_NAMED_IAM"

	// CapabilityCapabilityAutoExpand is a Capability enum value
	CapabilityCapabilityAutoExpand = "CAPABILITY_AUTO_EXPAND"

	// CapabilityCapabilityResourcePolicy is a Capability enum value
	CapabilityCapabilityResourcePolicy = "CAPABILITY_RESOURCE_POLICY"
)

const (
	// StatusPreparing is a Status enum value
	StatusPreparing = "PREPARING"

	// StatusActive is a Status enum value
	StatusActive = "ACTIVE"

	// StatusExpired is a Status enum value
	StatusExpired = "EXPIRED"
)
