#ifndef __GM_SCRIPTS_H__
#define __GM_SCRIPTS_H__

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#ifdef HAVE_RUBY
#include <glib.h>
#include <gtk/gtk.h>

#include "gm-world.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_SCRIPTS					(gm_scripts_get_type())
#define GM_SCRIPTS(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
											GM_TYPE_SCRIPTS, GmScripts))
#define GM_SCRIPTS_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
											GM_TYPE_SCRIPTS, GmScripts const))
#define GM_SCRIPTS_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
											GM_TYPE_SCRIPTS, GmScriptsClass))
#define GM_IS_SCRIPTS(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
											GM_TYPE_SCRIPTS))
#define GM_IS_SCRIPTS_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
											GM_TYPE_SCRIPTS))
#define GM_SCRIPTS_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
											GM_TYPE_SCRIPTS, GmScriptsClass))

/* Private structure type */
typedef struct _GmScriptsPrivate GmScriptsPrivate;

/*
 * Main object structure
 */
typedef struct _GmScripts GmScripts;
 
struct _GmScripts {
	GObject object;
	
	/*< private > */
	GmScriptsPrivate *priv;
};

typedef enum _GmScriptType {
	GM_SCRIPT_TYPE_USER,
	GM_SCRIPT_TYPE_SHARE
} GmScriptType;

typedef struct _GmScript {
	gchar *filename;
	GmScriptType type;
	GList *functions;
} GmScript;

typedef struct _GmScriptFunction {
	GmScript *script;
	gchar *name;
	gchar *fname;
	gchar *description;
} GmScriptFunction;

typedef struct _GmScriptInfo {
	gchar *name;
	gchar *argstr;
} GmScriptInfo;

/*
 * Class definition
 */
typedef struct _GmScriptsClass 	GmScriptsClass;

struct _GmScriptsClass {
	GObjectClass parent_class;

	/* Signals */
	void (* script_added) (GmScripts *scripts, GmScript *script);
	void (* script_changed) (GmScripts *scripts, GmScript *script);
	void (* script_removed) (GmScripts *scripts, GmScript *script);
	void (* reload) (GmScripts *scripts);
	void (* message) (GmScripts *scripts, gchar *message);
	void (* error) (GmScripts *scripts, gchar *message);
	void (* run) (GmScripts *scripts, gchar *message);
};

GType gm_scripts_get_type(void) G_GNUC_CONST;
GmScripts *gm_scripts_new();

//void gm_script_init();
//void gm_script_fini();

void gm_scripts_reload_file(GmScripts *scripts, const gchar *uri);
gboolean gm_scripts_add_file(GmScripts *scripts, const gchar *uri);
void gm_scripts_remove_file(GmScripts *scripts, const gchar *uri);

GmScriptFunction *gm_scripts_find(GmScripts *scripts, gchar *name);
GList *gm_scripts_scripts(GmScripts *scripts);

gboolean gm_scripts_run(GmScripts *scripts, GmWorld *world, gchar *name, 
		gchar *argstr);
void gm_scripts_load(GmScripts *scripts);
	
G_END_DECLS

#endif /* HAVE_RUBY */
#endif /* __GM_SCRIPTS_H__ */
