-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/dbi/adbc/gnu-db-adbc-hostvariable.ads,v $
--  Description     : Ada Database Objects - Hostvariable                    --
--  Author          : Michael Erdmann                                        --
--  Created         : 29.1.2002                                              --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/02/14 20:46:59 $
--  Version         : $Revision: 1.1 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2002 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  A host variable has three aspects:                                       --
--    - The Ada 95 representation                                            --
--    - The SQL aspect                                                       --
--    - For the driver an storage area which is used to interface with       --
--      the underlying data base.                                            --
--                                                                           --
--  The Ada 95                                                               --
--                                                                           --
--                                                                           --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  Only Linux                                                               --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--               purl:/net/michael.erdmann                                   --
--                                                                           --
-------------------------------------------------------------------------------
with System;                             use System;
with Ada.Finalization;                   use Ada.Finalization;

package GNU.DB.ADBC.Hostvariable  is

   type Object is new Controlled with private;

   type Handle is access all Object'Class;

   ---------------------------------------------------------------------------
   --# Description    :
   --#    This is the base class of all host variables.
   --# Preconditions  :
   --#
   --# Postconditions :
   --#
   --# Exceptions     :
   --#
   --# Note           :
   ---------------------------------------------------------------------------
   function Is_Null(
      This : in Object'Class ) return Boolean;

   function Self(
      This : in Object'Class ) return Handle;

   function Length(
      This   : in Object'Class ) return Natural;

--   procedure Assign_To_Statement(
--      This : in Object'Class;
--      Stmt : in Statement_ID );

   -- These procedures are only for child packages
   procedure Deallocate(
      This  : in Object'Class );

   function Allocate(
      This   : in Object'Class;
      Size   : in Natural ) return System.Address;

   function Hostdata(
      This   : in Object'Class ) return System.Address;

private
   -- ======================================================================== --
   type Object_Data;
   type Object_Data_Access is access Object_Data;

   type Object is new Controlled with record
         Data : Object_Data_Access;
      end record;

   -- requiered by the controlled type base type
   procedure Initialize(
      This : in out Object );

   procedure Finalize(
      This : in out Object );

end GNU.DB.ADBC.Hostvariable ;

