/* gitg-repository-list-box.c generated by valac 0.28.0, the Vala compiler
 * generated from gitg-repository-list-box.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Ignacio Casal Quinteiro
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>


#define GITG_TYPE_SELECTION_MODE (gitg_selection_mode_get_type ())

#define GITG_TYPE_REPOSITORY_LIST_BOX (gitg_repository_list_box_get_type ())
#define GITG_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox))
#define GITG_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))
#define GITG_IS_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_IS_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_REPOSITORY_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))

typedef struct _GitgRepositoryListBox GitgRepositoryListBox;
typedef struct _GitgRepositoryListBoxClass GitgRepositoryListBoxClass;
typedef struct _GitgRepositoryListBoxPrivate GitgRepositoryListBoxPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_REPOSITORY_LIST_BOX_TYPE_ROW (gitg_repository_list_box_row_get_type ())
#define GITG_REPOSITORY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow))
#define GITG_REPOSITORY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))

typedef struct _GitgRepositoryListBoxRow GitgRepositoryListBoxRow;
typedef struct _GitgRepositoryListBoxRowClass GitgRepositoryListBoxRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block16Data Block16Data;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _GitgRepositoryListBoxRowPrivate GitgRepositoryListBoxRowPrivate;

#define GITG_TYPE_PROGRESS_BIN (gitg_progress_bin_get_type ())
#define GITG_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBin))
#define GITG_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))
#define GITG_IS_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PROGRESS_BIN))
#define GITG_IS_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PROGRESS_BIN))
#define GITG_PROGRESS_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))

typedef struct _GitgProgressBin GitgProgressBin;
typedef struct _GitgProgressBinClass GitgProgressBinClass;

typedef enum  {
	GITG_SELECTION_MODE_NORMAL,
	GITG_SELECTION_MODE_SELECTION
} GitgSelectionMode;

struct _GitgRepositoryListBox {
	GtkListBox parent_instance;
	GitgRepositoryListBoxPrivate * priv;
};

struct _GitgRepositoryListBoxClass {
	GtkListBoxClass parent_class;
};

struct _GitgRepositoryListBoxPrivate {
	gchar* d_filter_text;
	GitgSelectionMode _mode;
};

struct _Block16Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* row;
	GFile* f;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _GitgRepositoryListBoxRow {
	GtkListBoxRow parent_instance;
	GitgRepositoryListBoxRowPrivate * priv;
};

struct _GitgRepositoryListBoxRowClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgRepositoryListBoxRowPrivate {
	GitgRepository* d_repository;
	GDateTime* d_time;
	gboolean d_loading;
	gboolean d_has_remote;
	GitgProgressBin* d_progress_bin;
	GtkImage* d_image;
	GtkLabel* d_repository_label;
	GtkLabel* d_branch_label;
	GtkArrow* d_arrow;
	GtkSpinner* d_spinner;
	GtkCheckButton* d_remove_check_button;
	GtkRevealer* d_remove_revealer;
	GtkBox* d_submodule_box;
	GitgSelectionMode d_mode;
	gboolean _selected;
};


static gpointer gitg_repository_list_box_parent_class = NULL;
static gpointer gitg_repository_list_box_row_parent_class = NULL;
static GtkIconSize gitg_repository_list_box_row_s_icon_size;
static GtkIconSize gitg_repository_list_box_row_s_icon_size = 0;

GType gitg_selection_mode_get_type (void) G_GNUC_CONST;
GType gitg_repository_list_box_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_MODE,
	GITG_REPOSITORY_LIST_BOX_HAS_SELECTION
};
static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event);
GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self);
void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value);
GType gitg_repository_list_box_row_get_type (void) G_GNUC_CONST;
void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value);
static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row);
gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self);
GType gitg_repository_get_type (void) G_GNUC_CONST;
GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before);
static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row);
const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self);
static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b);
GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error);
GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error);
GitgRepositoryListBoxRow* gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri);
static void gtk_recent_data_destroy (GtkRecentData* self);
void gitg_repository_list_box_end_cloning (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, GitgRepository* repository);
void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value);
void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value);
GitgRepositoryListBoxRow* gitg_repository_list_box_begin_cloning (GitgRepositoryListBox* self, const gchar* name);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (const gchar* name, const gchar* branch_name, gboolean has_remote);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, const gchar* name, const gchar* branch_name, gboolean has_remote);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
GitgParsedRefName* gitg_ref_get_parsed_name (GitgRef* self);
gchar* gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self);
gchar* gitg_repository_get_name (GitgRepository* self);
static gint ____lambda59_ (Block16Data* _data16_, GgitSubmodule* module);
void gitg_repository_list_box_row_add_submodule (GitgRepositoryListBoxRow* self, GgitSubmodule* module);
static gint _____lambda59__ggit_submodule_callback (GgitSubmodule* submodule, const gchar* name, gpointer self);
static void ____lambda60_ (GitgRepositoryListBox* self);
static void _____lambda60__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ____lambda61_ (Block16Data* _data16_);
static void _____lambda61__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self);
void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value);
void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value);
void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text);
GitgRepositoryListBox* gitg_repository_list_box_new (void);
GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type);
GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1);
static void _vala_array_add10 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value);
gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
GType gitg_progress_bin_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_ROW_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_MODE,
	GITG_REPOSITORY_LIST_BOX_ROW_SELECTED,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY,
	GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE,
	GITG_REPOSITORY_LIST_BOX_ROW_TIME,
	GITG_REPOSITORY_LIST_BOX_ROW_FRACTION,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_LOADING,
	GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE
};
GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value);
void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value);
gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value);
void gitg_progress_bin_set_fraction (GitgProgressBin* self, gdouble value);
void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value);
const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self);
gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self);
gboolean gitg_repository_list_box_row_get_has_remote (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_has_remote (GitgRepositoryListBoxRow* self, gboolean value);
static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gitg_repository_list_box_row_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gitg_repository_list_box_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType gitg_selection_mode_get_type (void) {
	static volatile gsize gitg_selection_mode_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_selection_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_SELECTION_MODE_NORMAL, "GITG_SELECTION_MODE_NORMAL", "normal"}, {GITG_SELECTION_MODE_SELECTION, "GITG_SELECTION_MODE_SELECTION", "selection"}, {0, NULL, NULL}};
		GType gitg_selection_mode_type_id;
		gitg_selection_mode_type_id = g_enum_register_static ("GitgSelectionMode", values);
		g_once_init_leave (&gitg_selection_mode_type_id__volatile, gitg_selection_mode_type_id);
	}
	return gitg_selection_mode_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 249 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_object_ref (self) : NULL;
#line 306 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GitgRepositoryListBox * self;
	gboolean result = FALSE;
	GdkEvent* ev = NULL;
	GdkEventButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GdkEvent* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GdkEventButton* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
#line 241 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 241 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 243 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = event;
#line 243 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	ev = (GdkEvent*) _tmp0_;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = ev;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gdk_event_triggers_context_menu (_tmp2_);
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp3_) {
#line 334 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp4_ = 0;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->_mode;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _tmp4_ == GITG_SELECTION_MODE_NORMAL;
#line 340 "gitg-repository-list-box.c"
	} else {
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = FALSE;
#line 344 "gitg-repository-list-box.c"
	}
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_) {
#line 348 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* row = NULL;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		GtkListBoxRow* _tmp7_ = NULL;
		GitgRepositoryListBoxRow* _tmp8_ = NULL;
		GitgRepositoryListBoxRow* _tmp9_ = NULL;
#line 247 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, GITG_SELECTION_MODE_SELECTION);
#line 249 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = event;
#line 249 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_->y;
#line 249 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = gtk_list_box_get_row_at_y ((GtkListBox*) self, (gint) _tmp6_);
#line 249 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW) ? ((GitgRepositoryListBoxRow*) _tmp7_) : NULL);
#line 249 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		row = _tmp8_;
#line 251 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = row;
#line 251 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp9_ != NULL) {
#line 371 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp10_ = NULL;
#line 253 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = row;
#line 253 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_selected (_tmp10_, TRUE);
#line 377 "gitg-repository-list-box.c"
		}
#line 256 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		result = TRUE;
#line 256 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (row);
#line 256 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return result;
#line 385 "gitg-repository-list-box.c"
	}
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp11_ = event;
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp12_ = GTK_WIDGET_CLASS (gitg_repository_list_box_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), _tmp11_);
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp12_;
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 395 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row) {
	GitgRepositoryListBox * self;
	GitgRepositoryListBoxRow* r = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgSelectionMode _tmp2_ = 0;
	GitgRepositoryListBoxRow* _tmp7_ = NULL;
	GitgRepository* _tmp8_ = NULL;
	GitgRepository* _tmp9_ = NULL;
#line 262 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 262 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 264 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = row;
#line 264 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 264 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	r = _tmp1_;
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->_mode;
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ == GITG_SELECTION_MODE_SELECTION) {
#line 422 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp3_ = NULL;
		GitgRepositoryListBoxRow* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = r;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = r;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (_tmp3_, !_tmp6_);
#line 269 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (r);
#line 269 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 441 "gitg-repository-list-box.c"
	}
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = r;
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = gitg_repository_list_box_row_get_repository (_tmp7_);
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = _tmp8_;
#line 272 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp9_ != NULL) {
#line 451 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp10_ = NULL;
		GitgRepository* _tmp11_ = NULL;
		GitgRepository* _tmp12_ = NULL;
#line 274 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = r;
#line 274 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = gitg_repository_list_box_row_get_repository (_tmp10_);
#line 274 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = _tmp11_;
#line 274 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "repository-activated", _tmp12_);
#line 463 "gitg-repository-list-box.c"
	}
#line 262 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (r);
#line 467 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before) {
	GtkSeparator* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
#line 290 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 290 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = before;
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 483 "gitg-repository-list-box.c"
		GtkSeparator* _tmp2_ = NULL;
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp2_);
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp2_;
#line 493 "gitg-repository-list-box.c"
	} else {
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = NULL;
#line 499 "gitg-repository-list-box.c"
	}
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = row;
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_row_set_header (_tmp3_, (GtkWidget*) _tmp0_);
#line 290 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp0_);
#line 507 "gitg-repository-list-box.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 527 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 295 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 295 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (row != NULL, FALSE);
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_filter_text;
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 543 "gitg-repository-list-box.c"
		GtkListBoxRow* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = row;
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = gitg_repository_list_box_row_get_repository_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_filter_text;
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = string_contains (_tmp4_, _tmp5_);
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp6_;
#line 561 "gitg-repository-list-box.c"
	} else {
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = TRUE;
#line 565 "gitg-repository-list-box.c"
	}
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 297 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 571 "gitg-repository-list-box.c"
}


static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	GDateTime* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 300 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 300 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 300 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = a;
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = b;
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_date_time_compare (_tmp2_, _tmp5_);
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = -_tmp6_;
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 608 "gitg-repository-list-box.c"
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? gtk_recent_info_ref (self) : NULL;
#line 615 "gitg-repository-list-box.c"
}


static void _gtk_recent_info_unref0_ (gpointer var) {
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
#line 622 "gitg-repository-list-box.c"
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_free (self);
#line 631 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GList* reversed_items = NULL;
	GtkRecentManager* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 305 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 307 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 307 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 307 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 308 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = recent_manager;
#line 308 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gtk_recent_manager_get_items (_tmp2_);
#line 308 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = _tmp3_;
#line 309 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = g_list_reverse (reversed_items);
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = reversed_items;
#line 662 "gitg-repository-list-box.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		item_collection = _tmp4_;
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 670 "gitg-repository-list-box.c"
			GtkRecentInfo* _tmp5_ = NULL;
			GtkRecentInfo* item = NULL;
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) item_it->data);
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			item = _tmp5_;
#line 677 "gitg-repository-list-box.c"
			{
				GtkRecentInfo* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 313 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = item;
#line 313 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = gtk_recent_info_has_group (_tmp6_, "gitg");
#line 313 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp7_) {
#line 687 "gitg-repository-list-box.c"
					GFile* info_file = NULL;
					GtkRecentInfo* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					GFile* _tmp10_ = NULL;
					GFile* repo_file = NULL;
					GitgRepository* repo = NULL;
					GitgRepository* _tmp25_ = NULL;
					GitgRepositoryListBoxRow* _tmp26_ = NULL;
					GitgRepositoryListBoxRow* _tmp27_ = NULL;
#line 315 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = item;
#line 315 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = gtk_recent_info_get_uri (_tmp8_);
#line 315 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp10_ = g_file_new_for_uri (_tmp9_);
#line 315 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					info_file = _tmp10_;
#line 705 "gitg-repository-list-box.c"
					{
						GFile* _tmp11_ = NULL;
						GFile* _tmp12_ = NULL;
						GFile* _tmp13_ = NULL;
						GFile* _tmp14_ = NULL;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp12_ = info_file;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp13_ = ggit_repository_discover (_tmp12_, &_inner_error_);
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = _tmp13_;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 719 "gitg-repository-list-box.c"
							goto __catch61_g_error;
						}
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp14_ = _tmp11_;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = NULL;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						repo_file = _tmp14_;
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (_tmp11_);
#line 732 "gitg-repository-list-box.c"
					}
					goto __finally61;
					__catch61_g_error:
					{
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_inner_error_ = NULL;
#line 741 "gitg-repository-list-box.c"
						{
							GtkRecentManager* _tmp15_ = NULL;
							GtkRecentInfo* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp15_ = recent_manager;
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp16_ = item;
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp17_ = gtk_recent_info_get_uri (_tmp16_);
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_recent_manager_remove_item (_tmp15_, _tmp17_, &_inner_error_);
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 756 "gitg-repository-list-box.c"
								goto __catch62_g_error;
							}
						}
						goto __finally62;
						__catch62_g_error:
						{
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_inner_error_ = NULL;
#line 767 "gitg-repository-list-box.c"
						}
						__finally62:
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo_file);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (info_file);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_gtk_recent_info_unref0 (item);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (recent_manager);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 324 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							return;
#line 788 "gitg-repository-list-box.c"
						}
#line 329 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 329 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 329 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 329 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 329 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 329 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 802 "gitg-repository-list-box.c"
					}
					__finally61:
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 823 "gitg-repository-list-box.c"
					}
					{
						GitgRepository* _tmp18_ = NULL;
						GFile* _tmp19_ = NULL;
						GitgRepository* _tmp20_ = NULL;
						GitgRepository* _tmp21_ = NULL;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp19_ = repo_file;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp20_ = gitg_repository_new (_tmp19_, NULL, &_inner_error_);
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp18_ = _tmp20_;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 838 "gitg-repository-list-box.c"
							goto __catch63_g_error;
						}
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp21_ = _tmp18_;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp18_ = NULL;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						repo = _tmp21_;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (_tmp18_);
#line 851 "gitg-repository-list-box.c"
					}
					goto __finally63;
					__catch63_g_error:
					{
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_inner_error_ = NULL;
#line 860 "gitg-repository-list-box.c"
						{
							GtkRecentManager* _tmp22_ = NULL;
							GtkRecentInfo* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
#line 342 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp22_ = recent_manager;
#line 342 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp23_ = item;
#line 342 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp24_ = gtk_recent_info_get_uri (_tmp23_);
#line 342 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_recent_manager_remove_item (_tmp22_, _tmp24_, &_inner_error_);
#line 342 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 875 "gitg-repository-list-box.c"
								goto __catch64_g_error;
							}
						}
						goto __finally64;
						__catch64_g_error:
						{
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_inner_error_ = NULL;
#line 886 "gitg-repository-list-box.c"
						}
						__finally64:
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo_file);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (info_file);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_gtk_recent_info_unref0 (item);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (recent_manager);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
							return;
#line 909 "gitg-repository-list-box.c"
						}
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 345 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 925 "gitg-repository-list-box.c"
					}
					__finally63:
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 948 "gitg-repository-list-box.c"
					}
#line 348 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp25_ = repo;
#line 348 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp26_ = gitg_repository_list_box_add_repository (self, _tmp25_);
#line 348 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp27_ = _tmp26_;
#line 348 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (_tmp27_);
#line 313 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo);
#line 313 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo_file);
#line 313 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (info_file);
#line 964 "gitg-repository-list-box.c"
				}
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_gtk_recent_info_unref0 (item);
#line 968 "gitg-repository-list-box.c"
			}
		}
	}
#line 305 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 305 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 976 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GList* _tmp0_ = NULL;
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 353 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 355 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	row = NULL;
#line 357 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 992 "gitg-repository-list-box.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 357 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		child_collection = _tmp0_;
#line 357 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1000 "gitg-repository-list-box.c"
			GtkWidget* child = NULL;
#line 357 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			child = (GtkWidget*) child_it->data;
#line 1004 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* d = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepository* _tmp4_ = NULL;
				GitgRepository* _tmp5_ = NULL;
				GFile* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
				GitgRepository* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				GFile* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = child;
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				d = _tmp2_;
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = d;
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_repository (_tmp3_);
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = _tmp6_;
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp8_ = repository;
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp9_ = ggit_repository_get_location ((GgitRepository*) _tmp8_);
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp10_ = _tmp9_;
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp11_ = g_file_equal (_tmp7_, _tmp10_);
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp12_ = _tmp11_;
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp10_);
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp7_);
#line 361 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp12_) {
#line 1051 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow* _tmp13_ = NULL;
					GitgRepositoryListBoxRow* _tmp14_ = NULL;
#line 363 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp13_ = d;
#line 363 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp14_ = _g_object_ref0 (_tmp13_);
#line 363 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (row);
#line 363 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					row = _tmp14_;
#line 364 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (d);
#line 364 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					break;
#line 1066 "gitg-repository-list-box.c"
				}
#line 357 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (d);
#line 1070 "gitg-repository-list-box.c"
			}
		}
#line 357 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (child_collection);
#line 1075 "gitg-repository-list-box.c"
	}
#line 368 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 368 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1081 "gitg-repository-list-box.c"
}


static void gtk_recent_data_destroy (GtkRecentData* self) {
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).display_name);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).description);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).mime_type);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_name);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_exec);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
#line 1098 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GtkRecentData item = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkRecentData _tmp10_ = {0};
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (uri != NULL);
#line 373 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 373 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 373 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	memset (&item, 0, sizeof (GtkRecentData));
#line 376 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_get_application_name ();
#line 376 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 376 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_name);
#line 376 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_name = _tmp3_;
#line 377 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_strdup ("inode/directory");
#line 377 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.mime_type);
#line 377 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.mime_type = _tmp4_;
#line 378 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = g_get_prgname ();
#line 378 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_strjoin (" ", _tmp5_, "%f", NULL);
#line 378 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_exec);
#line 378 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_exec = _tmp6_;
#line 379 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = g_strdup ("gitg");
#line 379 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = g_new0 (gchar*, 2 + 1);
#line 379 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[0] = _tmp7_;
#line 379 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[1] = NULL;
#line 379 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = (_vala_array_free (item.groups, _vala_array_length (item.groups), (GDestroyNotify) g_free), NULL);
#line 379 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = _tmp8_;
#line 381 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = uri;
#line 381 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = item;
#line 381 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_manager_add_full (recent_manager, _tmp9_, &_tmp10_);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_data_destroy (&item);
#line 371 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 1172 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_end_cloning (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, GitgRepository* repository) {
	GitgRepository* _tmp0_ = NULL;
#line 384 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 384 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 386 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 386 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != NULL) {
#line 1186 "gitg-repository-list-box.c"
		GFile* workdir = NULL;
		GitgRepository* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFile* repo_file = NULL;
		GitgRepository* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* uri = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GitgRepositoryListBoxRow* _tmp13_ = NULL;
		GitgRepository* _tmp14_ = NULL;
		GitgRepositoryListBoxRow* _tmp15_ = NULL;
#line 388 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = repository;
#line 388 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = ggit_repository_get_workdir ((GgitRepository*) _tmp1_);
#line 388 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		workdir = _tmp2_;
#line 389 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = repository;
#line 389 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = ggit_repository_get_location ((GgitRepository*) _tmp3_);
#line 389 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		repo_file = _tmp4_;
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = workdir;
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp6_ != NULL) {
#line 1217 "gitg-repository-list-box.c"
			GFile* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = workdir;
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = g_file_get_uri (_tmp7_);
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp5_);
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _tmp8_;
#line 1228 "gitg-repository-list-box.c"
		} else {
			GFile* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = repo_file;
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = g_file_get_uri (_tmp9_);
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp5_);
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _tmp10_;
#line 1240 "gitg-repository-list-box.c"
		}
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = g_strdup (_tmp5_);
#line 391 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		uri = _tmp11_;
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = uri;
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp12_);
#line 394 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = row;
#line 394 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = repository;
#line 394 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (_tmp13_, _tmp14_);
#line 395 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp15_ = row;
#line 395 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (_tmp15_, FALSE);
#line 386 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (uri);
#line 386 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp5_);
#line 386 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (repo_file);
#line 386 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (workdir);
#line 1268 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp16_ = NULL;
#line 399 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = row;
#line 399 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp16_);
#line 1275 "gitg-repository-list-box.c"
	}
}


GitgRepositoryListBoxRow* gitg_repository_list_box_begin_cloning (GitgRepositoryListBox* self, const gchar* name) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GitgRepositoryListBoxRow* _tmp2_ = NULL;
#line 403 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 403 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 405 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = name;
#line 405 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _ ("Cloning...");
#line 405 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = gitg_repository_list_box_row_new (_tmp0_, _tmp1_, TRUE);
#line 405 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp2_);
#line 405 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	row = _tmp2_;
#line 407 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_loading (row, TRUE);
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) row);
#line 410 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) row);
#line 411 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 411 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1310 "gitg-repository-list-box.c"
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return _data16_;
#line 1319 "gitg-repository-list-box.c"
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 1328 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data16_->self;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data16_->f);
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data16_->row);
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block16Data, _data16_);
#line 1340 "gitg-repository-list-box.c"
	}
}


static gint ____lambda59_ (Block16Data* _data16_, GgitSubmodule* module) {
	GitgRepositoryListBox* self;
	gint result = 0;
	GitgRepositoryListBoxRow* _tmp0_ = NULL;
	GgitSubmodule* _tmp1_ = NULL;
#line 443 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data16_->self;
#line 443 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (module != NULL, 0);
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = _data16_->row;
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = module;
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_add_submodule (_tmp0_, _tmp1_);
#line 445 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = 0;
#line 445 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1364 "gitg-repository-list-box.c"
}


static gint _____lambda59__ggit_submodule_callback (GgitSubmodule* submodule, const gchar* name, gpointer self) {
	gint result;
	result = ____lambda59_ (self, submodule);
#line 443 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1373 "gitg-repository-list-box.c"
}


static void ____lambda60_ (GitgRepositoryListBox* self) {
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject*) self, "has-selection");
#line 1380 "gitg-repository-list-box.c"
}


static void _____lambda60__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 459 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	____lambda60_ ((GitgRepositoryListBox*) self);
#line 1387 "gitg-repository-list-box.c"
}


static void ____lambda61_ (Block16Data* _data16_) {
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 463 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data16_->self;
#line 1397 "gitg-repository-list-box.c"
	{
		GtkRecentManager* recent_manager = NULL;
		GtkRecentManager* _tmp0_ = NULL;
		GtkRecentManager* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = gtk_recent_manager_get_default ();
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		recent_manager = _tmp1_;
#line 467 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _data16_->f;
#line 467 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = g_file_get_uri (_tmp2_);
#line 467 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 467 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_recent_manager_remove_item (recent_manager, _tmp4_, &_inner_error_);
#line 467 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp4_);
#line 467 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 467 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (recent_manager);
#line 1425 "gitg-repository-list-box.c"
			goto __catch67_g_error;
		}
#line 464 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (recent_manager);
#line 1430 "gitg-repository-list-box.c"
	}
	goto __finally67;
	__catch67_g_error:
	{
#line 464 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 464 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 1439 "gitg-repository-list-box.c"
	}
	__finally67:
#line 464 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 464 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 464 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 464 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 1450 "gitg-repository-list-box.c"
	}
#line 470 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _data16_->row;
#line 470 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp5_);
#line 1456 "gitg-repository-list-box.c"
}


static void _____lambda61__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self) {
#line 463 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	____lambda61_ (self);
#line 1463 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	Block16Data* _data16_;
	GitgRepository* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp14_ = NULL;
	GitgRepositoryListBoxRow* _tmp15_ = NULL;
	GFile* _tmp51_ = NULL;
	GitgRepositoryListBoxRow* _tmp55_ = NULL;
	GitgRepositoryListBoxRow* _tmp56_ = NULL;
	GError * _inner_error_ = NULL;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->_ref_count_ = 1;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->self = g_object_ref (self);
#line 416 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 416 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_get_row_for_repository (self, _tmp0_);
#line 416 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->row = _tmp1_;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = repository;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_get ((GgitRepository*) _tmp3_, "workdir", &_tmp4_, NULL);
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _tmp5_;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = _tmp6_ != NULL;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp6_);
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp7_) {
#line 1514 "gitg-repository-list-box.c"
		GitgRepository* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = repository;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp8_, "workdir", &_tmp9_, NULL);
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = _tmp9_;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp10_;
#line 1528 "gitg-repository-list-box.c"
	} else {
		GitgRepository* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = repository;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = ggit_repository_get_location ((GgitRepository*) _tmp11_);
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = _tmp12_;
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp13_;
#line 1543 "gitg-repository-list-box.c"
	}
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp14_ = _g_object_ref0 (_tmp2_);
#line 418 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->f = _tmp14_;
#line 420 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = _data16_->row;
#line 420 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp15_ == NULL) {
#line 1553 "gitg-repository-list-box.c"
		gchar* head_name = NULL;
		gchar* _tmp16_ = NULL;
		gboolean has_remote = FALSE;
		GitgRepository* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		GitgRepositoryListBoxRow* _tmp35_ = NULL;
		GitgRepositoryListBoxRow* _tmp36_ = NULL;
		GitgRepository* _tmp37_ = NULL;
		GitgRepositoryListBoxRow* _tmp38_ = NULL;
		GFile* _tmp40_ = NULL;
		GFile* _tmp42_ = NULL;
		GitgRepositoryListBoxRow* _tmp47_ = NULL;
#line 422 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = g_strdup ("");
#line 422 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		head_name = _tmp16_;
#line 423 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		has_remote = TRUE;
#line 1576 "gitg-repository-list-box.c"
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp17_ = NULL;
			GitgRef* _tmp18_ = NULL;
			GitgRef* _tmp19_ = NULL;
			GitgParsedRefName* _tmp20_ = NULL;
			GitgParsedRefName* _tmp21_ = NULL;
			GitgParsedRefName* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar** remotes = NULL;
			GitgRepository* _tmp25_ = NULL;
			gchar** _tmp26_ = NULL;
			gchar** _tmp27_ = NULL;
			gint remotes_length1 = 0;
			gint _remotes_size_ = 0;
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
#line 427 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp17_ = repository;
#line 427 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp18_ = gitg_repository_get_head (_tmp17_, &_inner_error_);
#line 427 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp18_;
#line 427 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1603 "gitg-repository-list-box.c"
				goto __catch65_g_error;
			}
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp19_ = head;
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp20_ = gitg_ref_get_parsed_name (_tmp19_);
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp21_ = _tmp20_;
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp22_ = _tmp21_;
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp23_ = gitg_parsed_ref_name_get_shortname (_tmp22_);
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp24_ = _tmp23_;
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			head_name = _tmp24_;
#line 428 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp22_);
#line 429 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp25_ = repository;
#line 429 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp27_ = _tmp26_ = ggit_repository_list_remotes ((GgitRepository*) _tmp25_, &_inner_error_);
#line 429 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			remotes = _tmp27_;
#line 429 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			remotes_length1 = _vala_array_length (_tmp26_);
#line 429 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_remotes_size_ = remotes_length1;
#line 429 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 429 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (head);
#line 1638 "gitg-repository-list-box.c"
				goto __catch65_g_error;
			}
#line 430 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp28_ = remotes;
#line 430 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp28__length1 = remotes_length1;
#line 430 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (_tmp28__length1 == 0) {
#line 432 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				has_remote = FALSE;
#line 1649 "gitg-repository-list-box.c"
			}
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			remotes = (_vala_array_free (remotes, remotes_length1, (GDestroyNotify) g_free), NULL);
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 1655 "gitg-repository-list-box.c"
		}
		goto __finally65;
		__catch65_g_error:
		{
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 1664 "gitg-repository-list-box.c"
		}
		__finally65:
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp2_);
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			block16_data_unref (_data16_);
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_data16_ = NULL;
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			return NULL;
#line 1683 "gitg-repository-list-box.c"
		}
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp29_ = repository;
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp30_ = gitg_repository_get_name (_tmp29_);
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp31_ = _tmp30_;
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp32_ = _tmp31_;
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp33_ = head_name;
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp34_ = has_remote;
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp35_ = gitg_repository_list_box_row_new (_tmp32_, _tmp33_, _tmp34_);
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp35_);
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data16_->row);
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_data16_->row = _tmp35_;
#line 437 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp32_);
#line 438 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp36_ = _data16_->row;
#line 438 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp37_ = repository;
#line 438 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (_tmp36_, _tmp37_);
#line 439 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp38_ = _data16_->row;
#line 439 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp38_);
#line 1717 "gitg-repository-list-box.c"
		{
			GitgRepository* _tmp39_ = NULL;
#line 443 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp39_ = repository;
#line 443 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			ggit_repository_submodule_foreach ((GgitRepository*) _tmp39_, _____lambda59__ggit_submodule_callback, _data16_, &_inner_error_);
#line 443 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1726 "gitg-repository-list-box.c"
				goto __catch66_g_error;
			}
		}
		goto __finally66;
		__catch66_g_error:
		{
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 1737 "gitg-repository-list-box.c"
		}
		__finally66:
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp2_);
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			block16_data_unref (_data16_);
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_data16_ = NULL;
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			return NULL;
#line 1756 "gitg-repository-list-box.c"
		}
#line 450 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp40_ = _data16_->f;
#line 450 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp40_ != NULL) {
#line 1762 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp41_ = NULL;
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp41_ = _data16_->row;
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_object_bind_property_with_closures ((GObject*) self, "mode", (GObject*) _tmp41_, "mode", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 1768 "gitg-repository-list-box.c"
		}
#line 457 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp42_ = _data16_->f;
#line 457 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp42_ != NULL) {
#line 1774 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp43_ = NULL;
			GitgRepositoryListBoxRow* _tmp44_ = NULL;
			GitgRepositoryListBoxRow* _tmp45_ = NULL;
#line 459 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp43_ = _data16_->row;
#line 459 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_signal_connect_object ((GObject*) _tmp43_, "notify::selected", (GCallback) _____lambda60__g_object_notify, self, 0);
#line 463 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp44_ = _data16_->row;
#line 463 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_signal_connect_data (_tmp44_, "request-remove", (GCallback) _____lambda61__gitg_repository_list_box_row_request_remove, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp45_ = _data16_->row;
#line 473 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp45_, TRUE);
#line 1790 "gitg-repository-list-box.c"
		} else {
			GitgRepositoryListBoxRow* _tmp46_ = NULL;
#line 477 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp46_ = _data16_->row;
#line 477 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp46_, FALSE);
#line 1797 "gitg-repository-list-box.c"
		}
#line 480 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp47_ = _data16_->row;
#line 480 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp47_);
#line 420 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (head_name);
#line 1805 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp48_ = NULL;
		GDateTime* _tmp49_ = NULL;
		GDateTime* _tmp50_ = NULL;
#line 485 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp48_ = _data16_->row;
#line 485 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp49_ = g_date_time_new_now_local ();
#line 485 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp50_ = _tmp49_;
#line 485 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (_tmp48_, _tmp50_);
#line 485 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_date_time_unref0 (_tmp50_);
#line 486 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_list_box_invalidate_sort ((GtkListBox*) self);
#line 1822 "gitg-repository-list-box.c"
	}
#line 489 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp51_ = _data16_->f;
#line 489 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp51_ != NULL) {
#line 1828 "gitg-repository-list-box.c"
		GFile* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp52_ = _data16_->f;
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp53_ = g_file_get_uri (_tmp52_);
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp54_ = _tmp53_;
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp54_);
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp54_);
#line 1842 "gitg-repository-list-box.c"
	}
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp55_ = _data16_->row;
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp56_ = _g_object_ref0 (_tmp55_);
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp56_;
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp2_);
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	block16_data_unref (_data16_);
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_ = NULL;
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1858 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 535 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = text;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_filter_text = _tmp1_;
#line 539 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
#line 1877 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type) {
	GitgRepositoryListBox * self = NULL;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) g_object_new (object_type, NULL);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 1887 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_new (void) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_construct (GITG_TYPE_REPOSITORY_LIST_BOX);
#line 1894 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_mode;
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1909 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_mode = _tmp0_;
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 1923 "gitg-repository-list-box.c"
}


static void _vala_array_add10 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value) {
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if ((*length) == (*size)) {
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		*array = g_renew (GitgRepositoryListBoxRow*, *array, (*size) + 1);
#line 1934 "gitg-repository-list-box.c"
	}
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[(*length)++] = value;
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[*length] = NULL;
#line 1940 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1) {
	GitgRepositoryListBoxRow** result;
	GitgRepositoryListBoxRow** ret = NULL;
	GitgRepositoryListBoxRow** _tmp0_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GList* _tmp1_ = NULL;
	GitgRepositoryListBoxRow** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
#line 499 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 501 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_new0 (GitgRepositoryListBoxRow*, 0 + 1);
#line 501 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	ret = _tmp0_;
#line 501 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	ret_length1 = 0;
#line 501 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_ret_size_ = ret_length1;
#line 503 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
#line 1965 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 503 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp1_;
#line 503 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 1973 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 503 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 1977 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepositoryListBoxRow* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
#line 505 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = row;
#line 505 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 505 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp3_;
#line 507 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = r;
#line 507 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 507 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = _tmp5_;
#line 507 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp6_) {
#line 1999 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					GitgRepositoryListBoxRow* _tmp8_ = NULL;
					GitgRepositoryListBoxRow* _tmp9_ = NULL;
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7_ = ret;
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7__length1 = ret_length1;
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = r;
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = _g_object_ref0 (_tmp8_);
#line 509 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_vala_array_add10 (&ret, &ret_length1, &_ret_size_, _tmp9_);
#line 2014 "gitg-repository-list-box.c"
				}
#line 503 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 2018 "gitg-repository-list-box.c"
			}
		}
#line 503 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 2023 "gitg-repository-list-box.c"
	}
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = ret;
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10__length1 = ret_length1;
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (result_length1) {
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		*result_length1 = _tmp10__length1;
#line 2033 "gitg-repository-list-box.c"
	}
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp10_;
#line 513 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2039 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self) {
	gboolean result;
	GList* _tmp0_ = NULL;
#line 519 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 521 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 2050 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 521 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp0_;
#line 521 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 2058 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 521 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 2062 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
#line 523 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = row;
#line 523 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 523 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp2_;
#line 525 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = r;
#line 525 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_selected (_tmp3_);
#line 525 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 525 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp5_) {
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					result = TRUE;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (r);
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					_g_list_free0 (row_collection);
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
					return result;
#line 2092 "gitg-repository-list-box.c"
				}
#line 521 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 2096 "gitg-repository-list-box.c"
			}
		}
#line 521 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 2101 "gitg-repository-list-box.c"
	}
#line 531 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = FALSE;
#line 531 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2107 "gitg-repository-list-box.c"
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (n_param_values == 3);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = closure->data;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = param_values->data[0].v_pointer;
#line 2126 "gitg-repository-list-box.c"
	} else {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = param_values->data[0].v_pointer;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = closure->data;
#line 2132 "gitg-repository-list-box.c"
	}
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 2138 "gitg-repository-list-box.c"
}


static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
#line 280 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_update_header ((GitgRepositoryListBox*) self, row, before);
#line 2145 "gitg-repository-list-box.c"
}


static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = gitg_repository_list_box_filter ((GitgRepositoryListBox*) self, row);
#line 281 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2154 "gitg-repository-list-box.c"
}


static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = gitg_repository_list_box_compare_widgets ((GitgRepositoryListBox*) self, row1, row2);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2163 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBox * self;
#line 278 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_parent_class);
#line 278 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 278 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 280 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_header_func ((GtkListBox*) self, _gitg_repository_list_box_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
#line 281 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_filter_func ((GtkListBox*) self, _gitg_repository_list_box_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
#line 282 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_sort_func ((GtkListBox*) self, _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
#line 283 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 285 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_NONE);
#line 287 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_add_recent_info (self);
#line 278 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 2191 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, const gchar* name, const gchar* branch_name, gboolean has_remote) {
	GitgRepositoryListBoxRow * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (branch_name != NULL, NULL);
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = name;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = branch_name;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = has_remote;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxRow*) g_object_new (object_type, "repository-name", _tmp0_, "branch-name", _tmp1_, "has-remote", _tmp2_, NULL);
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 2214 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (const gchar* name, const gchar* branch_name, gboolean has_remote) {
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_row_construct (GITG_REPOSITORY_LIST_BOX_TYPE_ROW, name, branch_name, has_remote);
#line 2221 "gitg-repository-list-box.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1314 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1315 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	result = self;
#line 1315 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 2233 "gitg-repository-list-box.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 2266 "gitg-repository-list-box.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 2275 "gitg-repository-list-box.c"
	}
#line 1235 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 2281 "gitg-repository-list-box.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 2290 "gitg-repository-list-box.c"
	}
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 2296 "gitg-repository-list-box.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 2305 "gitg-repository-list-box.c"
	} else {
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 2309 "gitg-repository-list-box.c"
	}
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 2317 "gitg-repository-list-box.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 2326 "gitg-repository-list-box.c"
	} else {
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 2330 "gitg-repository-list-box.c"
	}
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 2352 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_add_submodule (GitgRepositoryListBoxRow* self, GgitSubmodule* module) {
	gchar* submodule_url = NULL;
	GgitSubmodule* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp4_ = NULL;
	gchar* tip = NULL;
	GgitSubmodule* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkImage* icon = NULL;
	GtkImage* _tmp14_ = NULL;
	GtkImage* _tmp15_ = NULL;
	gchar* name = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GtkLabel* labelName = NULL;
	const gchar* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkArrow* arrow = NULL;
	GtkArrow* _tmp25_ = NULL;
	GtkArrow* _tmp26_ = NULL;
	gchar* path = NULL;
	GgitSubmodule* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GtkLabel* labelPath = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkImage* _tmp39_ = NULL;
	GtkBox* _tmp40_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	GtkBox* _tmp42_ = NULL;
	GtkArrow* _tmp43_ = NULL;
	GtkBox* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkBox* _tmp47_ = NULL;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (module != NULL);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = module;
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = ggit_submodule_get_url (_tmp0_);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	submodule_url = _tmp2_;
#line 197 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = submodule_url;
#line 197 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp3_ == NULL) {
#line 199 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (submodule_url);
#line 199 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 2432 "gitg-repository-list-box.c"
	}
#line 202 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
#line 202 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp4_);
#line 202 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	box = _tmp4_;
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = module;
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = ggit_submodule_get_path (_tmp5_);
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = string_to_string (_tmp6_);
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = submodule_url;
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = string_to_string (_tmp8_);
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = g_strconcat (_tmp7_, "/ (", _tmp9_, ")", NULL);
#line 203 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	tip = _tmp10_;
#line 205 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp11_ = box;
#line 205 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp12_ = tip;
#line 205 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp12_);
#line 206 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp13_ = box;
#line 206 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp13_);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp14_ = (GtkImage*) gtk_image_new_from_icon_name ("folder-remote-symbolic", GTK_ICON_SIZE_MENU);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp14_);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	icon = _tmp14_;
#line 210 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = icon;
#line 210 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp15_);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp16_ = submodule_url;
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17_ = g_path_get_basename (_tmp16_);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	name = _tmp17_;
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp18_ = name;
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp19_ = g_str_has_suffix (_tmp18_, ".git");
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp19_) {
#line 2486 "gitg-repository-list-box.c"
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp20_ = name;
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp21_ = string_slice (_tmp20_, (glong) 0, (glong) (-4));
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (name);
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		name = _tmp21_;
#line 2497 "gitg-repository-list-box.c"
	}
#line 219 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp22_ = name;
#line 219 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp23_ = (GtkLabel*) gtk_label_new (_tmp22_);
#line 219 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp23_);
#line 219 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	labelName = _tmp23_;
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp24_ = labelName;
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp24_);
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp25_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_RIGHT, GTK_SHADOW_NONE);
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp25_);
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	arrow = _tmp25_;
#line 223 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp26_ = arrow;
#line 223 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp26_);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp27_ = module;
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp28_ = ggit_submodule_get_path (_tmp27_);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp29_ = g_strdup (_tmp28_);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	path = _tmp29_;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp30_ = path;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp31_ = string_to_string (_tmp30_);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp32_ = g_strconcat (_tmp31_, "/", NULL);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp33_ = _tmp32_;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp34_ = (GtkLabel*) gtk_label_new (_tmp33_);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp34_);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp35_ = _tmp34_;
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp33_);
#line 226 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	labelPath = _tmp35_;
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp36_ = labelPath;
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_ellipsize (_tmp36_, PANGO_ELLIPSIZE_MIDDLE);
#line 228 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp37_ = labelPath;
#line 228 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp37_);
#line 230 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp38_ = box;
#line 230 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp39_ = icon;
#line 230 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
#line 231 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp40_ = box;
#line 231 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp41_ = labelName;
#line 231 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
#line 232 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp42_ = box;
#line 232 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp43_ = arrow;
#line 232 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp44_ = box;
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp45_ = labelPath;
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
#line 235 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp46_ = self->priv->d_submodule_box;
#line 235 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp47_ = box;
#line 235 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (labelPath);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (path);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (arrow);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (labelName);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (name);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (icon);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (tip);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (box);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (submodule_url);
#line 2603 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2618 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
	GitgSelectionMode _tmp1_ = 0;
#line 76 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 78 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 78 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != _tmp1_) {
#line 2633 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp2_ = 0;
		GtkRevealer* _tmp3_ = NULL;
		GitgSelectionMode _tmp4_ = 0;
		GtkCheckButton* _tmp5_ = NULL;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = value;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		self->priv->d_mode = _tmp2_;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_remove_revealer;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_mode;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_revealer_set_reveal_child (_tmp3_, _tmp4_ == GITG_SELECTION_MODE_SELECTION);
#line 84 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_remove_check_button;
#line 84 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, FALSE);
#line 2652 "gitg-repository-list-box.c"
	}
#line 76 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 2656 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_selected;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2671 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_selected = _tmp0_;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "selected");
#line 2685 "gitg-repository-list-box.c"
}


GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository;
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2700 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 106 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 108 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 108 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 108 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_repository = _tmp1_;
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_branch_name (self, "");
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_repository;
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ != NULL) {
#line 2725 "gitg-repository-list-box.c"
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp3_ = NULL;
			GitgRef* _tmp4_ = NULL;
			GitgRef* _tmp5_ = NULL;
			GitgParsedRefName* _tmp6_ = NULL;
			GitgParsedRefName* _tmp7_ = NULL;
			GitgParsedRefName* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp3_ = self->priv->d_repository;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp4_ = gitg_repository_get_head (_tmp3_, &_inner_error_);
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp4_;
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2745 "gitg-repository-list-box.c"
				goto __catch68_g_error;
			}
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = head;
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp6_ = gitg_ref_get_parsed_name (_tmp5_);
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp6_;
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = _tmp7_;
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = gitg_parsed_ref_name_get_shortname (_tmp8_);
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = _tmp9_;
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = _tmp10_;
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_branch_name (self, _tmp11_);
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp11_);
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp8_);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 2770 "gitg-repository-list-box.c"
		}
		goto __finally68;
		__catch68_g_error:
		{
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 2779 "gitg-repository-list-box.c"
		}
		__finally68:
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
			return;
#line 2790 "gitg-repository-list-box.c"
		}
	}
#line 106 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository");
#line 2795 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self) {
	gboolean result;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp2_;
#line 126 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2816 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_);
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "can-remove");
#line 2833 "gitg-repository-list-box.c"
}


GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_time;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2848 "gitg-repository-list-box.c"
}


static gpointer _g_date_time_ref0 (gpointer self) {
#line 133 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 2855 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 133 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 133 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 133 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 133 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_time = _tmp1_;
#line 133 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "time");
#line 2874 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value) {
	GitgProgressBin* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 139 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 139 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_progress_bin;
#line 139 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 139 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_progress_bin_set_fraction (_tmp0_, _tmp1_);
#line 139 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "fraction");
#line 2891 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_label_get_text (_tmp0_);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp1_;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2909 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 145 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 145 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 145 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 145 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_strdup_printf ("<b>%s</b>", _tmp1_);
#line 145 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = _tmp2_;
#line 145 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_markup (_tmp0_, _tmp3_);
#line 145 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp3_);
#line 145 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository-name");
#line 2934 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_branch_label;
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_label_get_text (_tmp0_);
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp1_;
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2952 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_branch_label;
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_strdup_printf ("<small>%s</small>", _tmp1_);
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = _tmp2_;
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_markup (_tmp0_, _tmp3_);
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp3_);
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "branch-name");
#line 2977 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 156 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 156 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_loading;
#line 156 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 156 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2992 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 157 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 159 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_loading = _tmp0_;
#line 161 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_loading;
#line 161 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (!_tmp1_) {
#line 3009 "gitg-repository-list-box.c"
		GtkSpinner* _tmp2_ = NULL;
		GtkSpinner* _tmp3_ = NULL;
		GtkArrow* _tmp4_ = NULL;
		GitgProgressBin* _tmp5_ = NULL;
#line 163 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = self->priv->d_spinner;
#line 163 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_stop (_tmp2_);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_spinner;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 165 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_arrow;
#line 165 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp4_);
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_progress_bin;
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_progress_bin_set_fraction (_tmp5_, (gdouble) 0);
#line 3030 "gitg-repository-list-box.c"
	} else {
		GtkArrow* _tmp6_ = NULL;
		GtkSpinner* _tmp7_ = NULL;
		GtkSpinner* _tmp8_ = NULL;
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = self->priv->d_arrow;
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 171 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = self->priv->d_spinner;
#line 171 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp7_);
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = self->priv->d_spinner;
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_start (_tmp8_);
#line 3047 "gitg-repository-list-box.c"
	}
#line 157 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "loading");
#line 3051 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_has_remote (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_has_remote;
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3066 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_has_remote (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* folder_icon_name = NULL;
	gchar* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	GtkIconSize _tmp5_ = 0;
#line 180 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_has_remote = _tmp0_;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_has_remote;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_) {
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = "folder-remote";
#line 3090 "gitg-repository-list-box.c"
	} else {
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = "folder";
#line 3094 "gitg-repository-list-box.c"
	}
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = g_strdup (_tmp1_);
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	folder_icon_name = _tmp3_;
#line 185 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = self->priv->d_image;
#line 185 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = gitg_repository_list_box_row_s_icon_size;
#line 185 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_image_set_from_icon_name (_tmp4_, folder_icon_name, _tmp5_);
#line 180 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (folder_icon_name);
#line 180 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "has-remote");
#line 3110 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBoxRow * self;
	GtkCheckButton* _tmp0_ = NULL;
#line 94 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class);
#line 94 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 94 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 96 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 96 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "active", (GObject*) self, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 94 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 3131 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_class_init (GitgRepositoryListBoxRowClass * klass) {
	gint GitgRepositoryListBoxRow_private_offset;
	GtkIconSize _tmp0_ = 0;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxRowPrivate));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_row_get_property;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_row_set_property;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_row_constructor;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_row_finalize;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE, g_param_spec_boolean ("can-remove", "can-remove", "can-remove", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_TIME, g_param_spec_boxed ("time", "time", "time", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_FRACTION, g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME, g_param_spec_string ("repository-name", "repository-name", "repository-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME, g_param_spec_string ("branch-name", "branch-name", "branch-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_LOADING, g_param_spec_boolean ("loading", "loading", "loading", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE, g_param_spec_boolean ("has-remote", "has-remote", "has-remote", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	GitgRepositoryListBoxRow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-repository-list-box-row.ui");
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("request_remove", GITG_REPOSITORY_LIST_BOX_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_progress_bin", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_progress_bin));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_image", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_image));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_repository_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_repository_label));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_branch_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_branch_label));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_arrow", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_arrow));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_spinner", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_spinner));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_check_button", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_check_button));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_revealer", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_revealer));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_submodule_box", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_submodule_box));
#line 69 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_icon_size_register ("gitg", 64, 64);
#line 69 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_s_icon_size = _tmp0_;
#line 3198 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_instance_init (GitgRepositoryListBoxRow * self) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE (self);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_date_time_new_now_local ();
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _tmp0_;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_time (self, _tmp1_);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_ensure (GITG_TYPE_PROGRESS_BIN);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3217 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_finalize (GObject* obj) {
	GitgRepositoryListBoxRow * self;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 38 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 43 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_progress_bin);
#line 45 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_image);
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository_label);
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_branch_label);
#line 51 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_arrow);
#line 53 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_spinner);
#line 55 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_check_button);
#line 57 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_revealer);
#line 59 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_submodule_box);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class)->finalize (obj);
#line 3249 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_row_get_type (void) {
	static volatile gsize gitg_repository_list_box_row_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBoxRow), 0, (GInstanceInitFunc) gitg_repository_list_box_row_instance_init, NULL };
		GType gitg_repository_list_box_row_type_id;
		gitg_repository_list_box_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgRepositoryListBoxRow", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_row_type_id__volatile, gitg_repository_list_box_row_type_id);
	}
	return gitg_repository_list_box_row_type_id__volatile;
}


static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_row_get_mode (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_selected (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_object (value, gitg_repository_list_box_row_get_repository (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_can_remove (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boxed (value, gitg_repository_list_box_row_get_time (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_repository_name (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_branch_name (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_loading (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_has_remote (self));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3324 "gitg-repository-list-box.c"
		default:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3330 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_mode (self, g_value_get_enum (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (self, g_value_get_boolean (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (self, g_value_get_object (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_can_remove (self, g_value_get_boolean (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (self, g_value_get_boxed (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_FRACTION:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_fraction (self, g_value_get_double (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository_name (self, g_value_get_string (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_branch_name (self, g_value_get_string (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (self, g_value_get_boolean (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_has_remote (self, g_value_get_boolean (value));
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3400 "gitg-repository-list-box.c"
		default:
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3406 "gitg-repository-list-box.c"
	}
}


static void gitg_repository_list_box_class_init (GitgRepositoryListBoxClass * klass) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxPrivate));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkWidgetClass *) klass)->button_press_event = gitg_repository_list_box_real_button_press_event;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkListBoxClass *) klass)->row_activated = gitg_repository_list_box_real_row_activated;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_get_property;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_set_property;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_constructor;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_finalize;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_HAS_SELECTION, g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("repository_activated", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_TYPE_REPOSITORY);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("show_error", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
#line 3436 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_instance_init (GitgRepositoryListBox * self) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_GET_PRIVATE (self);
#line 3443 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_finalize (GObject* obj) {
	GitgRepositoryListBox * self;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 30 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_parent_class)->finalize (obj);
#line 3455 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_get_type (void) {
	static volatile gsize gitg_repository_list_box_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBox), 0, (GInstanceInitFunc) gitg_repository_list_box_instance_init, NULL };
		GType gitg_repository_list_box_type_id;
		gitg_repository_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "GitgRepositoryListBox", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_type_id__volatile, gitg_repository_list_box_type_id);
	}
	return gitg_repository_list_box_type_id__volatile;
}


static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_get_mode (self));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_HAS_SELECTION:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_get_has_selection (self));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3488 "gitg-repository-list-box.c"
		default:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3494 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, g_value_get_enum (value));
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3510 "gitg-repository-list-box.c"
		default:
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3516 "gitg-repository-list-box.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



