!! NOTES
!!  This file has been automatically generated by the @SCRIPT@
!!  script. Any change you would bring to it will systematically be
!!  overwritten. See the template file in config/etsf/template.utils_check.

!!****m* etsf_io_file/etsf_io_file_check_scalar_field_data
!! NAME
!!  etsf_io_file_check_scalar_field_data
!!
!! FUNCTION
!!  This is a high level routine to inquire a file about a specifications.
!!  It returns .true. in lstat if the file is a valid 'scalar_field_data' file.
!!  It tests the existence of variables and their definition (type, shape.
!!  and dimension names).
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     an identificator of an opened ETSF file (use etsf_io_low_open_read()
!!     for instance).
!! OUTPUT
!! * lstat = 
!!     return .true. if the file matches requirement of 'scalar_field_data'.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! SOURCE
subroutine etsf_io_file_check_scalar_field_data(ncid, lstat, error_data)
  integer, intent(in)                  :: ncid
  logical, intent(out)                 :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  character(len = *), parameter        :: me = "etsf_io_file_check_scalar_field_data"
  type(etsf_io_low_var_infos)          :: var_infos
  logical                              :: valid
  character(len = etsf_charlen)        :: string_value
  type(etsf_dims)                      :: dims
  type(etsf_split)                     :: split

  ! Read the dimensions
  call etsf_io_dims_get(ncid, dims, lstat, error_data)
  if (.not. lstat) then
     call etsf_io_low_error_update(error_data, me)
     return
  end if

  ! Allocate the split and read it (this will verify variable exist.
  call etsf_io_split_allocate(split, dims)
  call etsf_io_split_get(ncid, split, lstat, error_data)
  if (.not. lstat) then
     call etsf_io_low_error_update(error_data, me)
     return
  end if

  ! Variable primitive_vectors
  write(var_infos%name, "(A)") "primitive_vectors"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 2
  allocate(var_infos%ncdimnames(2))
  write(var_infos%ncdimnames(2), "(A)") "number_of_vectors"
  write(var_infos%ncdimnames(1), "(A)") "number_of_cartesian_directions"
  call test_var(ncid, var_infos, lstat, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. lstat) then
    call etsf_io_split_free(split)
    call etsf_io_low_error_update(error_data, me)
    return
  end if
  
  ! Check from a list.
  lstat = .false.
  ! Variable density
  write(var_infos%name, "(A)") "density"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 5
  allocate(var_infos%ncdimnames(5))
  if (associated(split%my_components)) then
    write(var_infos%ncdimnames(5), "(A)") "my_number_of_components"
  else
    write(var_infos%ncdimnames(5), "(A)") "number_of_components"
  end if
  if (associated(split%my_grid_points_vector3)) then
    write(var_infos%ncdimnames(4), "(A)") "my_number_of_grid_points_vect3"
  else
    write(var_infos%ncdimnames(4), "(A)") "number_of_grid_points_vector3"
  end if
  if (associated(split%my_grid_points_vector2)) then
    write(var_infos%ncdimnames(3), "(A)") "my_number_of_grid_points_vect2"
  else
    write(var_infos%ncdimnames(3), "(A)") "number_of_grid_points_vector2"
  end if
  if (associated(split%my_grid_points_vector1)) then
    write(var_infos%ncdimnames(2), "(A)") "my_number_of_grid_points_vect1"
  else
    write(var_infos%ncdimnames(2), "(A)") "number_of_grid_points_vector1"
  end if
  write(var_infos%ncdimnames(1), "(A)") "real_or_complex_density"
  call test_var(ncid, var_infos, valid, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. valid .and. error_data%access_mode_id == ERROR_MODE_SPEC) return
  lstat = lstat .or. valid
  ! Variable correlation_potential
  write(var_infos%name, "(A)") "correlation_potential"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 5
  allocate(var_infos%ncdimnames(5))
  if (associated(split%my_components)) then
    write(var_infos%ncdimnames(5), "(A)") "my_number_of_components"
  else
    write(var_infos%ncdimnames(5), "(A)") "number_of_components"
  end if
  if (associated(split%my_grid_points_vector3)) then
    write(var_infos%ncdimnames(4), "(A)") "my_number_of_grid_points_vect3"
  else
    write(var_infos%ncdimnames(4), "(A)") "number_of_grid_points_vector3"
  end if
  if (associated(split%my_grid_points_vector2)) then
    write(var_infos%ncdimnames(3), "(A)") "my_number_of_grid_points_vect2"
  else
    write(var_infos%ncdimnames(3), "(A)") "number_of_grid_points_vector2"
  end if
  if (associated(split%my_grid_points_vector1)) then
    write(var_infos%ncdimnames(2), "(A)") "my_number_of_grid_points_vect1"
  else
    write(var_infos%ncdimnames(2), "(A)") "number_of_grid_points_vector1"
  end if
  write(var_infos%ncdimnames(1), "(A)") "real_or_complex_potential"
  call test_var(ncid, var_infos, valid, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. valid .and. error_data%access_mode_id == ERROR_MODE_SPEC) return
  lstat = lstat .or. valid
  ! Variable exchange_potential
  write(var_infos%name, "(A)") "exchange_potential"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 5
  allocate(var_infos%ncdimnames(5))
  if (associated(split%my_components)) then
    write(var_infos%ncdimnames(5), "(A)") "my_number_of_components"
  else
    write(var_infos%ncdimnames(5), "(A)") "number_of_components"
  end if
  if (associated(split%my_grid_points_vector3)) then
    write(var_infos%ncdimnames(4), "(A)") "my_number_of_grid_points_vect3"
  else
    write(var_infos%ncdimnames(4), "(A)") "number_of_grid_points_vector3"
  end if
  if (associated(split%my_grid_points_vector2)) then
    write(var_infos%ncdimnames(3), "(A)") "my_number_of_grid_points_vect2"
  else
    write(var_infos%ncdimnames(3), "(A)") "number_of_grid_points_vector2"
  end if
  if (associated(split%my_grid_points_vector1)) then
    write(var_infos%ncdimnames(2), "(A)") "my_number_of_grid_points_vect1"
  else
    write(var_infos%ncdimnames(2), "(A)") "number_of_grid_points_vector1"
  end if
  write(var_infos%ncdimnames(1), "(A)") "real_or_complex_potential"
  call test_var(ncid, var_infos, valid, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. valid .and. error_data%access_mode_id == ERROR_MODE_SPEC) return
  lstat = lstat .or. valid
  ! Variable exchange_correlation_potential
  write(var_infos%name, "(A)") "exchange_correlation_potential"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 5
  allocate(var_infos%ncdimnames(5))
  if (associated(split%my_components)) then
    write(var_infos%ncdimnames(5), "(A)") "my_number_of_components"
  else
    write(var_infos%ncdimnames(5), "(A)") "number_of_components"
  end if
  if (associated(split%my_grid_points_vector3)) then
    write(var_infos%ncdimnames(4), "(A)") "my_number_of_grid_points_vect3"
  else
    write(var_infos%ncdimnames(4), "(A)") "number_of_grid_points_vector3"
  end if
  if (associated(split%my_grid_points_vector2)) then
    write(var_infos%ncdimnames(3), "(A)") "my_number_of_grid_points_vect2"
  else
    write(var_infos%ncdimnames(3), "(A)") "number_of_grid_points_vector2"
  end if
  if (associated(split%my_grid_points_vector1)) then
    write(var_infos%ncdimnames(2), "(A)") "my_number_of_grid_points_vect1"
  else
    write(var_infos%ncdimnames(2), "(A)") "number_of_grid_points_vector1"
  end if
  write(var_infos%ncdimnames(1), "(A)") "real_or_complex_potential"
  call test_var(ncid, var_infos, valid, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. valid .and. error_data%access_mode_id == ERROR_MODE_SPEC) return
  lstat = lstat .or. valid
  if (.not. lstat) then
    call etsf_io_split_free(split)
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
                             & ERROR_TYPE_ARG, me, &
   & tgtname = "density, correlation_potential, exchange_potential, exchange_correlation_p...", &
                             & errmess = "missing one among the list.")
    return
  end if
  


  ! Deallocate the split data.
  call etsf_io_split_free(split)

  lstat = .true.
end subroutine etsf_io_file_check_scalar_field_data
!!***


