/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef _CURVE
#define _CURVE

#include <list>
#include <vector>
#include "crvpt.h"
#include "point.h"

struct curve {

  float x[2], y[2]; // start/end points
  float tx[2], ty[2]; // start/end tangents

  std::list <crvpt> lpts; // for generation (faster bcos recursive subdivision inserts points)
  std::vector<crvpt> vpts; // for draw & solve (faster bcos no inserts after generation)

  curve ();
  curve (float x1, float y1, float x2, float y2, float tx1, float ty1, float tx2, float ty2, float d = 1);
  curve (const curve& c);
  curve& operator= (const curve& c);
  void copy (const curve& c);
		
	/*
	 * din generates points on the bezier curve using recursive subdivision:
	 * 
	 * find midpoint of line joining end points
	 * if distance between midpoint on this line and point on the bezier curve > limit 
	 * insert point and repeat else stop
	*/ 
	
  float limit2; // square of limit distance
  void set_limit (float l);

	// evaluation means generation of points of the curve
  enum {EVAL_REQUIRED, EVAL_COMPLETE};
  int eval_state;

  void eval ();

  inline void tangent (int i, float xt, float yt) {
    tx[i] = xt;
    ty[i] = yt;
    eval_state = EVAL_REQUIRED;
  }

  inline void get_tangent (int i, float& xt, float& yt) {
    xt = tx[i];
    yt = ty[i];
  }

  inline void vertex (int i, float xv, float yv) {
    x[i] = xv;
    y[i] = yv;
    eval_state = EVAL_REQUIRED;
  }

  inline void get_vertex (int i, float& xv, float& yv) {
    xv = x[i];
    yv = y[i];
  }

  inline int eval_required () {
    return (eval_state == EVAL_REQUIRED);
  }

};

#endif


