![DataLab](https://raw.githubusercontent.com/DataLab-Platform/DataLab/main/doc/images/DataLab-banner.png)

[![license](https://img.shields.io/pypi/l/cdl.svg)](./LICENSE)
[![pypi version](https://img.shields.io/pypi/v/cdl.svg)](https://pypi.org/project/CDL/)
[![PyPI status](https://img.shields.io/pypi/status/cdl.svg)](https://github.com/DataLab-Platform/DataLab)
[![PyPI pyversions](https://img.shields.io/pypi/pyversions/cdl.svg)](https://pypi.python.org/pypi/CDL/)

DataLab is an **open-source platform for scientific and technical data processing
and visualization** with unique features designed to meet industrial requirements.

See [DataLab website](https://datalab-platform.com/) for more details.

ℹ️ Created by [Codra](https://codra.net/)/[Pierre Raybaut](https://github.com/PierreRaybaut) in 2023, developed and maintained by DataLab Platform Developers.

![DataLab](https://raw.githubusercontent.com/DataLab-Platform/DataLab/main/doc/images/DataLab-Screenshot.png)

ℹ️ DataLab is powered by [PlotPyStack](https://github.com/PlotPyStack) 🚀.

![PlotPyStack](https://raw.githubusercontent.com/PlotPyStack/.github/main/data/plotpy-stack-powered.png)

ℹ️ DataLab is built on Python and scientific libraries.

![Python](https://raw.githubusercontent.com/DataLab-Platform/DataLab/main/doc/images/logos/Python.png) ![NumPy](https://raw.githubusercontent.com/DataLab-Platform/DataLab/main/doc/images/logos/NumPy.png) ![SciPy](https://raw.githubusercontent.com/DataLab-Platform/DataLab/main/doc/images/logos/SciPy.png) ![scikit-image](https://raw.githubusercontent.com/DataLab-Platform/DataLab/main/doc/images/logos/scikit-image.png) ![OpenCV](https://raw.githubusercontent.com/DataLab-Platform/DataLab/main/doc/images/logos/OpenCV.png) ![PlotPyStack](https://raw.githubusercontent.com/DataLab-Platform/DataLab/main/doc/images/logos/plotpystack.png)

----

Try DataLab online, without installing anything, using Binder:

[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/DataLab-Platform/DataLab/binder-environments?urlpath=git-pull%3Frepo%3Dhttps%253A%252F%252Fgithub.com%252FDataLab-Platform%252FDataLab%26urlpath%3Ddesktop%252F%26branch%3Dbinder-environments)

----

✨ Add features to DataLab by writing your own [plugin](https://datalab-platform.com/en/features/general/plugins.html)
(see [plugin examples](https://github.com/DataLab-Platform/DataLab/tree/main/plugins/examples))
or macro (see [macro examples](https://github.com/DataLab-Platform/DataLab/tree/main/macros/examples))

✨ DataLab may be remotely controlled from a third-party application (such as Jupyter,
Spyder or any IDE):

* Using the integrated [remote control](https://datalab-platform.com/en/features/general/remote.html)
feature (this requires to install DataLab as a Python package)

* Using the lightweight [DataLab Simple Client](https://github.com/DataLab-Platform/DataLabSimpleClient) (`pip install cdlclient`)
