% LAdump(1) 1.0+20151214
%
% January 2016

# NAME

LAdump - display daligner local alignments in a simple format

# SYNOPSIS

**LAdump** [**-cdt**] [**-o**] *src1:db|dam* [ *src2:db|dam* ]
                      *align:las* [ *reads:FILE* | *reads:range* ... ]

# DESCRIPTION

Like **LAshow**(1), **LAdump** allows one to display the local alignments (LAs) of a subset of the
piles in an .las file and select which information to show about them.  The difference
is that the information is written in a very simple "1-code" ASCII format that makes it
easy for one to read and parse the information for further use.  For each LA the pair of
reads is output on a line.  **-c** requests that one further output the coordinates of the
LA segments be output.  The **-d** option requests that the number of difference in the LA
be output, and **-t** requests that the tracepoint information be output.  Finally, **-o**
requests that only LAs that are proper overlaps be output. 

The format is very simple.  Each requested piece of information occurs on a line.  The
first character of every line is a "1-code" character that tells you what information
to expect on the line.  The rest of the line contains information where each item is
separated by a single blank space.  The trace point line gives the number of trace
point intervals in the LA and is immediately followed by that many lines containing
a pair of integers giving the # of differences and b-displacement in each successive
trace point interval.

    P #a #b           - (#a,#b) have an LA between them
    C #ab #ae #bb #be - [#ab,#ae] aligns with [#bb,#be]
    D #               - there are # differences in the LA
    T #n              - there are #n trace point intervals for the LA
     (#d #y )^#n      - there are #d difference aligning the #y bp's of B with the
                           next fixed-size interval of A
    + X #             - Total amount of X (X = P or T)
    % X #             - Maximum amount of X in any pile (X = P or T)
    @ T #             - Maximum number of trace points in any trace

1-code lines that begin with +, %, or @ are always the first lines in the output.
They give size information about what is contained in the output.  Specifically,
'+ X #' gives the total number of LAs (X=P), or the total number of trace point
intervals (X=T) in the file .  '% X #' gives the maximum number of LAs (X=P) or
the maximum number of trace point intervals (X=T) in a given *pile* (collection of
LAs all with the same a-read (applies only to sorted .las files).  Finally @ T #
gives the maximum # of trace point intervals in any trace within the file.

# SEE ALSO
**daligner**(1)
