/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.AstNode;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.chromium.devtools.jsdoc.ValidatorContext;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;
import org.chromium.devtools.jsdoc.checks.TypeRecord;

public class ContextTrackingState {
    private final ValidatorContext context;
    final Map<String, TypeRecord> typeRecordsByTypeName = new HashMap<String, TypeRecord>();
    final Deque<TypeRecord> typeRecords = new LinkedList<TypeRecord>();
    final Deque<FunctionRecord> functionRecords = new LinkedList<FunctionRecord>();

    ContextTrackingState(ValidatorContext validatorContext) {
        this.context = validatorContext;
    }

    TypeRecord getCurrentTypeRecord() {
        return this.typeRecords.peekLast();
    }

    FunctionRecord getCurrentFunctionRecord() {
        return this.functionRecords.peekLast();
    }

    ValidatorContext getContext() {
        return this.context;
    }

    Map<String, TypeRecord> getTypeRecordsByTypeName() {
        return this.typeRecordsByTypeName;
    }

    String getNodeText(AstNode astNode) {
        return this.getContext().getNodeText(astNode);
    }

    void pushTypeRecord(TypeRecord typeRecord) {
        this.typeRecords.addLast(typeRecord);
    }

    void popTypeRecord() {
        this.typeRecords.removeLast();
    }

    void pushFunctionRecord(FunctionRecord functionRecord) {
        this.functionRecords.addLast(functionRecord);
    }

    void popFunctionRecord() {
        this.functionRecords.removeLast();
    }
}

