#!/bin/sh
#
# AspectJ make no source release; so we need to check sources from CVS.
#
# This scripts retrieves the version specified in debian/changelog,
# transforming it into an AspectJ CVS tag. (For instance `1.5.3' is changed to
# `V1_5_3_final'.) The script then removes stuff we don't need.
#
# To keep everything from the checkout invoke this script with `keep'
#
set -e

TMPDIR=`mktemp -t -d aspectj-cvs.XXXXXXXXXX` || exit 1
trap "rm -Rf $TMPDIR" 0
VERSION=$(dpkg-parsechangelog | grep '^Version:' | cut -f 2 -d ' ' | sed "s/-\(.*\)$//")
TAG="V`echo $VERSION | sed "s/\+dfsg//" | sed "s/~//" | tr . _`"
ORIGDIR="$TMPDIR/aspectj-$VERSION"

CVSROOT=":pserver:anonymous@dev.eclipse.org:/cvsroot/tools"

echo "retrieving AspectJ sources tagged $TAG"
mkdir $ORIGDIR || exit 1
(cd $ORIGDIR && cvs -d $CVSROOT export -r$TAG org.aspectj/modules >/dev/null 2>&1)

if test "a$1" = "akeep"; then
  echo "keeping all files"
else
  echo "removing unneeded files"
  find $ORIGDIR/org.aspectj -name .cvsignore -delete

  # Remove unlicenced files
  find $ORIGDIR/org.aspectj -type d -name "testdata" | xargs rm -rf
  find $ORIGDIR/org.aspectj -type d -name "testsrc" | xargs rm -rf
  rm -rf $ORIGDIR/org.aspectj/modules/tests/
  rm -rf $ORIGDIR/org.aspectj/modules/testing/
  rm -rf $ORIGDIR/org.aspectj/modules/org.aspectj.ajdt.core/scripts/*.py

  # Remove non-free docs
  rm -rf $ORIGDIR/org.aspectj/modules/docs/dist/doc/examples
  rm -rf $ORIGDIR/org.aspectj/modules/docs/sandbox/
  rm -rf $ORIGDIR/org.aspectj/modules/docs/teaching/
  rm -rf $ORIGDIR/org.aspectj/modules/docs/test/
  find $ORIGDIR/org.aspectj -type f -name "*.doc" -delete
  find $ORIGDIR/org.aspectj -type f -name "*.pdf" -delete
  find $ORIGDIR/org.aspectj -type f -name "*.ppt" -delete
  find $ORIGDIR/org.aspectj -type f -name "*.vsd" -delete

  # We'll use Debian version of these
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/ant
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/junit
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/commons
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/asm

  # Keep sources only, rebuild them at package build time
  rm -rf $ORIGDIR/org.aspectj/modules/bcel-builder/
  rm -f $ORIGDIR/org.aspectj/modules/lib/bcel/bcel*.jar
  rm -f $ORIGDIR/org.aspectj/modules/org.eclipse.jdt.core/jdtcore-for-aspectj*.jar
  # NOTE:this jar is rebuild after initial bootstrap
  #rm -f $ORIGDIR/org.aspectj/modules/lib/build/build.jar

  # Bootstrap using symlink to existing aspectj
  rm -f $ORIGDIR/org.aspectj/modules/lib/aspectj/lib/aspectj*.jar

  # The LICENSE.TXT here refers to managementapi-jrockit81.jar which is removed as well
  # See http://dev.eclipse.org/viewcvs/index.cgi/org.aspectj/modules/lib/ext/jrockit/LICENSE.TXT?root=Tools_Project&view=co
  (cd $ORIGDIR/org.aspectj/modules/lib/ext/jrockit && rm -f jrockit.jar LICENSE.TXT managementapi-jrockit81.jar jrockit-src.zip)
  rm -f $ORIGDIR/org.aspectj/modules/loadtime/src/org/aspectj/weaver/loadtime/JRockitAgent.java

  # These ones are not needed
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/docbook
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/jdiff
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/jython
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/regexp
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/saxon
  rm -Rf $ORIGDIR/org.aspectj/modules/lib/test
fi

echo "generating ../aspectj_$VERSION.orig.tar.gz"
tar -C $TMPDIR -czf ../aspectj_$VERSION.orig.tar.gz aspectj-$VERSION
