#!/bin/bash

for path in $(arriero list -f path "$@"); do
    echo $path
    (
        cd $path
        changes=0

        version=$(sed -n 's/^Standards-Version:\s*\(\S*\)/\1/p' debian/control)
        if [ "$version" != "3.9.4" ]; then
            sed -i 's/^Standards-Version:.*$/Standards-Version: 3.9.4/' debian/control
            changes=1
        fi

        if [ $changes -gt 0 ]; then
            dch 'Bump Standards-Version to 3.9.4.'
            git commit -a -m 'Bump Standards-Version to 3.9.4.'
        fi
    )
done
