/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Before;
import org.junit.internal.runners.BeforeAndAfterRunner;
import org.junit.internal.runners.TestIntrospector;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMethodRunner
extends BeforeAndAfterRunner {
    private final Object fTest;
    private final Method fMethod;
    private final RunNotifier fNotifier;
    private final TestIntrospector fTestIntrospector;
    private final Description fDescription;

    public TestMethodRunner(Object test, Method method, RunNotifier notifier, Description description) {
        super(test.getClass(), Before.class, After.class, test);
        this.fTest = test;
        this.fMethod = method;
        this.fNotifier = notifier;
        this.fTestIntrospector = new TestIntrospector(test.getClass());
        this.fDescription = description;
    }

    public void run() {
        if (this.fTestIntrospector.isIgnored(this.fMethod)) {
            this.fNotifier.fireTestIgnored(this.fDescription);
            return;
        }
        this.fNotifier.fireTestStarted(this.fDescription);
        try {
            long timeout = this.fTestIntrospector.getTimeout(this.fMethod);
            if (timeout > 0L) {
                this.runWithTimeout(timeout);
            } else {
                this.runMethod();
            }
        }
        finally {
            this.fNotifier.fireTestFinished(this.fDescription);
        }
    }

    private void runWithTimeout(long timeout) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TestMethodRunner.this.runMethod();
                return null;
            }
        };
        Future<Object> result = service.submit(callable);
        service.shutdown();
        try {
            boolean terminated = service.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            if (!terminated) {
                service.shutdownNow();
            }
            result.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            this.addFailure(new Exception(String.format("test timed out after %d milliseconds", timeout)));
        }
        catch (Exception e) {
            this.addFailure(e);
        }
    }

    private void runMethod() {
        this.runProtected();
    }

    @Override
    protected void runUnprotected() {
        try {
            this.executeMethodBody();
            if (this.expectsException()) {
                this.addFailure((Throwable)((Object)new AssertionError((Object)("Expected exception: " + this.expectedException().getName()))));
            }
        }
        catch (InvocationTargetException e) {
            Throwable actual = e.getTargetException();
            if (!this.expectsException()) {
                this.addFailure(actual);
            } else if (this.isUnexpected(actual)) {
                String message = "Unexpected exception, expected<" + this.expectedException().getName() + "> but was<" + actual.getClass().getName() + ">";
                this.addFailure(new Exception(message, actual));
            }
        }
        catch (Throwable e) {
            this.addFailure(e);
        }
    }

    protected void executeMethodBody() throws IllegalAccessException, InvocationTargetException {
        this.fMethod.invoke(this.fTest, new Object[0]);
    }

    @Override
    protected void addFailure(Throwable e) {
        this.fNotifier.fireTestFailure(new Failure(this.fDescription, e));
    }

    private boolean expectsException() {
        return this.expectedException() != null;
    }

    private Class<? extends Throwable> expectedException() {
        return this.fTestIntrospector.expectedException(this.fMethod);
    }

    private boolean isUnexpected(Throwable exception) {
        return !this.expectedException().isAssignableFrom(exception.getClass());
    }
}

