/*
 *   DIS/x : An implementation of the IEEE 1278.1 protocol
 *
 *   Copyright (C) 1997, Riley Rainey (rrainey@ix.netcom.com)
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of either:
 *
 *   a) the GNU Library General Public License as published by the Free
 *   Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.  A description of the terms and conditions
 *   of the GLPL may be found in the "COPYING.LIB" file.
 *
 *   b) the "Artistic License" which comes with this Kit.  Information
 *   about this license may be found in the "Artistic" file.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License or the Artistic License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Information describing how to contact the author can be found in the
 *   README file.
 */

/**
 * Encoding/decoding functions for DIS packets.
 * 
 * @file
 */

#ifndef XDR_DIS_H
#define	XDR_DIS_H

#include "xdr.h"
#include "dis.h"

#ifdef xdr_dis_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Encodes/decodes a DIS PDU packet.
 * @param xdrs
 * @param objp
 * @return True on success.
 */
EXTERN int xdr_dis_pdu(xdr_Type * xdrs, dis_pdu * objp);

#undef EXTERN
#endif	/* XDR_DIS_H */

