;;; CONSTANTS
;;; Used mainly for testing purposes.

;;*users*
;; Describes users are in the system
(defconst *users* 
  '(
    (rjh (user . rjh)
	 (already-answered)
	 (default-response)
	 (name . rjh))
    (bob (user . bob)
	 (already-answered)
	 (user)
	 (default-response)
	 (name . bob))
    (postmaster (already-answered)
		(default-response)
		(user . postmaster)
		(name . postmaster))))

;;*hosts*
;; Describes hosts in system
(defconst *hosts*
  '(
    (host (users rjh bob postmaster)
	  (users bob postmaster)
	  (hostname . host)
	  (hostname)
	  (users postmaster)
	  (name . host))
    (remail (hostname)
	    (users postmaster)
	    (name . remail))
    (sender (hostname)
	    (users postmaster)
	    (name . sender))))

(defconst *commands* 
  '(init_user 
    set_hostname 
    set_user 
    default_response))

(defconst *key-space* '(a b c d e))
(defconst *user-names* '(rjh bob))
(defconst *vacation-space* '("I'm on vacation" 
			    "I love my job, but i love fishing more"))

(defconst *init-env*
  (acons 'users *users*
  (acons 'hosts *hosts*
   '())))

