#!/bin/sh

oneTimeSetUp() {
	# Load the ./play.it library
	export LIB_ONLY=1
	. lib/libplayit2.sh
}

setUp() {
	# Set a temporary directory to mess with real files
	TEST_TEMP_DIR=$(mktemp --directory)
	export TEST_TEMP_DIR
}

tearDown() {
	rm --force --recursive "$TEST_TEMP_DIR"
}

test_deprecation_warnings_shown_file() {
	local warnings_file PLAYIT_WORKDIR

	warnings_file=$(deprecation_warnings_shown_file)
	assertNull "$warnings_file"

	PLAYIT_WORKDIR="$TEST_TEMP_DIR"
	warnings_file=$(deprecation_warnings_shown_file)
	assertEquals "${PLAYIT_WORKDIR}/warnings-shown/deprecation" "$warnings_file"
}

test_deprecation_warnings_shown_add() {
	local warnings_list warnings_list_expected warnings_file PLAYIT_WORKDIR

	PLAYIT_WORKDIR="$TEST_TEMP_DIR"
	warnings_file=$(deprecation_warnings_shown_file)

	deprecation_warnings_shown_add 'warning_test1 arg1 arg2'
	warnings_list=$(cat "$warnings_file")
	assertEquals 'warning_test1 arg1 arg2' "$warnings_list"

	deprecation_warnings_shown_add 'warning_test2 arg1 arg2'
	warnings_list=$(cat "$warnings_file")
	warnings_list_expected='warning_test1 arg1 arg2
warning_test2 arg1 arg2'
	assertEquals "$warnings_list_expected" "$warnings_list"
}

test_deprecation_warning_has_been_shown_already() {
	local PLAYIT_WORKDIR

	PLAYIT_WORKDIR="$TEST_TEMP_DIR"

	assertFalse 'deprecation_warning_has_been_shown_already "warning_test arg1 arg2"'
	deprecation_warnings_shown_add 'warning_test arg1 arg2'
	assertTrue 'deprecation_warning_has_been_shown_already "warning_test arg1 arg2"'
}
