#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stacking
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220707.1

GAME_ID='stacking'
GAME_NAME='Stacking'

ARCHIVE_BASE_0='Stacking-Linux-2013-06-04-setup.bin'
ARCHIVE_BASE_0_MD5='4194bb869d537d40da7ad7f65b1102ed'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='1600000'
ARCHIVE_BASE_0_VERSION='130604-humble160616'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/stacking'

CONTENT_PATH_DEFAULT='data'
ARCHIVE_GAME_BIN_FILES='
Stack.bin.x86
lib'
ARCHIVE_GAME_DATA_FILES='
Data
Linux
OGL
Stack.png
Win
DFCONFIG'

APP_MAIN_TYPE='native'
APP_MAIN_EXE='Stack.bin.x86'
APP_MAIN_ICON='Stack.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 liubGLU.so.1"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

#print instructions

print_instructions

exit 0
