/*
 * SPDX-FileCopyrightText: Copyright (c) 2016-2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*
 * @brief Stubs for HAL routines that are not implement for all GPUs
 */

#include "gpu/gpu.h"

#include "vgpu/rpc.h"
#include "vgpu/vgpu_events.h"

typedef struct OBJGPIO_HAL OBJGPIO_HAL, *POBJGPIO_HAL;
typedef struct GPIO_HAL_IFACES GPIO_HAL_IFACES;
typedef struct _def_gpio_pin_state GPIO_PIN_STATE, *PGPIO_PIN_STATE;
typedef struct _GPIO_FUNC_LIST_ITEM GPIO_FUNC_LIST_ITEM, *PGPIO_FUNC_LIST_ITEM;

// pull in stub interfaces generated by rmconfig
#include "g_hal_stubs.h"
