/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.TilePart;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Tile
extends MainOrTile {
    private List _tileParts = new LinkedList();
    private List _pptLengthList;

    public void addTilePart(TilePart tilePart) {
        this._tileParts.add(tilePart);
    }

    public List getTileParts() {
        return this._tileParts;
    }

    public void addPPTLength(long l) {
        this._pptLengthList.add(new Long(l));
    }

    public Property makeProperty() {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        if (!this._tileParts.isEmpty()) {
            ListIterator listIterator = this._tileParts.listIterator();
            while (listIterator.hasNext()) {
                TilePart tilePart = (TilePart)listIterator.next();
                linkedList.add(tilePart.makeProperty());
            }
        }
        if (this._components != null) {
            for (int i = 0; i < this._components.length; ++i) {
                if (this._components[i] != null) continue;
                this._components[i] = new Property("Component", PropertyType.PROPERTY, PropertyArity.LIST, new LinkedList());
            }
            linkedList.add(new Property("Components", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)this._components));
        }
        if (this._codProperty != null) {
            linkedList.add(this._codProperty);
        }
        if (this._qcdProperty != null) {
            linkedList.add(this._qcdProperty);
        }
        if (this._pocProperty != null) {
            linkedList.add(this._pocProperty);
        }
        if (this._packetLengthList != null && !this._packetLengthList.isEmpty()) {
            linkedList.add(new Property("PacketLengths", PropertyType.LONG, PropertyArity.LIST, (Object)this._packetLengthList));
        }
        if (this._pptLengthList != null && this._pptLengthList.isEmpty()) {
            linkedList.add(new Property("PackedPacketHeaderLengths", PropertyType.LONG, PropertyArity.LIST, (Object)this._pptLengthList));
        }
        if (!this._comments.isEmpty()) {
            linkedList.add(new Property("Comments", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._comments));
        }
        return new Property("Tile", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
    }
}

