/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

final class MRUCachingSAMSequenceDictionary {
    private final SAMSequenceDictionary dict;
    SAMSequenceRecord lastSSR = null;
    String lastContig = "";
    int lastIndex = -1;

    @Ensures(value={"lastSSR == null"})
    public MRUCachingSAMSequenceDictionary(SAMSequenceDictionary dict) {
        if (dict == null) {
            throw new IllegalArgumentException("Dictionary cannot be null");
        }
        if (dict.size() == 0) {
            throw new IllegalArgumentException("Dictionary cannot have size zero");
        }
        this.dict = dict;
    }

    @Ensures(value={"result != null"})
    public SAMSequenceDictionary getDictionary() {
        return this.dict;
    }

    @Requires(value={"contig != null"})
    public final boolean hasContig(String contig) {
        return contig.equals(this.lastContig) || this.dict.getSequence(contig) != null;
    }

    @Requires(value={"contigIndex >= 0"})
    public final boolean hasContigIndex(int contigIndex) {
        return this.lastIndex == contigIndex || this.dict.getSequence(contigIndex) != null;
    }

    @Requires(value={"contig != null"})
    @Ensures(value={"result != null"})
    public final SAMSequenceRecord getSequence(String contig) {
        if (this.isCached(contig)) {
            return this.lastSSR;
        }
        return this.updateCache(contig, -1);
    }

    @Requires(value={"index >= 0"})
    @Ensures(value={"result != null"})
    public final SAMSequenceRecord getSequence(int index) {
        if (this.isCached(index)) {
            return this.lastSSR;
        }
        return this.updateCache(null, index);
    }

    @Requires(value={"contig != null"})
    @Ensures(value={"result >= 0"})
    public final int getSequenceIndex(String contig) {
        if (!this.isCached(contig)) {
            this.updateCache(contig, -1);
        }
        return this.lastIndex;
    }

    @Requires(value={"contig != null"})
    protected boolean isCached(String contig) {
        return contig.equals(this.lastContig);
    }

    protected boolean isCached(int index) {
        return this.lastIndex == index;
    }

    @Requires(value={"contig != null || index >= 0"})
    @Ensures(value={"result != null"})
    private SAMSequenceRecord updateCache(String contig, int index) {
        SAMSequenceRecord rec;
        SAMSequenceRecord sAMSequenceRecord = rec = contig == null ? this.dict.getSequence(index) : this.dict.getSequence(contig);
        if (rec == null) {
            throw new ReviewedGATKException("BUG: requested unknown contig=" + contig + " index=" + index);
        }
        this.lastSSR = rec;
        this.lastContig = rec.getSequenceName();
        this.lastIndex = rec.getSequenceIndex();
        return rec;
    }
}

