/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.util.Arrays;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LogicalTransactionId;
import oracle.jdbc.driver.NTFLTXIDEvent;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.ReplayContext;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIidc;
import oracle.jdbc.driver.T4CTTIkvarr;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

abstract class T4CTTIfun
extends T4CTTIMsg {
    static final short OOPEN = 2;
    static final short OFETCH = 5;
    static final short OCLOSE = 8;
    static final short OLOGOFF = 9;
    static final short OCOMON = 12;
    static final short OCOMOFF = 13;
    static final short OCOMMIT = 14;
    static final short OROLLBACK = 15;
    static final short OCANCEL = 20;
    static final short ODSCRARR = 43;
    static final short OVERSION = 59;
    static final short OK2RPC = 67;
    static final short OALL7 = 71;
    static final short OSQL7 = 74;
    static final short O3LOGON = 81;
    static final short O3LOGA = 82;
    static final short OKOD = 92;
    static final short OALL8 = 94;
    static final short OLOBOPS = 96;
    static final short ODNY = 98;
    static final short OTXSE = 103;
    static final short OTXEN = 104;
    static final short OCCA = 105;
    static final short O80SES = 107;
    static final short OAUTH = 115;
    static final short OSESSKEY = 118;
    static final short OCANA = 120;
    static final short OKPN = 125;
    static final short OOTCM = 127;
    static final short OSCID = 135;
    static final short OSPFPPUT = 138;
    static final short OKPFC = 139;
    static final short OPING = 147;
    static final short OKEYVAL = 154;
    static final short OXSSCS = 155;
    static final short OXSSRO = 156;
    static final short OXSSPO = 157;
    static final short OAQEQ = 121;
    static final short OAQDQ = 122;
    static final short OAQGPS = 132;
    static final short OAQLS = 126;
    static final short OAQXQ = 145;
    static final short OSESSGET = 162;
    static final short OSESSRLS = 163;
    static final short OXSNSO = 172;
    static final short OXSNS = 178;
    static final short OXSSYNC = 176;
    static final short OXSATT = 180;
    static final short OXSCRE = 179;
    static final short OXSDET = 181;
    static final short OXSDES = 182;
    static final short OXSSET = 183;
    static final short OSESSSTATE = 176;
    static final short OAPPCONTREPLAY = 177;
    static final short OAQENQ = 184;
    static final short OAQDEQ = 185;
    static final short OAQEMNDEQ = 186;
    static final short OAQNFY = 187;
    private short funCode;
    protected final T4CTTIoer oer;
    int receiveState = 0;
    static final int IDLE_RECEIVE_STATE = 0;
    static final int ACTIVE_RECEIVE_STATE = 1;
    static final int READROW_RECEIVE_STATE = 2;
    static final int STREAM_RECEIVE_STATE = 3;
    boolean rpaProcessed = false;
    boolean rxhProcessed = false;
    boolean iovProcessed = false;
    private final short[] ttiList;
    private int ttiListEnd = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    T4CTTIfun(T4CConnection t4CConnection, byte by) {
        super(t4CConnection, by);
        this.oer = t4CConnection.getT4CTTIoer();
        this.ttiList = t4CConnection.ttiList;
    }

    final void setFunCode(short s2) {
        this.funCode = s2;
    }

    final short getFunCode() {
        return this.funCode;
    }

    private final void marshalFunHeader() throws IOException {
        this.connection.setExecutingRPCFunctionCode(this.funCode);
        this.marshalTTCcode();
        this.meg.marshalUB1(this.funCode);
        this.meg.marshalUB1(this.connection.getNextSeqNumber());
    }

    abstract void marshal() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void doRPC() throws IOException, SQLException {
        if (this.getTTCCode() == 17) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.connection.sendPiggyBackedMessages();
        for (int i2 = 0; i2 < 5; ++i2) {
            this.init();
            this.marshalFunHeader();
            try {
                this.connection.pipeState = 1;
                this.marshal();
                this.connection.pipeState = 2;
                this.receive();
                return;
            }
            catch (SQLException sQLException) {
                Object object = this.connection.cancelInProgressLockForThin;
                synchronized (object) {
                    block12: {
                        if (sQLException.getErrorCode() != 1013 && (!this.connection.cancelInProgressFlag || sQLException.getMessage() == null || !sQLException.getMessage().contains("ORA-01013"))) break block12;
                        this.connection.cancelInProgressFlag = false;
                        if (this.funCode != 15 && this.funCode != 12 && this.funCode != 13 && this.funCode != 14 && this.funCode != 59 || this.oer.callNumber == this.connection.currentTTCSeqNumber && !this.connection.statementCancel) break block12;
                        continue;
                    }
                    throw sQLException;
                }
            }
            finally {
                this.connection.pipeState = -1;
            }
        }
    }

    final void doPigRPC() throws IOException {
        this.init();
        this.marshalFunHeader();
        this.marshal();
    }

    final void doOneWayRPC() throws IOException, SQLException {
        this.connection.sendPiggyBackedMessages();
        this.init();
        this.marshalFunHeader();
        this.marshal();
        this.meg.flush();
    }

    private void init() {
        this.rpaProcessed = false;
        this.rxhProcessed = false;
        this.iovProcessed = false;
        this.ttiListEnd = 0;
    }

    void resumeReceive() throws SQLException, IOException {
        this.receive();
    }

    private final String ttiListString() {
        String string = "[ ";
        for (int i2 = 0; i2 < this.ttiListEnd; ++i2) {
            string = string + this.ttiList[i2] + ", ";
        }
        string = string + "]";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void receive() throws SQLException, IOException {
        var1_1 = null;
        this.receiveState = 1;
        try {
            var2_2 = null;
            block44: while (true) lbl-1000:
            // 24 sources

            {
                try {
                    var3_6 = this.meg.unmarshalUB1();
                    if (this.ttiListEnd < this.ttiList.length) {
                        this.ttiList[this.ttiListEnd++] = var3_6;
                    }
                    switch (var3_6) {
                        case 8: {
                            if (this.rpaProcessed) {
                                var4_7 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
                                var4_7.fillInStackTrace();
                                throw var4_7;
                            }
                            this.readRPA();
                            try {
                                this.processRPA();
                            }
                            catch (SQLException var4_8) {
                                var2_2 = var4_8;
                            }
                            this.rpaProcessed = true;
                            ** break;
                        }
                        case 21: {
                            this.readBVC();
                            ** break;
                        }
                        case 11: {
                            this.readIOV();
                            this.iovProcessed = true;
                            ** break;
                        }
                        case 6: {
                            this.readRXH();
                            this.rxhProcessed = true;
                            ** break;
                        }
                        case 12: {
                            this.processSLG();
                            ** break;
                        }
                        case 7: {
                            this.receiveState = 2;
                            if (this.readRXD()) {
                                this.receiveState = 3;
                                return;
                            }
                            this.receiveState = 1;
                            ** break;
                        }
                        case 16: {
                            this.readDCB();
                            ** break;
                        }
                        case 14: {
                            this.readLOBD();
                            ** break;
                        }
                        case 23: {
                            var4_9 = (byte)this.meg.unmarshalUB1();
                            switch (var4_9) {
                                case 1: {
                                    var5_11 = this.meg.unmarshalUB2();
                                    var6_19 = (byte)this.meg.unmarshalUB1();
                                    var7_20 = 0;
                                    while (true) {
                                        if (var7_20 >= var5_11) continue block44;
                                        var8_25 = new T4CTTIidc(this.connection);
                                        var8_25.unmarshal();
                                        ++var7_20;
                                    }
                                }
                                case 2: {
                                    var5_12 = this.meg.unmarshalUB2();
                                    var6_19 = (byte)this.meg.unmarshalUB1();
                                    var7_21 = this.meg.unmarshalNBytes(var5_12);
                                    ** break;
                                }
                                case 4: {
                                    this.connection.ocsessret.receive();
                                    ** break;
                                }
                                case 5: {
                                    var5_13 = this.meg.unmarshalUB2();
                                    var6_19 = (byte)this.meg.unmarshalUB1();
                                    var7_22 = new T4CTTIkvarr(this.connection);
                                    var7_22.unmarshal();
                                    ** break;
                                }
                                case 7: {
                                    var5_14 = this.meg.unmarshalDALC();
                                    var6_19 = Arrays.hashCode(var5_14);
                                    if (this.connection.thinACLastLtxidHash == var6_19) continue block44;
                                    this.connection.thinACCurrentLTXID = var7_23 = new LogicalTransactionId(var5_14);
                                    var8_26 = new NTFLTXIDEvent(this.connection, var7_23);
                                    this.connection.notify(var8_26);
                                    this.connection.thinACLastLtxidHash = var6_19;
                                    ** break;
                                }
                                case 9: {
                                    var7_20 = this.meg.unmarshalUB2();
                                    var8_27 = (byte)this.meg.unmarshalUB1();
                                    var9_29 = 0;
                                    while (true) {
                                        if (var9_29 >= var7_20) continue block44;
                                        var10_31 = new NTFXSEvent(this.connection);
                                        this.connection.notify(var10_31);
                                        ++var9_29;
                                    }
                                }
                                case 8: {
                                    var7_20 = this.meg.unmarshalUB2();
                                    var8_28 = (byte)this.meg.unmarshalUB1();
                                    var9_30 = this.meg.unmarshalUB4();
                                    var11_32 = this.meg.unmarshalUB4();
                                    var13_33 = this.meg.unmarshalUB1();
                                    var14_34 = this.meg.unmarshalDALC();
                                    var1_1 = new ReplayContext(var9_30, var13_33, var14_34, var11_32);
                                    ** break;
                                }
                                default: {
                                    var7_24 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, this.ttiListString());
                                    var7_24.fillInStackTrace();
                                    throw var7_24;
                                }
                            }
                        }
                        case 19: {
                            this.meg.marshalUB1((short)19);
                            ** break;
                        }
                        case 27: {
                            this.readIMPLRES();
                            ** break;
                        }
                        case 15: {
                            this.oer.init();
                            this.oer.unmarshalWarning();
                            try {
                                this.oer.processWarning();
                            }
                            catch (SQLWarning var5_15) {
                                this.connection.setWarnings(DatabaseError.addSqlWarning(this.connection.getWarnings(), var5_15));
                            }
                            continue block44;
                        }
                        case 9: {
                            this.processEOCS();
                            if (this.connection.getTTCVersion() >= 3) {
                                this.connection.endToEndECIDSequenceNumber = var5_16 = (short)this.meg.unmarshalUB2();
                            }
                            break block44;
                        }
                        case 13: {
                            this.readOAC();
                            ** break;
                        }
                        case 4: {
                            this.processEOCS();
                            this.oer.init();
                            this.oer.unmarshal();
                            try {
                                this.processError();
                            }
                            catch (SQLException var5_17) {
                                var2_2 = var5_17;
                            }
                            break block44;
                        }
                        default: {
                            var5_18 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, this.ttiListString());
                            var5_18.fillInStackTrace();
                            throw var5_18;
                        }
                    }
                }
                catch (BreakNetException var4_10) {}
                continue;
                finally {
                    this.connection.sentCancel = false;
                    continue;
                }
                break;
            }
            this.receiveState = 0;
            if (var2_2 != null) {
                throw var2_2;
            }
        }
        catch (SQLRecoverableException var2_3) {
            throw var2_3;
        }
        catch (IOException var2_4) {
            if (var1_1 != null) {
                this.handleReplayContext(var1_1);
            }
            throw var2_4;
        }
        catch (SQLException var2_5) {
            if (var1_1 != null) {
                this.handleReplayContext(var1_1);
            }
            this.connection.setExecutingRPCFunctionCode((short)0);
            this.connection.setExecutingRPCSQL(null);
            throw var2_5;
        }
        if (var1_1 != null) {
            this.handleReplayContext(var1_1);
        }
        this.connection.setExecutingRPCFunctionCode((short)0);
        this.connection.setExecutingRPCSQL(null);
    }

    private final void handleReplayContext(ReplayContext replayContext) {
        if (this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.NONREQUEST)) {
            return;
        }
        assert ((replayContext.flags_kpdxcAppContCtl & 4L) != 0L || replayContext.errcode_kpdxcAppContCtl != 41406L || !this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) : "Server disabled replay with error " + replayContext.errcode_kpdxcAppContCtl + " but our replayModes=" + this.connection.replayModes;
        assert (replayContext.replayctx_kpdxcAppContCtl == null || replayContext.replayctx_kpdxcAppContCtl.length <= 0 || this.connection.getExecutingRPCFunctionCode() == 115 || this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) : "Server is sending a non-null replay context but our replayModes=" + this.connection.replayModes;
        if (this.connection.thinACReplayContextReceived.length == this.connection.thinACReplayContextReceivedCurrent) {
            ReplayContext[] replayContextArray = new ReplayContext[this.connection.thinACReplayContextReceived.length * 2];
            System.arraycopy(this.connection.thinACReplayContextReceived, 0, replayContextArray, 0, this.connection.thinACReplayContextReceived.length);
            this.connection.thinACReplayContextReceived = replayContextArray;
        }
        this.connection.thinACReplayContextReceived[this.connection.thinACReplayContextReceivedCurrent++] = replayContext;
        if ((replayContext.flags_kpdxcAppContCtl & 4L) == 0L) {
            this.connection.replayModes.remove((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED);
            this.connection.replayModes.remove((Object)T4CConnection.ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
        }
        if (!(replayContext.replayctx_kpdxcAppContCtl == null || replayContext.replayctx_kpdxcAppContCtl.length <= 0 || this.connection.getExecutingRPCFunctionCode() == 115 && this.connection.ignoreReplayContextFromAuthentication)) {
            this.connection.thinACLastReplayContextReceived = replayContext;
        }
    }

    private final void processEOCS() throws SQLException, IOException {
        if (this.connection.hasServerCompileTimeCapability(15, 1)) {
            int n2;
            this.connection.eocs = n2 = (int)this.meg.unmarshalUB4();
            if ((n2 & 8) != 0) {
                long l2 = this.meg.unmarshalSB8();
            }
        }
    }

    void processRPA() throws SQLException {
    }

    void readOAC() {
    }

    void readRPA() throws IOException, SQLException {
    }

    void readBVC() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void readLOBD() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void readIOV() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void readRXH() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    boolean readRXD() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void readIMPLRES() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void readDCB() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void processSLG() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void processError() throws SQLException {
        this.oer.processError();
    }

    final int getErrorCode() throws SQLException {
        return this.oer.retCode;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

