// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.
//
// The following data was created from https://gitlab.freedesktop.org/xorg/app/rgb
// (commit 0d2caecebf0e2a10994c22960921f366dd98d19a) by running this command:
// $ showrgb | sort -k4 | awk -f program
// with the AWK programs indicated below before each data block.
// The rgb.txt file licence is as follows:
//
// Copyright 1985, 1989, 1998  The Open Group
//
// Permission to use, copy, modify, distribute, and sell this software and its
// documentation for any purpose is hereby granted without fee, provided that
// the above copyright notice appear in all copies and that both that
// copyright notice and this permission notice appear in supporting
// documentation.
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
// OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of The Open Group shall
// not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization
// from The Open Group.
//
// Copyright (c) 1994, 2008, Oracle and/or its affiliates.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice (including the next
// paragraph) shall be included in all copies or substantial portions of the
// Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

// BEGIN { FIELDWIDTHS = "4 4 4 *" }
// {
//     sub(/^\s*/, "", $4);
//     printf "assert_color_parse_named(\"%s\", 0x%06x);\n", $4, $1 * 0x10000 + 0x100 * $2 + $3
// }
assert_color_parse_named("alice blue", 0xf0f8ff);
assert_color_parse_named("AliceBlue", 0xf0f8ff);
assert_color_parse_named("antique white", 0xfaebd7);
assert_color_parse_named("AntiqueWhite", 0xfaebd7);
assert_color_parse_named("AntiqueWhite1", 0xffefdb);
assert_color_parse_named("AntiqueWhite2", 0xeedfcc);
assert_color_parse_named("AntiqueWhite3", 0xcdc0b0);
assert_color_parse_named("AntiqueWhite4", 0x8b8378);
assert_color_parse_named("aqua", 0x00ffff);
assert_color_parse_named("aquamarine", 0x7fffd4);
assert_color_parse_named("aquamarine1", 0x7fffd4);
assert_color_parse_named("aquamarine2", 0x76eec6);
assert_color_parse_named("aquamarine3", 0x66cdaa);
assert_color_parse_named("aquamarine4", 0x458b74);
assert_color_parse_named("azure", 0xf0ffff);
assert_color_parse_named("azure1", 0xf0ffff);
assert_color_parse_named("azure2", 0xe0eeee);
assert_color_parse_named("azure3", 0xc1cdcd);
assert_color_parse_named("azure4", 0x838b8b);
assert_color_parse_named("beige", 0xf5f5dc);
assert_color_parse_named("bisque", 0xffe4c4);
assert_color_parse_named("bisque1", 0xffe4c4);
assert_color_parse_named("bisque2", 0xeed5b7);
assert_color_parse_named("bisque3", 0xcdb79e);
assert_color_parse_named("bisque4", 0x8b7d6b);
assert_color_parse_named("black", 0x000000);
assert_color_parse_named("blanched almond", 0xffebcd);
assert_color_parse_named("BlanchedAlmond", 0xffebcd);
assert_color_parse_named("blue", 0x0000ff);
assert_color_parse_named("blue1", 0x0000ff);
assert_color_parse_named("blue2", 0x0000ee);
assert_color_parse_named("blue3", 0x0000cd);
assert_color_parse_named("blue4", 0x00008b);
assert_color_parse_named("blue violet", 0x8a2be2);
assert_color_parse_named("BlueViolet", 0x8a2be2);
assert_color_parse_named("brown", 0xa52a2a);
assert_color_parse_named("brown1", 0xff4040);
assert_color_parse_named("brown2", 0xee3b3b);
assert_color_parse_named("brown3", 0xcd3333);
assert_color_parse_named("brown4", 0x8b2323);
assert_color_parse_named("burlywood", 0xdeb887);
assert_color_parse_named("burlywood1", 0xffd39b);
assert_color_parse_named("burlywood2", 0xeec591);
assert_color_parse_named("burlywood3", 0xcdaa7d);
assert_color_parse_named("burlywood4", 0x8b7355);
assert_color_parse_named("cadet blue", 0x5f9ea0);
assert_color_parse_named("CadetBlue", 0x5f9ea0);
assert_color_parse_named("CadetBlue1", 0x98f5ff);
assert_color_parse_named("CadetBlue2", 0x8ee5ee);
assert_color_parse_named("CadetBlue3", 0x7ac5cd);
assert_color_parse_named("CadetBlue4", 0x53868b);
assert_color_parse_named("chartreuse", 0x7fff00);
assert_color_parse_named("chartreuse1", 0x7fff00);
assert_color_parse_named("chartreuse2", 0x76ee00);
assert_color_parse_named("chartreuse3", 0x66cd00);
assert_color_parse_named("chartreuse4", 0x458b00);
assert_color_parse_named("chocolate", 0xd2691e);
assert_color_parse_named("chocolate1", 0xff7f24);
assert_color_parse_named("chocolate2", 0xee7621);
assert_color_parse_named("chocolate3", 0xcd661d);
assert_color_parse_named("chocolate4", 0x8b4513);
assert_color_parse_named("coral", 0xff7f50);
assert_color_parse_named("coral1", 0xff7256);
assert_color_parse_named("coral2", 0xee6a50);
assert_color_parse_named("coral3", 0xcd5b45);
assert_color_parse_named("coral4", 0x8b3e2f);
assert_color_parse_named("cornflower blue", 0x6495ed);
assert_color_parse_named("CornflowerBlue", 0x6495ed);
assert_color_parse_named("cornsilk", 0xfff8dc);
assert_color_parse_named("cornsilk1", 0xfff8dc);
assert_color_parse_named("cornsilk2", 0xeee8cd);
assert_color_parse_named("cornsilk3", 0xcdc8b1);
assert_color_parse_named("cornsilk4", 0x8b8878);
assert_color_parse_named("crimson", 0xdc143c);
assert_color_parse_named("cyan", 0x00ffff);
assert_color_parse_named("cyan1", 0x00ffff);
assert_color_parse_named("cyan2", 0x00eeee);
assert_color_parse_named("cyan3", 0x00cdcd);
assert_color_parse_named("cyan4", 0x008b8b);
assert_color_parse_named("dark blue", 0x00008b);
assert_color_parse_named("DarkBlue", 0x00008b);
assert_color_parse_named("dark cyan", 0x008b8b);
assert_color_parse_named("DarkCyan", 0x008b8b);
assert_color_parse_named("dark goldenrod", 0xb8860b);
assert_color_parse_named("DarkGoldenrod", 0xb8860b);
assert_color_parse_named("DarkGoldenrod1", 0xffb90f);
assert_color_parse_named("DarkGoldenrod2", 0xeead0e);
assert_color_parse_named("DarkGoldenrod3", 0xcd950c);
assert_color_parse_named("DarkGoldenrod4", 0x8b6508);
assert_color_parse_named("dark gray", 0xa9a9a9);
assert_color_parse_named("DarkGray", 0xa9a9a9);
assert_color_parse_named("dark green", 0x006400);
assert_color_parse_named("DarkGreen", 0x006400);
assert_color_parse_named("dark grey", 0xa9a9a9);
assert_color_parse_named("DarkGrey", 0xa9a9a9);
assert_color_parse_named("dark khaki", 0xbdb76b);
assert_color_parse_named("DarkKhaki", 0xbdb76b);
assert_color_parse_named("dark magenta", 0x8b008b);
assert_color_parse_named("DarkMagenta", 0x8b008b);
assert_color_parse_named("dark olive green", 0x556b2f);
assert_color_parse_named("DarkOliveGreen", 0x556b2f);
assert_color_parse_named("DarkOliveGreen1", 0xcaff70);
assert_color_parse_named("DarkOliveGreen2", 0xbcee68);
assert_color_parse_named("DarkOliveGreen3", 0xa2cd5a);
assert_color_parse_named("DarkOliveGreen4", 0x6e8b3d);
assert_color_parse_named("dark orange", 0xff8c00);
assert_color_parse_named("DarkOrange", 0xff8c00);
assert_color_parse_named("DarkOrange1", 0xff7f00);
assert_color_parse_named("DarkOrange2", 0xee7600);
assert_color_parse_named("DarkOrange3", 0xcd6600);
assert_color_parse_named("DarkOrange4", 0x8b4500);
assert_color_parse_named("dark orchid", 0x9932cc);
assert_color_parse_named("DarkOrchid", 0x9932cc);
assert_color_parse_named("DarkOrchid1", 0xbf3eff);
assert_color_parse_named("DarkOrchid2", 0xb23aee);
assert_color_parse_named("DarkOrchid3", 0x9a32cd);
assert_color_parse_named("DarkOrchid4", 0x68228b);
assert_color_parse_named("dark red", 0x8b0000);
assert_color_parse_named("DarkRed", 0x8b0000);
assert_color_parse_named("dark salmon", 0xe9967a);
assert_color_parse_named("DarkSalmon", 0xe9967a);
assert_color_parse_named("dark sea green", 0x8fbc8f);
assert_color_parse_named("DarkSeaGreen", 0x8fbc8f);
assert_color_parse_named("DarkSeaGreen1", 0xc1ffc1);
assert_color_parse_named("DarkSeaGreen2", 0xb4eeb4);
assert_color_parse_named("DarkSeaGreen3", 0x9bcd9b);
assert_color_parse_named("DarkSeaGreen4", 0x698b69);
assert_color_parse_named("dark slate blue", 0x483d8b);
assert_color_parse_named("DarkSlateBlue", 0x483d8b);
assert_color_parse_named("dark slate gray", 0x2f4f4f);
assert_color_parse_named("DarkSlateGray", 0x2f4f4f);
assert_color_parse_named("DarkSlateGray1", 0x97ffff);
assert_color_parse_named("DarkSlateGray2", 0x8deeee);
assert_color_parse_named("DarkSlateGray3", 0x79cdcd);
assert_color_parse_named("DarkSlateGray4", 0x528b8b);
assert_color_parse_named("dark slate grey", 0x2f4f4f);
assert_color_parse_named("DarkSlateGrey", 0x2f4f4f);
assert_color_parse_named("dark turquoise", 0x00ced1);
assert_color_parse_named("DarkTurquoise", 0x00ced1);
assert_color_parse_named("dark violet", 0x9400d3);
assert_color_parse_named("DarkViolet", 0x9400d3);
assert_color_parse_named("deep pink", 0xff1493);
assert_color_parse_named("DeepPink", 0xff1493);
assert_color_parse_named("DeepPink1", 0xff1493);
assert_color_parse_named("DeepPink2", 0xee1289);
assert_color_parse_named("DeepPink3", 0xcd1076);
assert_color_parse_named("DeepPink4", 0x8b0a50);
assert_color_parse_named("deep sky blue", 0x00bfff);
assert_color_parse_named("DeepSkyBlue", 0x00bfff);
assert_color_parse_named("DeepSkyBlue1", 0x00bfff);
assert_color_parse_named("DeepSkyBlue2", 0x00b2ee);
assert_color_parse_named("DeepSkyBlue3", 0x009acd);
assert_color_parse_named("DeepSkyBlue4", 0x00688b);
assert_color_parse_named("dim gray", 0x696969);
assert_color_parse_named("DimGray", 0x696969);
assert_color_parse_named("dim grey", 0x696969);
assert_color_parse_named("DimGrey", 0x696969);
assert_color_parse_named("dodger blue", 0x1e90ff);
assert_color_parse_named("DodgerBlue", 0x1e90ff);
assert_color_parse_named("DodgerBlue1", 0x1e90ff);
assert_color_parse_named("DodgerBlue2", 0x1c86ee);
assert_color_parse_named("DodgerBlue3", 0x1874cd);
assert_color_parse_named("DodgerBlue4", 0x104e8b);
assert_color_parse_named("firebrick", 0xb22222);
assert_color_parse_named("firebrick1", 0xff3030);
assert_color_parse_named("firebrick2", 0xee2c2c);
assert_color_parse_named("firebrick3", 0xcd2626);
assert_color_parse_named("firebrick4", 0x8b1a1a);
assert_color_parse_named("floral white", 0xfffaf0);
assert_color_parse_named("FloralWhite", 0xfffaf0);
assert_color_parse_named("forest green", 0x228b22);
assert_color_parse_named("ForestGreen", 0x228b22);
assert_color_parse_named("fuchsia", 0xff00ff);
assert_color_parse_named("gainsboro", 0xdcdcdc);
assert_color_parse_named("ghost white", 0xf8f8ff);
assert_color_parse_named("GhostWhite", 0xf8f8ff);
assert_color_parse_named("gold", 0xffd700);
assert_color_parse_named("gold1", 0xffd700);
assert_color_parse_named("gold2", 0xeec900);
assert_color_parse_named("gold3", 0xcdad00);
assert_color_parse_named("gold4", 0x8b7500);
assert_color_parse_named("goldenrod", 0xdaa520);
assert_color_parse_named("goldenrod1", 0xffc125);
assert_color_parse_named("goldenrod2", 0xeeb422);
assert_color_parse_named("goldenrod3", 0xcd9b1d);
assert_color_parse_named("goldenrod4", 0x8b6914);
assert_color_parse_named("gray", 0xbebebe);
assert_color_parse_named("gray0", 0x000000);
assert_color_parse_named("gray1", 0x030303);
assert_color_parse_named("gray10", 0x1a1a1a);
assert_color_parse_named("gray100", 0xffffff);
assert_color_parse_named("gray11", 0x1c1c1c);
assert_color_parse_named("gray12", 0x1f1f1f);
assert_color_parse_named("gray13", 0x212121);
assert_color_parse_named("gray14", 0x242424);
assert_color_parse_named("gray15", 0x262626);
assert_color_parse_named("gray16", 0x292929);
assert_color_parse_named("gray17", 0x2b2b2b);
assert_color_parse_named("gray18", 0x2e2e2e);
assert_color_parse_named("gray19", 0x303030);
assert_color_parse_named("gray2", 0x050505);
assert_color_parse_named("gray20", 0x333333);
assert_color_parse_named("gray21", 0x363636);
assert_color_parse_named("gray22", 0x383838);
assert_color_parse_named("gray23", 0x3b3b3b);
assert_color_parse_named("gray24", 0x3d3d3d);
assert_color_parse_named("gray25", 0x404040);
assert_color_parse_named("gray26", 0x424242);
assert_color_parse_named("gray27", 0x454545);
assert_color_parse_named("gray28", 0x474747);
assert_color_parse_named("gray29", 0x4a4a4a);
assert_color_parse_named("gray3", 0x080808);
assert_color_parse_named("gray30", 0x4d4d4d);
assert_color_parse_named("gray31", 0x4f4f4f);
assert_color_parse_named("gray32", 0x525252);
assert_color_parse_named("gray33", 0x545454);
assert_color_parse_named("gray34", 0x575757);
assert_color_parse_named("gray35", 0x595959);
assert_color_parse_named("gray36", 0x5c5c5c);
assert_color_parse_named("gray37", 0x5e5e5e);
assert_color_parse_named("gray38", 0x616161);
assert_color_parse_named("gray39", 0x636363);
assert_color_parse_named("gray4", 0x0a0a0a);
assert_color_parse_named("gray40", 0x666666);
assert_color_parse_named("gray41", 0x696969);
assert_color_parse_named("gray42", 0x6b6b6b);
assert_color_parse_named("gray43", 0x6e6e6e);
assert_color_parse_named("gray44", 0x707070);
assert_color_parse_named("gray45", 0x737373);
assert_color_parse_named("gray46", 0x757575);
assert_color_parse_named("gray47", 0x787878);
assert_color_parse_named("gray48", 0x7a7a7a);
assert_color_parse_named("gray49", 0x7d7d7d);
assert_color_parse_named("gray5", 0x0d0d0d);
assert_color_parse_named("gray50", 0x7f7f7f);
assert_color_parse_named("gray51", 0x828282);
assert_color_parse_named("gray52", 0x858585);
assert_color_parse_named("gray53", 0x878787);
assert_color_parse_named("gray54", 0x8a8a8a);
assert_color_parse_named("gray55", 0x8c8c8c);
assert_color_parse_named("gray56", 0x8f8f8f);
assert_color_parse_named("gray57", 0x919191);
assert_color_parse_named("gray58", 0x949494);
assert_color_parse_named("gray59", 0x969696);
assert_color_parse_named("gray6", 0x0f0f0f);
assert_color_parse_named("gray60", 0x999999);
assert_color_parse_named("gray61", 0x9c9c9c);
assert_color_parse_named("gray62", 0x9e9e9e);
assert_color_parse_named("gray63", 0xa1a1a1);
assert_color_parse_named("gray64", 0xa3a3a3);
assert_color_parse_named("gray65", 0xa6a6a6);
assert_color_parse_named("gray66", 0xa8a8a8);
assert_color_parse_named("gray67", 0xababab);
assert_color_parse_named("gray68", 0xadadad);
assert_color_parse_named("gray69", 0xb0b0b0);
assert_color_parse_named("gray7", 0x121212);
assert_color_parse_named("gray70", 0xb3b3b3);
assert_color_parse_named("gray71", 0xb5b5b5);
assert_color_parse_named("gray72", 0xb8b8b8);
assert_color_parse_named("gray73", 0xbababa);
assert_color_parse_named("gray74", 0xbdbdbd);
assert_color_parse_named("gray75", 0xbfbfbf);
assert_color_parse_named("gray76", 0xc2c2c2);
assert_color_parse_named("gray77", 0xc4c4c4);
assert_color_parse_named("gray78", 0xc7c7c7);
assert_color_parse_named("gray79", 0xc9c9c9);
assert_color_parse_named("gray8", 0x141414);
assert_color_parse_named("gray80", 0xcccccc);
assert_color_parse_named("gray81", 0xcfcfcf);
assert_color_parse_named("gray82", 0xd1d1d1);
assert_color_parse_named("gray83", 0xd4d4d4);
assert_color_parse_named("gray84", 0xd6d6d6);
assert_color_parse_named("gray85", 0xd9d9d9);
assert_color_parse_named("gray86", 0xdbdbdb);
assert_color_parse_named("gray87", 0xdedede);
assert_color_parse_named("gray88", 0xe0e0e0);
assert_color_parse_named("gray89", 0xe3e3e3);
assert_color_parse_named("gray9", 0x171717);
assert_color_parse_named("gray90", 0xe5e5e5);
assert_color_parse_named("gray91", 0xe8e8e8);
assert_color_parse_named("gray92", 0xebebeb);
assert_color_parse_named("gray93", 0xededed);
assert_color_parse_named("gray94", 0xf0f0f0);
assert_color_parse_named("gray95", 0xf2f2f2);
assert_color_parse_named("gray96", 0xf5f5f5);
assert_color_parse_named("gray97", 0xf7f7f7);
assert_color_parse_named("gray98", 0xfafafa);
assert_color_parse_named("gray99", 0xfcfcfc);
assert_color_parse_named("green", 0x00ff00);
assert_color_parse_named("green1", 0x00ff00);
assert_color_parse_named("green2", 0x00ee00);
assert_color_parse_named("green3", 0x00cd00);
assert_color_parse_named("green4", 0x008b00);
assert_color_parse_named("green yellow", 0xadff2f);
assert_color_parse_named("GreenYellow", 0xadff2f);
assert_color_parse_named("grey", 0xbebebe);
assert_color_parse_named("grey0", 0x000000);
assert_color_parse_named("grey1", 0x030303);
assert_color_parse_named("grey10", 0x1a1a1a);
assert_color_parse_named("grey100", 0xffffff);
assert_color_parse_named("grey11", 0x1c1c1c);
assert_color_parse_named("grey12", 0x1f1f1f);
assert_color_parse_named("grey13", 0x212121);
assert_color_parse_named("grey14", 0x242424);
assert_color_parse_named("grey15", 0x262626);
assert_color_parse_named("grey16", 0x292929);
assert_color_parse_named("grey17", 0x2b2b2b);
assert_color_parse_named("grey18", 0x2e2e2e);
assert_color_parse_named("grey19", 0x303030);
assert_color_parse_named("grey2", 0x050505);
assert_color_parse_named("grey20", 0x333333);
assert_color_parse_named("grey21", 0x363636);
assert_color_parse_named("grey22", 0x383838);
assert_color_parse_named("grey23", 0x3b3b3b);
assert_color_parse_named("grey24", 0x3d3d3d);
assert_color_parse_named("grey25", 0x404040);
assert_color_parse_named("grey26", 0x424242);
assert_color_parse_named("grey27", 0x454545);
assert_color_parse_named("grey28", 0x474747);
assert_color_parse_named("grey29", 0x4a4a4a);
assert_color_parse_named("grey3", 0x080808);
assert_color_parse_named("grey30", 0x4d4d4d);
assert_color_parse_named("grey31", 0x4f4f4f);
assert_color_parse_named("grey32", 0x525252);
assert_color_parse_named("grey33", 0x545454);
assert_color_parse_named("grey34", 0x575757);
assert_color_parse_named("grey35", 0x595959);
assert_color_parse_named("grey36", 0x5c5c5c);
assert_color_parse_named("grey37", 0x5e5e5e);
assert_color_parse_named("grey38", 0x616161);
assert_color_parse_named("grey39", 0x636363);
assert_color_parse_named("grey4", 0x0a0a0a);
assert_color_parse_named("grey40", 0x666666);
assert_color_parse_named("grey41", 0x696969);
assert_color_parse_named("grey42", 0x6b6b6b);
assert_color_parse_named("grey43", 0x6e6e6e);
assert_color_parse_named("grey44", 0x707070);
assert_color_parse_named("grey45", 0x737373);
assert_color_parse_named("grey46", 0x757575);
assert_color_parse_named("grey47", 0x787878);
assert_color_parse_named("grey48", 0x7a7a7a);
assert_color_parse_named("grey49", 0x7d7d7d);
assert_color_parse_named("grey5", 0x0d0d0d);
assert_color_parse_named("grey50", 0x7f7f7f);
assert_color_parse_named("grey51", 0x828282);
assert_color_parse_named("grey52", 0x858585);
assert_color_parse_named("grey53", 0x878787);
assert_color_parse_named("grey54", 0x8a8a8a);
assert_color_parse_named("grey55", 0x8c8c8c);
assert_color_parse_named("grey56", 0x8f8f8f);
assert_color_parse_named("grey57", 0x919191);
assert_color_parse_named("grey58", 0x949494);
assert_color_parse_named("grey59", 0x969696);
assert_color_parse_named("grey6", 0x0f0f0f);
assert_color_parse_named("grey60", 0x999999);
assert_color_parse_named("grey61", 0x9c9c9c);
assert_color_parse_named("grey62", 0x9e9e9e);
assert_color_parse_named("grey63", 0xa1a1a1);
assert_color_parse_named("grey64", 0xa3a3a3);
assert_color_parse_named("grey65", 0xa6a6a6);
assert_color_parse_named("grey66", 0xa8a8a8);
assert_color_parse_named("grey67", 0xababab);
assert_color_parse_named("grey68", 0xadadad);
assert_color_parse_named("grey69", 0xb0b0b0);
assert_color_parse_named("grey7", 0x121212);
assert_color_parse_named("grey70", 0xb3b3b3);
assert_color_parse_named("grey71", 0xb5b5b5);
assert_color_parse_named("grey72", 0xb8b8b8);
assert_color_parse_named("grey73", 0xbababa);
assert_color_parse_named("grey74", 0xbdbdbd);
assert_color_parse_named("grey75", 0xbfbfbf);
assert_color_parse_named("grey76", 0xc2c2c2);
assert_color_parse_named("grey77", 0xc4c4c4);
assert_color_parse_named("grey78", 0xc7c7c7);
assert_color_parse_named("grey79", 0xc9c9c9);
assert_color_parse_named("grey8", 0x141414);
assert_color_parse_named("grey80", 0xcccccc);
assert_color_parse_named("grey81", 0xcfcfcf);
assert_color_parse_named("grey82", 0xd1d1d1);
assert_color_parse_named("grey83", 0xd4d4d4);
assert_color_parse_named("grey84", 0xd6d6d6);
assert_color_parse_named("grey85", 0xd9d9d9);
assert_color_parse_named("grey86", 0xdbdbdb);
assert_color_parse_named("grey87", 0xdedede);
assert_color_parse_named("grey88", 0xe0e0e0);
assert_color_parse_named("grey89", 0xe3e3e3);
assert_color_parse_named("grey9", 0x171717);
assert_color_parse_named("grey90", 0xe5e5e5);
assert_color_parse_named("grey91", 0xe8e8e8);
assert_color_parse_named("grey92", 0xebebeb);
assert_color_parse_named("grey93", 0xededed);
assert_color_parse_named("grey94", 0xf0f0f0);
assert_color_parse_named("grey95", 0xf2f2f2);
assert_color_parse_named("grey96", 0xf5f5f5);
assert_color_parse_named("grey97", 0xf7f7f7);
assert_color_parse_named("grey98", 0xfafafa);
assert_color_parse_named("grey99", 0xfcfcfc);
assert_color_parse_named("honeydew", 0xf0fff0);
assert_color_parse_named("honeydew1", 0xf0fff0);
assert_color_parse_named("honeydew2", 0xe0eee0);
assert_color_parse_named("honeydew3", 0xc1cdc1);
assert_color_parse_named("honeydew4", 0x838b83);
assert_color_parse_named("hot pink", 0xff69b4);
assert_color_parse_named("HotPink", 0xff69b4);
assert_color_parse_named("HotPink1", 0xff6eb4);
assert_color_parse_named("HotPink2", 0xee6aa7);
assert_color_parse_named("HotPink3", 0xcd6090);
assert_color_parse_named("HotPink4", 0x8b3a62);
assert_color_parse_named("indian red", 0xcd5c5c);
assert_color_parse_named("IndianRed", 0xcd5c5c);
assert_color_parse_named("IndianRed1", 0xff6a6a);
assert_color_parse_named("IndianRed2", 0xee6363);
assert_color_parse_named("IndianRed3", 0xcd5555);
assert_color_parse_named("IndianRed4", 0x8b3a3a);
assert_color_parse_named("indigo", 0x4b0082);
assert_color_parse_named("ivory", 0xfffff0);
assert_color_parse_named("ivory1", 0xfffff0);
assert_color_parse_named("ivory2", 0xeeeee0);
assert_color_parse_named("ivory3", 0xcdcdc1);
assert_color_parse_named("ivory4", 0x8b8b83);
assert_color_parse_named("khaki", 0xf0e68c);
assert_color_parse_named("khaki1", 0xfff68f);
assert_color_parse_named("khaki2", 0xeee685);
assert_color_parse_named("khaki3", 0xcdc673);
assert_color_parse_named("khaki4", 0x8b864e);
assert_color_parse_named("lavender", 0xe6e6fa);
assert_color_parse_named("lavender blush", 0xfff0f5);
assert_color_parse_named("LavenderBlush", 0xfff0f5);
assert_color_parse_named("LavenderBlush1", 0xfff0f5);
assert_color_parse_named("LavenderBlush2", 0xeee0e5);
assert_color_parse_named("LavenderBlush3", 0xcdc1c5);
assert_color_parse_named("LavenderBlush4", 0x8b8386);
assert_color_parse_named("lawn green", 0x7cfc00);
assert_color_parse_named("LawnGreen", 0x7cfc00);
assert_color_parse_named("lemon chiffon", 0xfffacd);
assert_color_parse_named("LemonChiffon", 0xfffacd);
assert_color_parse_named("LemonChiffon1", 0xfffacd);
assert_color_parse_named("LemonChiffon2", 0xeee9bf);
assert_color_parse_named("LemonChiffon3", 0xcdc9a5);
assert_color_parse_named("LemonChiffon4", 0x8b8970);
assert_color_parse_named("light blue", 0xadd8e6);
assert_color_parse_named("LightBlue", 0xadd8e6);
assert_color_parse_named("LightBlue1", 0xbfefff);
assert_color_parse_named("LightBlue2", 0xb2dfee);
assert_color_parse_named("LightBlue3", 0x9ac0cd);
assert_color_parse_named("LightBlue4", 0x68838b);
assert_color_parse_named("light coral", 0xf08080);
assert_color_parse_named("LightCoral", 0xf08080);
assert_color_parse_named("light cyan", 0xe0ffff);
assert_color_parse_named("LightCyan", 0xe0ffff);
assert_color_parse_named("LightCyan1", 0xe0ffff);
assert_color_parse_named("LightCyan2", 0xd1eeee);
assert_color_parse_named("LightCyan3", 0xb4cdcd);
assert_color_parse_named("LightCyan4", 0x7a8b8b);
assert_color_parse_named("light goldenrod", 0xeedd82);
assert_color_parse_named("LightGoldenrod", 0xeedd82);
assert_color_parse_named("LightGoldenrod1", 0xffec8b);
assert_color_parse_named("LightGoldenrod2", 0xeedc82);
assert_color_parse_named("LightGoldenrod3", 0xcdbe70);
assert_color_parse_named("LightGoldenrod4", 0x8b814c);
assert_color_parse_named("light goldenrod yellow", 0xfafad2);
assert_color_parse_named("LightGoldenrodYellow", 0xfafad2);
assert_color_parse_named("light gray", 0xd3d3d3);
assert_color_parse_named("LightGray", 0xd3d3d3);
assert_color_parse_named("light green", 0x90ee90);
assert_color_parse_named("LightGreen", 0x90ee90);
assert_color_parse_named("light grey", 0xd3d3d3);
assert_color_parse_named("LightGrey", 0xd3d3d3);
assert_color_parse_named("light pink", 0xffb6c1);
assert_color_parse_named("LightPink", 0xffb6c1);
assert_color_parse_named("LightPink1", 0xffaeb9);
assert_color_parse_named("LightPink2", 0xeea2ad);
assert_color_parse_named("LightPink3", 0xcd8c95);
assert_color_parse_named("LightPink4", 0x8b5f65);
assert_color_parse_named("light salmon", 0xffa07a);
assert_color_parse_named("LightSalmon", 0xffa07a);
assert_color_parse_named("LightSalmon1", 0xffa07a);
assert_color_parse_named("LightSalmon2", 0xee9572);
assert_color_parse_named("LightSalmon3", 0xcd8162);
assert_color_parse_named("LightSalmon4", 0x8b5742);
assert_color_parse_named("light sea green", 0x20b2aa);
assert_color_parse_named("LightSeaGreen", 0x20b2aa);
assert_color_parse_named("light sky blue", 0x87cefa);
assert_color_parse_named("LightSkyBlue", 0x87cefa);
assert_color_parse_named("LightSkyBlue1", 0xb0e2ff);
assert_color_parse_named("LightSkyBlue2", 0xa4d3ee);
assert_color_parse_named("LightSkyBlue3", 0x8db6cd);
assert_color_parse_named("LightSkyBlue4", 0x607b8b);
assert_color_parse_named("light slate blue", 0x8470ff);
assert_color_parse_named("LightSlateBlue", 0x8470ff);
assert_color_parse_named("light slate gray", 0x778899);
assert_color_parse_named("LightSlateGray", 0x778899);
assert_color_parse_named("light slate grey", 0x778899);
assert_color_parse_named("LightSlateGrey", 0x778899);
assert_color_parse_named("light steel blue", 0xb0c4de);
assert_color_parse_named("LightSteelBlue", 0xb0c4de);
assert_color_parse_named("LightSteelBlue1", 0xcae1ff);
assert_color_parse_named("LightSteelBlue2", 0xbcd2ee);
assert_color_parse_named("LightSteelBlue3", 0xa2b5cd);
assert_color_parse_named("LightSteelBlue4", 0x6e7b8b);
assert_color_parse_named("light yellow", 0xffffe0);
assert_color_parse_named("LightYellow", 0xffffe0);
assert_color_parse_named("LightYellow1", 0xffffe0);
assert_color_parse_named("LightYellow2", 0xeeeed1);
assert_color_parse_named("LightYellow3", 0xcdcdb4);
assert_color_parse_named("LightYellow4", 0x8b8b7a);
assert_color_parse_named("lime", 0x00ff00);
assert_color_parse_named("lime green", 0x32cd32);
assert_color_parse_named("LimeGreen", 0x32cd32);
assert_color_parse_named("linen", 0xfaf0e6);
assert_color_parse_named("magenta", 0xff00ff);
assert_color_parse_named("magenta1", 0xff00ff);
assert_color_parse_named("magenta2", 0xee00ee);
assert_color_parse_named("magenta3", 0xcd00cd);
assert_color_parse_named("magenta4", 0x8b008b);
assert_color_parse_named("maroon", 0xb03060);
assert_color_parse_named("maroon1", 0xff34b3);
assert_color_parse_named("maroon2", 0xee30a7);
assert_color_parse_named("maroon3", 0xcd2990);
assert_color_parse_named("maroon4", 0x8b1c62);
assert_color_parse_named("medium aquamarine", 0x66cdaa);
assert_color_parse_named("MediumAquamarine", 0x66cdaa);
assert_color_parse_named("medium blue", 0x0000cd);
assert_color_parse_named("MediumBlue", 0x0000cd);
assert_color_parse_named("medium orchid", 0xba55d3);
assert_color_parse_named("MediumOrchid", 0xba55d3);
assert_color_parse_named("MediumOrchid1", 0xe066ff);
assert_color_parse_named("MediumOrchid2", 0xd15fee);
assert_color_parse_named("MediumOrchid3", 0xb452cd);
assert_color_parse_named("MediumOrchid4", 0x7a378b);
assert_color_parse_named("medium purple", 0x9370db);
assert_color_parse_named("MediumPurple", 0x9370db);
assert_color_parse_named("MediumPurple1", 0xab82ff);
assert_color_parse_named("MediumPurple2", 0x9f79ee);
assert_color_parse_named("MediumPurple3", 0x8968cd);
assert_color_parse_named("MediumPurple4", 0x5d478b);
assert_color_parse_named("medium sea green", 0x3cb371);
assert_color_parse_named("MediumSeaGreen", 0x3cb371);
assert_color_parse_named("medium slate blue", 0x7b68ee);
assert_color_parse_named("MediumSlateBlue", 0x7b68ee);
assert_color_parse_named("medium spring green", 0x00fa9a);
assert_color_parse_named("MediumSpringGreen", 0x00fa9a);
assert_color_parse_named("medium turquoise", 0x48d1cc);
assert_color_parse_named("MediumTurquoise", 0x48d1cc);
assert_color_parse_named("medium violet red", 0xc71585);
assert_color_parse_named("MediumVioletRed", 0xc71585);
assert_color_parse_named("midnight blue", 0x191970);
assert_color_parse_named("MidnightBlue", 0x191970);
assert_color_parse_named("mint cream", 0xf5fffa);
assert_color_parse_named("MintCream", 0xf5fffa);
assert_color_parse_named("misty rose", 0xffe4e1);
assert_color_parse_named("MistyRose", 0xffe4e1);
assert_color_parse_named("MistyRose1", 0xffe4e1);
assert_color_parse_named("MistyRose2", 0xeed5d2);
assert_color_parse_named("MistyRose3", 0xcdb7b5);
assert_color_parse_named("MistyRose4", 0x8b7d7b);
assert_color_parse_named("moccasin", 0xffe4b5);
assert_color_parse_named("navajo white", 0xffdead);
assert_color_parse_named("NavajoWhite", 0xffdead);
assert_color_parse_named("NavajoWhite1", 0xffdead);
assert_color_parse_named("NavajoWhite2", 0xeecfa1);
assert_color_parse_named("NavajoWhite3", 0xcdb38b);
assert_color_parse_named("NavajoWhite4", 0x8b795e);
assert_color_parse_named("navy", 0x000080);
assert_color_parse_named("navy blue", 0x000080);
assert_color_parse_named("NavyBlue", 0x000080);
assert_color_parse_named("old lace", 0xfdf5e6);
assert_color_parse_named("OldLace", 0xfdf5e6);
assert_color_parse_named("olive", 0x808000);
assert_color_parse_named("olive drab", 0x6b8e23);
assert_color_parse_named("OliveDrab", 0x6b8e23);
assert_color_parse_named("OliveDrab1", 0xc0ff3e);
assert_color_parse_named("OliveDrab2", 0xb3ee3a);
assert_color_parse_named("OliveDrab3", 0x9acd32);
assert_color_parse_named("OliveDrab4", 0x698b22);
assert_color_parse_named("orange", 0xffa500);
assert_color_parse_named("orange1", 0xffa500);
assert_color_parse_named("orange2", 0xee9a00);
assert_color_parse_named("orange3", 0xcd8500);
assert_color_parse_named("orange4", 0x8b5a00);
assert_color_parse_named("orange red", 0xff4500);
assert_color_parse_named("OrangeRed", 0xff4500);
assert_color_parse_named("OrangeRed1", 0xff4500);
assert_color_parse_named("OrangeRed2", 0xee4000);
assert_color_parse_named("OrangeRed3", 0xcd3700);
assert_color_parse_named("OrangeRed4", 0x8b2500);
assert_color_parse_named("orchid", 0xda70d6);
assert_color_parse_named("orchid1", 0xff83fa);
assert_color_parse_named("orchid2", 0xee7ae9);
assert_color_parse_named("orchid3", 0xcd69c9);
assert_color_parse_named("orchid4", 0x8b4789);
assert_color_parse_named("pale goldenrod", 0xeee8aa);
assert_color_parse_named("PaleGoldenrod", 0xeee8aa);
assert_color_parse_named("pale green", 0x98fb98);
assert_color_parse_named("PaleGreen", 0x98fb98);
assert_color_parse_named("PaleGreen1", 0x9aff9a);
assert_color_parse_named("PaleGreen2", 0x90ee90);
assert_color_parse_named("PaleGreen3", 0x7ccd7c);
assert_color_parse_named("PaleGreen4", 0x548b54);
assert_color_parse_named("pale turquoise", 0xafeeee);
assert_color_parse_named("PaleTurquoise", 0xafeeee);
assert_color_parse_named("PaleTurquoise1", 0xbbffff);
assert_color_parse_named("PaleTurquoise2", 0xaeeeee);
assert_color_parse_named("PaleTurquoise3", 0x96cdcd);
assert_color_parse_named("PaleTurquoise4", 0x668b8b);
assert_color_parse_named("pale violet red", 0xdb7093);
assert_color_parse_named("PaleVioletRed", 0xdb7093);
assert_color_parse_named("PaleVioletRed1", 0xff82ab);
assert_color_parse_named("PaleVioletRed2", 0xee799f);
assert_color_parse_named("PaleVioletRed3", 0xcd6889);
assert_color_parse_named("PaleVioletRed4", 0x8b475d);
assert_color_parse_named("papaya whip", 0xffefd5);
assert_color_parse_named("PapayaWhip", 0xffefd5);
assert_color_parse_named("peach puff", 0xffdab9);
assert_color_parse_named("PeachPuff", 0xffdab9);
assert_color_parse_named("PeachPuff1", 0xffdab9);
assert_color_parse_named("PeachPuff2", 0xeecbad);
assert_color_parse_named("PeachPuff3", 0xcdaf95);
assert_color_parse_named("PeachPuff4", 0x8b7765);
assert_color_parse_named("peru", 0xcd853f);
assert_color_parse_named("pink", 0xffc0cb);
assert_color_parse_named("pink1", 0xffb5c5);
assert_color_parse_named("pink2", 0xeea9b8);
assert_color_parse_named("pink3", 0xcd919e);
assert_color_parse_named("pink4", 0x8b636c);
assert_color_parse_named("plum", 0xdda0dd);
assert_color_parse_named("plum1", 0xffbbff);
assert_color_parse_named("plum2", 0xeeaeee);
assert_color_parse_named("plum3", 0xcd96cd);
assert_color_parse_named("plum4", 0x8b668b);
assert_color_parse_named("powder blue", 0xb0e0e6);
assert_color_parse_named("PowderBlue", 0xb0e0e6);
assert_color_parse_named("purple", 0xa020f0);
assert_color_parse_named("purple1", 0x9b30ff);
assert_color_parse_named("purple2", 0x912cee);
assert_color_parse_named("purple3", 0x7d26cd);
assert_color_parse_named("purple4", 0x551a8b);
assert_color_parse_named("rebecca purple", 0x663399);
assert_color_parse_named("RebeccaPurple", 0x663399);
assert_color_parse_named("red", 0xff0000);
assert_color_parse_named("red1", 0xff0000);
assert_color_parse_named("red2", 0xee0000);
assert_color_parse_named("red3", 0xcd0000);
assert_color_parse_named("red4", 0x8b0000);
assert_color_parse_named("rosy brown", 0xbc8f8f);
assert_color_parse_named("RosyBrown", 0xbc8f8f);
assert_color_parse_named("RosyBrown1", 0xffc1c1);
assert_color_parse_named("RosyBrown2", 0xeeb4b4);
assert_color_parse_named("RosyBrown3", 0xcd9b9b);
assert_color_parse_named("RosyBrown4", 0x8b6969);
assert_color_parse_named("royal blue", 0x4169e1);
assert_color_parse_named("RoyalBlue", 0x4169e1);
assert_color_parse_named("RoyalBlue1", 0x4876ff);
assert_color_parse_named("RoyalBlue2", 0x436eee);
assert_color_parse_named("RoyalBlue3", 0x3a5fcd);
assert_color_parse_named("RoyalBlue4", 0x27408b);
assert_color_parse_named("saddle brown", 0x8b4513);
assert_color_parse_named("SaddleBrown", 0x8b4513);
assert_color_parse_named("salmon", 0xfa8072);
assert_color_parse_named("salmon1", 0xff8c69);
assert_color_parse_named("salmon2", 0xee8262);
assert_color_parse_named("salmon3", 0xcd7054);
assert_color_parse_named("salmon4", 0x8b4c39);
assert_color_parse_named("sandy brown", 0xf4a460);
assert_color_parse_named("SandyBrown", 0xf4a460);
assert_color_parse_named("sea green", 0x2e8b57);
assert_color_parse_named("SeaGreen", 0x2e8b57);
assert_color_parse_named("SeaGreen1", 0x54ff9f);
assert_color_parse_named("SeaGreen2", 0x4eee94);
assert_color_parse_named("SeaGreen3", 0x43cd80);
assert_color_parse_named("SeaGreen4", 0x2e8b57);
assert_color_parse_named("seashell", 0xfff5ee);
assert_color_parse_named("seashell1", 0xfff5ee);
assert_color_parse_named("seashell2", 0xeee5de);
assert_color_parse_named("seashell3", 0xcdc5bf);
assert_color_parse_named("seashell4", 0x8b8682);
assert_color_parse_named("sienna", 0xa0522d);
assert_color_parse_named("sienna1", 0xff8247);
assert_color_parse_named("sienna2", 0xee7942);
assert_color_parse_named("sienna3", 0xcd6839);
assert_color_parse_named("sienna4", 0x8b4726);
assert_color_parse_named("silver", 0xc0c0c0);
assert_color_parse_named("sky blue", 0x87ceeb);
assert_color_parse_named("SkyBlue", 0x87ceeb);
assert_color_parse_named("SkyBlue1", 0x87ceff);
assert_color_parse_named("SkyBlue2", 0x7ec0ee);
assert_color_parse_named("SkyBlue3", 0x6ca6cd);
assert_color_parse_named("SkyBlue4", 0x4a708b);
assert_color_parse_named("slate blue", 0x6a5acd);
assert_color_parse_named("SlateBlue", 0x6a5acd);
assert_color_parse_named("SlateBlue1", 0x836fff);
assert_color_parse_named("SlateBlue2", 0x7a67ee);
assert_color_parse_named("SlateBlue3", 0x6959cd);
assert_color_parse_named("SlateBlue4", 0x473c8b);
assert_color_parse_named("slate gray", 0x708090);
assert_color_parse_named("SlateGray", 0x708090);
assert_color_parse_named("SlateGray1", 0xc6e2ff);
assert_color_parse_named("SlateGray2", 0xb9d3ee);
assert_color_parse_named("SlateGray3", 0x9fb6cd);
assert_color_parse_named("SlateGray4", 0x6c7b8b);
assert_color_parse_named("slate grey", 0x708090);
assert_color_parse_named("SlateGrey", 0x708090);
assert_color_parse_named("snow", 0xfffafa);
assert_color_parse_named("snow1", 0xfffafa);
assert_color_parse_named("snow2", 0xeee9e9);
assert_color_parse_named("snow3", 0xcdc9c9);
assert_color_parse_named("snow4", 0x8b8989);
assert_color_parse_named("spring green", 0x00ff7f);
assert_color_parse_named("SpringGreen", 0x00ff7f);
assert_color_parse_named("SpringGreen1", 0x00ff7f);
assert_color_parse_named("SpringGreen2", 0x00ee76);
assert_color_parse_named("SpringGreen3", 0x00cd66);
assert_color_parse_named("SpringGreen4", 0x008b45);
assert_color_parse_named("steel blue", 0x4682b4);
assert_color_parse_named("SteelBlue", 0x4682b4);
assert_color_parse_named("SteelBlue1", 0x63b8ff);
assert_color_parse_named("SteelBlue2", 0x5cacee);
assert_color_parse_named("SteelBlue3", 0x4f94cd);
assert_color_parse_named("SteelBlue4", 0x36648b);
assert_color_parse_named("tan", 0xd2b48c);
assert_color_parse_named("tan1", 0xffa54f);
assert_color_parse_named("tan2", 0xee9a49);
assert_color_parse_named("tan3", 0xcd853f);
assert_color_parse_named("tan4", 0x8b5a2b);
assert_color_parse_named("teal", 0x008080);
assert_color_parse_named("thistle", 0xd8bfd8);
assert_color_parse_named("thistle1", 0xffe1ff);
assert_color_parse_named("thistle2", 0xeed2ee);
assert_color_parse_named("thistle3", 0xcdb5cd);
assert_color_parse_named("thistle4", 0x8b7b8b);
assert_color_parse_named("tomato", 0xff6347);
assert_color_parse_named("tomato1", 0xff6347);
assert_color_parse_named("tomato2", 0xee5c42);
assert_color_parse_named("tomato3", 0xcd4f39);
assert_color_parse_named("tomato4", 0x8b3626);
assert_color_parse_named("turquoise", 0x40e0d0);
assert_color_parse_named("turquoise1", 0x00f5ff);
assert_color_parse_named("turquoise2", 0x00e5ee);
assert_color_parse_named("turquoise3", 0x00c5cd);
assert_color_parse_named("turquoise4", 0x00868b);
assert_color_parse_named("violet", 0xee82ee);
assert_color_parse_named("violet red", 0xd02090);
assert_color_parse_named("VioletRed", 0xd02090);
assert_color_parse_named("VioletRed1", 0xff3e96);
assert_color_parse_named("VioletRed2", 0xee3a8c);
assert_color_parse_named("VioletRed3", 0xcd3278);
assert_color_parse_named("VioletRed4", 0x8b2252);
assert_color_parse_named("web gray", 0x808080);
assert_color_parse_named("WebGray", 0x808080);
assert_color_parse_named("web green", 0x008000);
assert_color_parse_named("WebGreen", 0x008000);
assert_color_parse_named("web grey", 0x808080);
assert_color_parse_named("WebGrey", 0x808080);
assert_color_parse_named("web maroon", 0x800000);
assert_color_parse_named("WebMaroon", 0x800000);
assert_color_parse_named("web purple", 0x800080);
assert_color_parse_named("WebPurple", 0x800080);
assert_color_parse_named("wheat", 0xf5deb3);
assert_color_parse_named("wheat1", 0xffe7ba);
assert_color_parse_named("wheat2", 0xeed8ae);
assert_color_parse_named("wheat3", 0xcdba96);
assert_color_parse_named("wheat4", 0x8b7e66);
assert_color_parse_named("white", 0xffffff);
assert_color_parse_named("white smoke", 0xf5f5f5);
assert_color_parse_named("WhiteSmoke", 0xf5f5f5);
assert_color_parse_named("x11 gray", 0xbebebe);
assert_color_parse_named("X11Gray", 0xbebebe);
assert_color_parse_named("x11 green", 0x00ff00);
assert_color_parse_named("X11Green", 0x00ff00);
assert_color_parse_named("x11 grey", 0xbebebe);
assert_color_parse_named("X11Grey", 0xbebebe);
assert_color_parse_named("x11 maroon", 0xb03060);
assert_color_parse_named("X11Maroon", 0xb03060);
assert_color_parse_named("x11 purple", 0xa020f0);
assert_color_parse_named("X11Purple", 0xa020f0);
assert_color_parse_named("yellow", 0xffff00);
assert_color_parse_named("yellow1", 0xffff00);
assert_color_parse_named("yellow2", 0xeeee00);
assert_color_parse_named("yellow3", 0xcdcd00);
assert_color_parse_named("yellow4", 0x8b8b00);
assert_color_parse_named("yellow green", 0x9acd32);
assert_color_parse_named("YellowGreen", 0x9acd32);


