.\" dpkg manual page - dpkg-gensymbols(1)
.\"
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2009-2010 Modestas Vainius <modestas@vainius.eu>
.\" Copyright © 2012-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gensymbols 1 %RELEASE_DATE% %VERSION% Dpkg\-sviten
.nh
.SH NAMN
dpkg\-gensymbols \- generera symbolfiler (information om delade bibliotek)
.
.SH SYNOPS
\fBdpkg\-gensymbols\fP [\fIflagga\fP...]
.
.SH BESKRIVNING
\fBdpkg\-gensymbols\fP söker genom en temporärt byggträd (som standard
debian/tmp) efter bibliotek och skapar en \fIsymbols\fP\-fil som beskriver
dem. Denna fil kommer sedan, såvida den inte är tom, att installeras i
DEBIAN\-underkatalogen i byggträdet så att den hamnar i styrinformationen i
paketet.
.P
När dessa filer skapas, används ett par symbolfiler från paketansvariga som
indata. Programmet söker efter följande filer (och använder den första det
finner):
.IP • 4
debian/\fIpaket\fP.symbols.\fIarkitektur\fP
.IP • 4
debian/symbols.\fIarkitektur\fP
.IP • 4
debian/\fIpaket\fP.symbols
.IP • 4
debian/symbols
.P
Dessa filer är i huvudsak intressanta för att kunna tillhandahålla den
minimala version associerad med varje symbol i biblioteken. Detta motsvarar
normalt den första version av paketet som tillhandahöll symbolen, men det
kan manuellt inkrementeras av de ansvariga om symbolens ABI utökas med
bibehållen bakåtkompatibilitet. Det är den ansvarigas ansvar att hålla dessa
filer àjourförda och korrekta, men \fBdpkg\-gensymbols\fP kan hjälpa till med
detta.
.P
När den genererade symbolfilen skiljer sig mot den version som
tillhandahållits av de paketansvariga kommer \fBdpkg\-gensymbols\fP att skriva
ut en differens mellan de två versionerna. Om ändringarna är för stora
kommer programmet dessutom att misslyckas (du kan justera hur stora
ändringar du kan tolerera, se flaggan \fB\-c\fP).
.SH "UNDERHÅLLA SYMBOLFILER"
The symbols files are really useful only if they reflect the evolution of
the package through several releases. Thus the maintainer has to update them
every time that a new symbol is added so that its associated minimal version
matches reality.  The diffs contained in the build logs can be used as a
starting point, but the maintainer, additionally, has to make sure that the
behaviour of those symbols has not changed in a way that would make anything
using those symbols and linking against the new version, stop working with
the old version.  In most cases, the diff applies directly to the
debian/\fIpackage\fP.symbols file. That said, further tweaks are usually
needed: it's recommended for example to drop the Debian revision from the
minimal version so that backports with a lower version number but the same
upstream version still satisfy the generated dependencies.  If the Debian
revision can't be dropped because the symbol really got added by the Debian
specific change, then one should suffix the version with ‘\fB~\fP’.
.P
Innan man applicerar en patch på symbolfilen bör de ansvariga dubbelchecka
att den är korrekt. Publicerade symboler bör inte försvinna, så patchen bör
ideellt sett bara lägga till nya rader.
.P
Note that you can put comments in symbols files: any line with ‘#’ as the
first character is a comment except if it starts with ‘#include’ (see
section \fBUsing includes\fP).  Lines starting with ‘#MISSING:’ are special
comments documenting symbols that have disappeared.
.P
Glöm inte att kontrollera om de gamla symbolversionerna måste ökas. Det
finns inget sätt för \fBdpkg\-gensymbols\fP att varna om detta. Att blint
applicera diffen eller utgå från att inget har ändrats om diffen är tom,
utan att se efter sådana ändringar, kan leda till att paket med lösa
beroenden kan deklarera att de fungerar med äldre paket de inte kan fungera
tillsammans med. Detta kommer introducera svårfunna problem vid (delvisa)
uppgraderingar.{
.SS "Använda #PACKAGE#\-substituering"
.P
I några sällsynta fall skiljer sig namnet på biblioteket mellan
arkitekturer. För att undvika att hårdkoda namnet på paketet i symbolfilen
kan du använda markören \fI#PACKAGE#\fP. Den ersätts av det faktiska
paketnamnet när symbolfilen installeras. Till skillnad från
\fI#MINVER#\fP\-markören kommer \fI#PACKAGE#\fP aldrig att dyka upp i en symbolfil
i ett binärpaket.
.SS "Använda symboltaggar"
.P
Symboltaggning är nyttigt för att markera symboler som är speciella på något
sätt. Alla symboler kan ha ett godtyckligt antal taggar associerade med
sig. Medan alla taggar tolkas och lagras är det bara ett par av dem som
förstås av \fBdpkg\-gensymbols\fP och som utlöser specialhantering av
symbolerna. Se undersymbolen \fBStandardsymboltaggar\fP för mer information om
dessa taggar.
.P
Taggarna anges precis före symbolnamnet (inga blanksteg tillåts mellan). Den
börjar alltid med en vänsterparentes \fB(\fP, slutar med en högerparentes \fB)\fP,
och måste innehålla minst en tagg. Ytterligare taggar avdelas med tecknet
\fB|\fP. En tagg kan ha ett värde, vilket separeras från taggnamnet med tecknet
\fB=\fP. Taggnamn och värden kan vara godtyckliga strängar, förutom att de inte
kan innehålla de speciella tecknen \fB)\fP \fB|\fP \fB=\fP. Symbolnamn som följer en
taggangivelse kan, om så önskas, citeras med antingen \fB'\fP eller \fB"\fP för
att tillåta blanksteg. Om inga taggar anges för symbolen tolkas dock
citattecken som en del av symbolnamnet, vilket fortsätter till det första
blanksteget.
.P
 (tag1=jag är markerad|taggnamn med blanksteg)"taggad citerad symbol"@Bas 1.0
 (optional)taggad_ociterad_symbol@Bas 1.0 1
 ociterad_symbol@Bas 1.0
.P
Den första symbolen i exemplet är heter \fItaggad citerad symbol\fP och har två
taggar: \fItag1\fP med värdet \fIjag är markerad\fP och \fItaggnamn med blanksteg\fP
som inte har något värde. Den andra symbolen heter \fItaggad_ociterad_symbol\fP
och är bara taggad med taggen som heter \fIoptional\fP. Den sista symbolen är
ett exempel på en normal, otaggad symbol.
.P
Eftersom symboltaggar er en utökning av formatet i \fIdeb\-symbols(5)\fP kan de
bara användas i symbolfiler i källkodspaket (dessa filer är att anse som
mallar som används för att bygga symbolfilerna som finns i
binärpaketen). När \fBdpkg\-gensymbols\fP anropas utan flaggan \fB\-t\fP kommer det
att mata ut symbolfiler kompatibla med \fBdeb\-symbols\fP(5)\-formatet: det
hanterar symboler helt beroende på vad som beskrivs av standardtaggarna och
tar bort alla taggar från utdata. I mall\-läge (\fB\-t\fP) kommer däremot alla
symboler och deras taggar (både standard och okända) att behållas i utdata
och skrivas i sin originalform så som de lästes in.
.SS Standardsymboltaggar
.TP 
\fBoptional\fP
A symbol marked as optional can disappear from the library at any time and
that will never cause \fBdpkg\-gensymbols\fP to fail. However, disappeared
optional symbols will continuously appear as MISSING in the diff in each new
package revision.  This behaviour serves as a reminder for the maintainer
that such a symbol needs to be removed from the symbol file or readded to
the library. When the optional symbol, which was previously declared as
MISSING, suddenly reappears in the next revision, it will be upgraded back
to the “existing” status with its minimum version unchanged.

Taggen är användbar för symboler som är privata och vars försvinnande inte
gör att ABI:et går sönder. De flesta C++\-mallinstansieringar faller till
exempel in under denna kategori. Som andra taggar kan den här även ha ett
godtyckligt värde: det kan användas för att indikera varför symbolen är att
anse som valfri.
.TP 
\fBarch=\fP\fIarchitecture\-list\fP
.TQ
\fBarch\-bits=\fP\fIarchitecture\-bits\fP
.TQ
\fBarch\-endian=\fP\fIarchitecture\-endianness\fP
These tags allow one to restrict the set of architectures where the symbol
is supposed to exist. The \fBarch\-bits\fP and \fBarch\-endian\fP tags are supported
since dpkg 1.18.0. When the symbols list is updated with the symbols
discovered in the library, all arch\-specific symbols which do not concern
the current host architecture are treated as if they did not exist. If an
arch\-specific symbol matching the current host architecture does not exist
in the library, normal procedures for missing symbols apply and it may cause
\fBdpkg\-gensymbols\fP to fail. On the other hand, if the arch\-specific symbol
is found when it was not supposed to exist (because the current host
architecture is not listed in the tag or does not match the endianness and
bits), it is made arch neutral (i.e. the arch, arch\-bits and arch\-endian
tags are dropped and the symbol will appear in the diff due to this change),
but it is not considered as new.

I det vanliga icke\-mall\-läget skrivs endast de arkitekturspecifika symboler
som motsvarar den aktuella värdarkitekturen till symbolfilen. Å andra sidan
skrivs alla arkitekturspecifika symboler (inklusive de från andra
arkitekturer) till symbolfilen i mall\-läget.

The format of \fIarchitecture\-list\fP is the same as the one used in the
\fBBuild\-Depends\fP field of \fIdebian/control\fP (except the enclosing square
brackets []). For example, the first symbol from the list below will be
considered only on alpha, any\-amd64 and ia64 architectures, the second only
on linux architectures, while the third one anywhere except on armel.

 (arch=alpha any\-amd64 ia64)64bit_specific_symbol@Base 1.0
 (arch=linux\-any)linux_specific_symbol@Base 1.0
 (arch=!armel)symbol_armel_does_not_have@Base 1.0

The \fIarchitecture\-bits\fP is either \fB32\fP or \fB64\fP.

 (arch\-bits=32)32bit_specific_symbol@Base 1.0
 (arch\-bits=64)64bit_specific_symbol@Base 1.0

The \fIarchitecture\-endianness\fP is either \fBlittle\fP or \fBbig\fP.

 (arch\-endian=little)little_endian_specific_symbol@Base 1.0
 (arch\-endian=big)big_endian_specific_symbol@Base 1.0

Multiple restrictions can be chained.

 (arch\-bits=32|arch\-endian=little)32bit_le_symbol@Base 1.0
.TP 
\fBignore\-blacklist\fP
dpkg\-gensymbols har en intern svartlista över symboler som inte skall
förekomma i symbolfiler eftersom de oftast bara är sidoeffekter från
implementationsdetaljer i verktygskedjan. Om du, av någon orsak, verkligen
vill att en av dessa symboler skall tas med i symbolfilen måste du tagga
symbolen med \fBignore\-blacklist\fP. Det kan vara nödvändigt för
lågnivå\-verktygskedjebibliotek som libgcc.
.TP 
\fBc++\fP
Betecknar \fIc++\fP\-symbolmönster. Se stycket \fBAnvända symbolmönster\fP nedan.
.TP 
\fBsymver\fP
Anger \fIsymver\fP (symbolversion)\-symbolmönstret. Se stycket \fBAnvända
symbolmönster\fP nedan.
.TP 
\fBregex\fP
Anger \fIregex\fP\-symbolmönstret. Se stycket \fIAnvända symbolmönster\fP nedan.
.SS "Använda symbolmönster"
.P
Till skillnad från vanliga symbolspecifikationer kan ett mönster täcka flera
faktiska symboler från biblioteket. \fBdpkg\-gensymbols\fP kommer försöka matcha
varje mönster mot varje faktisk symbol som \fIinte\fP har en motsvarande
specifik symbol definierad i symbolfilen. Så fort det första mönster som
motsvarar symbolen hittas kommer alla dess taggar och egenskaper att
användas som en basspecifikation för symbolen. Om inget mönster motsvarar
symbolen kommer den att tolkas som ny.

Ett mönster anses som tappat om det inte motsvarar några symboler i
biblioteket. Som standard kommer detta få \fBdpkg\-genchanges\fP att misslyckas
om \fB\-c1\fP eller högre anges. Om ett sådant misslyckande inte är önskvärt kan
mönstret dock märkas med taggen \fIoptional\fP. Om mönstret då inte motsvarar
någonting kommer det bara dyka upp i differensen som saknas
(MISSING). Mönstret kan dessutom, precis som andra symboler, begränsas till
specifika arkitekturer med hjälp av \fIarch\fP\-taggen. Se stycket
\fBStandardsymboltaggar\fP ovan för mer information.

Mönster är en utökning av \fBdeb\-symbols(5)\fP\-formatet och är därför endast
tillåtna i symbolfilmallar. Syntax för angivelse av mönster skiljer sig inte
från den för en specifik symbol. Symbolnamnsdelen av specifikationen
fungerar dock som ett uttryck som skall jämföras mot \fInamn@version\fP för den
faktiska symbolen. För att skilja mellan olika sorters mönster, taggas
mönster normalt med en speciell tagg.

För närvarande stöder \fBdpkg\-gensymbols\fP tre grundläggande mönstertyper:
.TP  3
\fBc++\fP
Detta mönster anges med taggen \fIc++\fP. Den matchar enbart C++\-symboler med
deras avmanglade symbolnamn (som det skrivs ut av
\fBc++filt\fP(1)\-verktyget). Det här mönstret är väldigt nyttigt för att matcha
symboler vars manglade namn kan skilja sig mellan olika arkitekturer, medan
deras avmanglade namn är desamma. En grupp dylika symboler är
\fIicke\-virtuella "thunks"\fP som har arkitekturspecifika offsetvärden inbyggda
i sina manglade namn. En vanlig instans av detta fall är en virtuell
destruktör som under diamantarv behöver en icke\-virtuell
"thunk"\-symbol. Även om till exempel ZThn8_N3NSB6ClassDD1Ev@Base på
32\-bitarsarkitekturer troligtvis är _ZThn16_N3NSB6ClassDD1Ev@Base
på64\-bitarsarkitekturer, så kan de matchas med ett enda \fIc++\fP\-mönster:

libdummy.so.1 libdummy1 #MINVER#
 [...]
 (c++)"non\-virtual thunk to NSB::ClassD::~ClassD()@Base" 1.0
 [...]

Det avmanglade namnet ovan kan hämtas genom att utföra följande kommando:

 $ echo '_ZThn8_N3NSB6ClassDD1Ev@Base' | c++filt

Observera att även om det manglade namnet per definition är unikt i
biblioteket gäller inte detta för avmanglade namn. Flera distinkta verkliga
symboler kan ha samma avmanglade namn. Det gäller till exempel för
icke\-virtuella "thunk"\-symboler i konfigurationer med komplexa arv eller för
de flesta konstruktörer och destruktörer (eftersom g++ normalt genererar två
symboler för dem). Eftersom dessa kollisioner sker på ABI\-nivån bör de dock
inte sänka kvaliteten på symbolfilen.
.TP 
\fBsymver\fP
Detta mönster anges med taggen \fIsymver\fP. Välunderhållna bibliotek har
versionshanterade symboler där varje version motsvarar uppströmsversionen
där symbolen lades till. Om det är fallet kan du använda ett
\fIsymver\fP\-möster för att matcha alla symboler som matchar den specifika
versionen. Till exempel:

libc.so.6 libc6 #MINVER#
 (symver)GLIBC_2.0 2.0
 [...]
 (symver)GLIBC_2.7 2.7
 access@GLIBC_2.0 2.2

Alla symboler associerade med versionerna GLIBC_2.0 och GLIBC_2.7 kommer
leda till den minimal version 2.0 respektive 2.7, med undantag av symbolen
access@GLIBC_2.0. Den sistnämnda kommer leda till ett minsta beroende på
libc6 version 2.2 trots att den motsvarar mönstret
"(symver)GLIBC_2.0"\-mönstret, eftersom specifika symboler gäller före
mönster.

Observera att även om den gamla sortens jokerteckenmönster (anges med
"*@version" i symbolnamnfältet) fortfarande stöds så rekommenderas de inte
längre i och med den nya sortens syntax "(symver|optional)version". Till
exempel bör "*@GLIBC_2.0 2.0" skrivas som "(symver|optional)GLIBC_2.0 2.0"
om samma beteende behövs.
.TP 
\fBregex\fP
Mönster med reguljära uttryck anges med taggen \fIregex\fP. De matchar med det
reguljära uttrycket på perl\-form som anges i symbolnamnsfältet. Ett
reguljärt uttryck matchar som det står, glöm därför inte att inleda det med
tecknet \fI^\fP, annars kommer det matcha godtycklig del av den verkliga
symbolens \fInamn@version\fP\-sträng. Till exempel:

libdummy.so.1 libdummy1 #MINVER#
 (regex)"^mystack_.*@Base$" 1.0
 (regex|optional)"private" 1.0

Symboler som "mystack_new@Base", "mystack_push@Base", "mystack_pop@Base"
osv. kommer att träffas av det första mönstret medan t.ex
"ng_mystack_new@Base" inte gör det. Det andra mönstret motsvarar alla
symbolen som innehåller strängen "private" i sina namn och träffar kommer
att ärva \fIoptional\fP\-taggen från mönstret.
.P
Grundläggande mönster som anges ovan kan kombineras där det är vettigt. I så
fall behandlas de i den ordning taggarna anges. Till exempel kommer både

 (c++|regex)"^NSA::ClassA::Private::privmethod\ed\e(int\e)@Base" 1.0
 (regex|c++)N3NSA6ClassA7Private11privmethod\edEi@Base 1.0

att träffa symbolerna "_ZN3NSA6ClassA7Private11privmethod1Ei@Base" och
"_ZN3NSA6ClassA7Private11privmethod2Ei@Base". När det första mönstret
jämförs avmanglas först symbolen som en C++\-symbol, varefter det avmanglade
namnet jämförs med det reguljära uttrycket. När det andra mönstret jämförs,
å andra sidan, jämförs det reguljära uttrycket mot det råa symbolnamnet,
varefter symbolen testas för att se om det är av C++\-typ genom att försöka
avmangla det. Om ett grundläggande mönster misslyckas kommer hela uttrycket
att misslyckas. Därför kommer, till exempel
"__N3NSA6ClassA7Private11privmethod\edEi@Base" inte att träffas av något av
mönstrena eftersom det inte är en giltig C++\-symbol.

I allmänhet delas alla mönster in i två grupper. alias (grundläggande \fIc++\fP
och \fIsymver\fP) och generella mönster (\fIregex\fP, samtliga kombinationer av
multipla grundläggande mönster). Det går snabbt att träffa grundläggande
aliasbaserade mönster (O(1)) medan generella mönster är O(N) (N \- antal
generella mönster) för varje symbol. Det rekommenderas därför inte att
använda för många generella mönster.

När flera mönster träffar samma verkliga symbol föredras alias (först
\fIc++\fP, sedan \fIsymver\fP) framför generella mönster. Generella mönster
träffas i den ordning de upptäcktes i symbolfilmallen fram till den första
lyckade träffen. Observera dock att manuell omsortering av poster i
mallfilen inte rekommenderas då \fBdpkg\-gensymbols\fP genererar differensfiler
baserad på den alfanumeriska sorteringsordningen av dess namn.
.SS "Använda inkluderingar"
.P
När uppsättningen av exporterade symboler skiljer sig mellan arkitekturer
kan det vara ineffektivt att använda en enda symbolfil. I dessa fall kan ett
inkluderingsdirektiv vara nyttigt på flera sätt:
.IP • 4
Du kan faktorisera de gemensamma delarna i en extern fil och inkludera den
filen i din \fIpaket\fP.symbols.\fIarkitektur\fP\-fil genom att använda ett
inkluderingsdirektiv som detta:

#include "\fIpaket\fP.symbols.common"
.IP •
Inkluderingsdirektivet kan även taggas som alla andra symboler:

(tag|...|tagN)#include "fil\-att\-inkludera"

Alla symboler som inkluderas från \fIfil\-att\-inkludera\fP kommer att anses som
standard vara taggade med \fItag\fP ... \fItagN\fP. Du kan använda denna funktion
för att skapa en gemensam \fIpaket\fP.symbols\-fil som inkluderar
arkitekturspecifika filer:

  gemensam_symbol1@Base 1.0
 (arch=amd64 ia64 alpha)#include "paket.symbols.64bit"
 (arch=!amd64 !ia64 !alpha)#include "paket.symbols.32bit"
  gemensam_symbol2@Base 1.0
.P
Symbolfilerna läses radvis, och inkluderingsdirektiv utförs så fort de
upptäcks. Det betyder att innehållet i den inkluderade filen kan överstyra
allt innehåll som förekom före inkluderingsdirektivet och att innehåll efter
direktivet kan överstyra allt från den inkluderade filen. Alla symboler
(även andra #include\-direktiv) i den inkluderade filen kan ange ytterligare
taggar eller överstyra värden för de ärvda taggarna i sin
taggspecifikation. Det finns dock inte något sätt för en symbol att ta bort
någon av sina ärvda taggar.
.P
En inkluderad fil kan repetera huvudraden som innehåller SONAMNet för
biblioteket. I så fall överstyr den en eventuell huvudrad som lästs in
tidigare. Det är vanligtvis dock bäst att undvika att duplicera
huvudrader. Ett sätt att göra det är som följer:
.PP
#include "libnågonting1.symbols.common"
 arkitekturspecifik_symbol@Base 1.0
.SS "God hantering av bibliotek"
.P
Ett välunderhållet bibliotek har följande funktioner:
.IP • 4
dess API är stabilt (publika symboler tas aldrig bort, endast nya publika
symboler läggs till) och inkompatibla ändringar görs endast när SONAMNet
ändras;
.IP • 4
ideellt använder det en versionhanterade symboler för att upprätthålla
ABI\-stabilitet trots interna ändringar och API\-utökningar;
.IP • 4
det exporterar inte privata symboler (sådana symboler kan taggas med
"optional" för att gå runt detta).
.P
När man underhåller symbolfilen är det lätt att upptäcka symboler som dyker
upp och försvinner. Det är svårare att upptäcka inkompatibla API\- och
ABI\-ändringar. Den paketansvarige bör därför noggrant läsa igenom
uppströmsändringsloggen för fall då reglerna för god hantering av bibliotek
bryts. Om ett möjligt fel upptäcks bör uppströmsförfattaren meddelas, då det
alltid är bättre att problemet rättas uppströms än specifikt i Debian.
.SH FLAGGOR
.TP 
\fB\-P\fP\fIpaketbyggkatalog\fP
Sök \fIpaketbyggkatalog\fP istället för debian/tmp.
.TP 
\fB\-p\fP\fIpaket\fP
Definiera paketnamnet. Krävs om mer än ett binärpaket listas i
debian/control (eller om det inte finns någon debian/control\-fil).
.TP 
\fB\-v\fP\fIversion\fP
Definiera paketversion. Standardvärdet är versionen som hämtas från
debian/changelog. Krävs om programmet anropas utanför ett källkodspaketträd.
.TP 
\fB\-e\fP\fIbiblioteksfil\fP
Analyserar endast bibliotek som listats explicit istället för att hitta alla
publika bibliotek. Du kan använda ett jokertecken för filnamn (se
manualsidan \fBFile::Glob\fP(3perl) för detaljer) i \fIbiblioteksfil\fP för att
träffa multipla bibliotek med ett enda argument (annars behöver du flera
\fB\-e\fP).
.TP 
\fB\-I\fP\fIfilnamn\fP
Använd \fIfilnamn\fP som referensfil för att generera symbolfilen som
integreras i själva paketet.
.TP 
\fB\-O\fP[\fIfilnamn\fP]
Visa den genererade symbolfilen på standard ut eller spara som \fIfilnamn\fP om
det anges, istället för \fBdebian/tmp/DEBIAN/symbols\fP (eller
\fIpaketbyggkatalog\fP\fB/DEBIAN/symbols\fP om \fB\-P\fP användes). Om \fIfilnamn\fP
redan existerar kommer dess innehåll att användas som bas för den genererade
symbolfilen. Du kan använda den här funktionen för att uppdatera en
symbolfil så att den motsvarar en nyare uppströmsversion av ditt bibliotek.
.TP 
\fB\-t\fP
Skriv symbolfilen i mall\-läge istället för i formatet kompatibelt med
\fBdeb\-symbols\fP(5). Huvudskillnaden är att symbolnamn och taggar skrivs i sin
originalform i mall\-läget, till skillnad från de efterbehandlade
symbolnamnen med borttagna taggar som skrivs i det kompatibla
läget. Dessutom kan vissa symboler uteslutas när en vanlig
\fBdeb\-symbols\fP(5)\-fil skrivs (i enlighet med tagghanteringsreglerna) medan
alla symboler alltid skrivs till symbolfilsmallen.
.TP 
\fB\-c\fP\fI[0\-4]\fP
Definiera vilka kontroller som skall utföras när den genererade symbolfilen
jämförs med den mallfil som används som startpunkt. Som standard är nivån
1. Genom att öka nivån utförs flera kontroller, inklusive alla kontroller på
lägre nivå. Nivå 2 misslyckas om nya symboler har introducerats. Nivå 3
misslyckas om några bibliotek har försvunnit. Nivå 4 misslyckas om några
bibliotek har introducerats.

Värdet kan överstyras med miljövariabeln \fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP.
.TP 
\fB\-q\fP
Håll tyst och generera aldrig en differens mellan den genererade symbolfilen
och mallfilen som användes som startpunkt eller visa varningar om
nya/förlorade bibliotek eller nya/förlorade symboler. Den här flaggan tar
endast bort informationsutdata, inte själva kontrolleran (se flaggan \fB\-c\fP).
.TP 
\fB\-a\fP\fIarkitektur\fP
Anta \fIarkitektur\fP som värdarkitektur vid hantering av symbolfiler. Använd
den här flaggan för att generera en symbolfil eller differens för valfri
arkitektur så länge dess binärer är tillgängliga.
.TP 
\fB\-d\fP
Aktiverar felsökningsläge. Flera meddelanden visas för att förklara vad
\fBdpkg\-gensymbols\fP gör.
.TP 
\fB\-V\fP
Aktivera pratsamt läge. Den genererade symbolfilen innehåller ej längre
rekommenderade symboler som kommentarer. I mall\-läge följs dessutom
mönstersymboler av kommentarer som visar vilka verkliga symboler som har
träffats av mönstret.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Visar hjälpskärm och avslutar.
.TP 
\fB\-\-version\fP
Visar version och avslutar.
.
.SH MILJÖVARIABLER
.TP 
\fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP
Overrides the command check level, even if the \fB\-c\fP command\-line argument
was given (note that this goes against the common convention of command\-line
arguments having precedence over environment variables).
.SH "SE ÄVEN"
\fBhttps://people.redhat.com/drepper/symbol\-versioning\fP
.br
\fBhttps://people.redhat.com/drepper/goodpractice.pdf\fP
.br
\fBhttps://people.redhat.com/drepper/dsohowto.pdf\fP
.br
\fBdeb\-symbols\fP(5), \fBdpkg\-shlibdeps\fP(1).
.SH ÖVERSÄTTNING
Peter Krefting och Daniel Nylander.
